package com.elitesland.tw.tw5crm.server.contract.workflow;

import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractPayload;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractVO;
import com.elitesland.tw.tw5crm.server.common.constants.ContractCollectionPlanStatus;
import com.elitesland.tw.tw5crm.server.contract.dao.ContractCollectionPlanDAO;
import com.elitesland.tw.tw5crm.server.contract.dao.ContractDAO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;

/**
 * 合同激活审批流程
 *
 * @author duwh
 * @date 2023/03/27
 */
@Slf4j
@RestController
@RequestMapping(WorkflowConstant.WORKFLOW + "CONTRACT" + WorkflowConstant.CALLBACK)
@Transactional
@RequiredArgsConstructor
public class ContractWorkflowController implements WorkflowCallBack {
    private final ContractDAO contractDAO;
    private final ContractCollectionPlanDAO contractCollectionPlanDAO;

    /**
     * 动态指定任务负责人
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_ASSIGNEE_PATH)
    public ArrayList<String> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("动态指定任务负责人参数: {}", payload);
        return null;
    }

    /**
     * 任务创建回调
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_CREATED_PATH)
    public void taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("任务创建后回调参数: {}", payload);
    }

    /**
     * 任务完成回调(只有正常推下一个节点,才算任务完成,其他从当前任务撤回/驳回都能不算当前任务完成,不会触发下面回调)
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_COMPLETED_PATH)
    public void taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("任务完成后回调参数: {}", payload);
    }

    /**
     * 流程状态变化回调
     */
    @Override
    @PostMapping(WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    @Transactional()
    public void processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("流程状态变化回调参数:{}", payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        ContractPayload updatePayload = new ContractPayload();
        final long id = Long.parseLong(businessKey);
        updatePayload.setId(id);
        //根据业务key查询当前业务对象
        final ContractVO vo = contractDAO.queryByKey(Long.valueOf(businessKey));
        updatePayload.setProcInstId(vo.getProcInstId());
        updatePayload.setSubmitTime(vo.getSubmitTime());
        updatePayload.setApprovedTime(vo.getApprovedTime());
        updatePayload.setProcInstStatus(procInstStatus);
        if (vo != null) {
            boolean deleteFlag = false;
            switch (procInstStatus) {
                case NOTSUBMIT://创建人提交节点
                    //一般情况将单据状态变成"新建",流程状态改为未提交
                    updatePayload.setContractStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    updatePayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    break;
                case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
                    //一般情况将单据状态变成"新建",并且将单据上的"流程实例状态"，"流程实例ID"清成null
                    updatePayload.setContractStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    break;
                case INVALID://作废 先删除流程再删除单据
                    //一般情况将单据状态变成"作废" ，或直接删除单据
                    updatePayload.setContractStatus(WorkFlowStatusEnum.INVALID.getCode());
                    updatePayload.setProcInstStatus(ProcInstStatus.INVALID);
                    deleteFlag = true;
                    break;
                case REJECTED://审批人拒绝，回到第一个节点
                    //将单据状态变为新建状态
                    updatePayload.setContractStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    updatePayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                case APPROVED:
                    //一般情况将单据状态变成"激活"
                    updatePayload.setContractStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
                    updatePayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    updatePayload.setApprovedTime(LocalDateTime.now());

                    // 收款计划 计划状态变更为激活
                    contractCollectionPlanDAO.updateStatusByContractId(ContractCollectionPlanStatus.ACTIVE.getCode(),vo.getId());
                    break;
                case APPROVING:
                    updatePayload.setContractStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
                    break;
            }
            contractDAO.updateWorkFlow(updatePayload);
            if (deleteFlag) {
                contractDAO.deleteSoft(Arrays.asList(id));
            }
        }
    }

}
