package com.elitesland.tw.tw5crm.server.open.controller;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5crm.api.open.payload.VisitTaskOpenPayload;
import com.elitesland.tw.tw5crm.api.visit.service.VisitTaskService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 开放api控制器
 *
 * @author duwh
 * @date 2023/03/13
 */
@Api(tags = "开放api")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/open/api")
@Slf4j
public class OpenApiController {

    private final VisitTaskService visitTaskService;

    /**
     * 客户评价 销售拜访任务
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping("task/customerEval")
    @ApiOperation("客户评价 销售拜访任务")
    public TwOutputUtil customerEval(@RequestBody VisitTaskOpenPayload payload) {
        return TwOutputUtil.ok(visitTaskService.customerEval(payload));
    }


}
