package com.elitesland.tw.tw5crm.server.oppo.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.coord.messenger.sender.provider.SmsRpcService;
import com.elitescloud.coord.messenger.sender.provider.param.TemplateSmsDTO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5crm.api.oppo.payload.OpportunityQuotePayload;
import com.elitesland.tw.tw5crm.api.oppo.query.OpportunityQuoteQuery;
import com.elitesland.tw.tw5crm.api.oppo.service.OpportunityQuoteService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.*;

/**
 * 商机报价
 *
 * @author liwenpeng
 * @date 2023-03-23
 */
@Api(tags = "商机报价")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/opportunity/quote")
@Slf4j
public class OpportunityQuoteController {

    private final OpportunityQuoteService opportunityQuoteService;

    private final SmsRpcService service;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("新增")
    public TwOutputUtil insert(@RequestBody OpportunityQuotePayload payload){
        return TwOutputUtil.ok(opportunityQuoteService.insert(payload));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("更新")
    public TwOutputUtil update(@RequestBody OpportunityQuotePayload payload){
        return TwOutputUtil.ok(opportunityQuoteService.update(payload));
    }

    @PutMapping("/change")
    @ApiOperation("变更")
    public TwOutputUtil change(@RequestBody OpportunityQuotePayload payload){
        return TwOutputUtil.ok(opportunityQuoteService.change(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("主键查询")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(opportunityQuoteService.queryByKey(key));
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("分页")
    public TwOutputUtil paging(OpportunityQuoteQuery query) {
        return TwOutputUtil.ok(opportunityQuoteService.queryPaging(query));
    }


    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        opportunityQuoteService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @GetMapping("/test/sendmessage")
    @ApiOperation("sendmessage")
    public TwOutputUtil sendmessage(){
        TemplateSmsDTO smsDTO  = new TemplateSmsDTO();

        Set<String> mobile =new HashSet<>();
        mobile.add("18638773413");

        Map<String,String> map=new HashMap<>();
        map.put("customer","Zach");

        smsDTO.setTemplateCode("SMS_114300083");
        smsDTO.setSignName("埃林哲");
        smsDTO.setMobiles(mobile);

        smsDTO.setSubject("Elitesland");
        smsDTO.setBusinessType("CRM-TESTSEND");
        smsDTO.setTemplateParams(map);



        ApiResult<Boolean> booleanApiResult = service.sendTemplateMsg(smsDTO);
        return TwOutputUtil.ok(booleanApiResult);
    }

}
