package com.elitesland.tw.tw5crm.server.oppo.dao;

import com.elitesland.tw.tw5crm.api.oppo.payload.OpportunityCostEstimateDetailsPayload;
import com.elitesland.tw.tw5crm.api.oppo.query.OpportunityCostEstimateDetailsQuery;
import com.elitesland.tw.tw5crm.api.oppo.vo.OpportunityCostEstimateDetailsVO;
import com.elitesland.tw.tw5crm.server.oppo.entity.OpportunityCostEstimateDetailsDO;
import com.elitesland.tw.tw5crm.server.oppo.entity.QOpportunityCostEstimateDetailsDO;
import com.elitesland.tw.tw5crm.server.oppo.repo.OpportunityCostEstimateDetailsRepo;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5crm.server.product.entity.QProductSkuDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 商机成本估算明细
 *
 * @author duwh
 * @date 2023-03-22
 */
@Repository
@RequiredArgsConstructor
public class OpportunityCostEstimateDetailsDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final OpportunityCostEstimateDetailsRepo repo;
    private final QOpportunityCostEstimateDetailsDO qdo = QOpportunityCostEstimateDetailsDO.opportunityCostEstimateDetailsDO;
    private final QProductSkuDO qProductSkuDO = QProductSkuDO.productSkuDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<OpportunityCostEstimateDetailsVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(OpportunityCostEstimateDetailsVO.class,
                qdo.id,
                qProductSkuDO.spuId,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 商机主键
                qdo.oppoId,
                // 商机成本估算主表id
                qdo.estimateId,
                // 商品sku主键
                qdo.skuId,
                // 产品SKU名称
                qdo.skuName,
                // 产品SKU编码
                qdo.skuCode,
                // 产品类型 udc[crm:product:spu_type]
                qdo.spuType,
                // 销售单位 udc[crm:product:sku_sale_unit]
                qdo.saleUnit,
                // 数量
                qdo.quantity,
                // 价目表价格
                qdo.markedMoney,
                // 成本价格
                qdo.costPrice,
                // 成本价格
                qdo.sumCostPrice,
                // 规格属性
                qdo.attributeStr,
                // 排序号
                qdo.sortNo,
                // 拓展字段1
                qdo.ext1,
                // 拓展字段2
                qdo.ext2,
                // 拓展字段3
                qdo.ext3,
                // 拓展字段4
                qdo.ext4,
                // 拓展字段5
                qdo.ext5
        )).from(qdo)
            .leftJoin(qProductSkuDO).on(qdo.skuId.eq(qProductSkuDO.id));
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<OpportunityCostEstimateDetailsVO> getJpaQueryWhere(OpportunityCostEstimateDetailsQuery query) {
        JPAQuery<OpportunityCostEstimateDetailsVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
            }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(OpportunityCostEstimateDetailsQuery query) {
        long total = jpaQueryFactory
            .select(qdo.count())
            .from(qdo)
            .leftJoin(qProductSkuDO).on(qdo.skuId.eq(qProductSkuDO.id))
            .where(where(query))
            .fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(OpportunityCostEstimateDetailsQuery query){
        List<Predicate> list = new ArrayList<>();
        qProductSkuDO.deleteFlag.eq(0);
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 商机主键 精确 */
        if (!ObjectUtils.isEmpty(query.getOppoId())) {
            list.add(qdo.oppoId.eq(query.getOppoId()));
        }
        /** 商机成本估算主表id 精确 */
        if (!ObjectUtils.isEmpty(query.getEstimateId())) {
            list.add(qdo.estimateId.eq(query.getEstimateId()));
        }
        /** 商品sku主键 精确 */
        if (!ObjectUtils.isEmpty(query.getSkuId())) {
            list.add(qdo.skuId.eq(query.getSkuId()));
        }
        /** 产品SKU名称 模糊 */
        if (!ObjectUtils.isEmpty(query.getSkuName())) {
             list.add(qdo.skuName.like(SqlUtil.toSqlLikeString(query.getSkuName())));
        }
        /** 产品SKU编码 模糊 */
        if (!ObjectUtils.isEmpty(query.getSkuCode())) {
             list.add(qdo.skuCode.like(SqlUtil.toSqlLikeString(query.getSkuCode())));
        }
        /** 产品类型 udc[crm:product:spu_type] 精确 */
        if (!ObjectUtils.isEmpty(query.getSpuType())) {
            list.add(qdo.spuType.eq(query.getSpuType()));
        }
        /** 销售单位 udc[crm:product:sku_sale_unit] 精确 */
        if (!ObjectUtils.isEmpty(query.getSaleUnit())) {
            list.add(qdo.saleUnit.eq(query.getSaleUnit()));
        }
        /** 数量 精确 */
        if (!ObjectUtils.isEmpty(query.getQuantity())) {
            list.add(qdo.quantity.eq(query.getQuantity()));
        }
        /** 价目表价格 精确 */
        if (!ObjectUtils.isEmpty(query.getMarkedMoney())) {
            list.add(qdo.markedMoney.eq(query.getMarkedMoney()));
        }
        /** 成本价格 精确 */
        if (!ObjectUtils.isEmpty(query.getCostPrice())) {
            list.add(qdo.costPrice.eq(query.getCostPrice()));
        }
        /** 成本价格 精确 */
        if (!ObjectUtils.isEmpty(query.getSumCostPrice())) {
            list.add(qdo.sumCostPrice.eq(query.getSumCostPrice()));
        }
        /** 规格属性 模糊 */
        if (!ObjectUtils.isEmpty(query.getAttributeStr())) {
             list.add(qdo.attributeStr.like(SqlUtil.toSqlLikeString(query.getAttributeStr())));
        }
        /** 排序号 精确 */
        if (!ObjectUtils.isEmpty(query.getSortNo())) {
            list.add(qdo.sortNo.eq(query.getSortNo()));
        }
        /** 拓展字段1 精确 */
        if (!ObjectUtils.isEmpty(query.getExt1())) {
            list.add(qdo.ext1.eq(query.getExt1()));
        }
        /** 拓展字段2 精确 */
        if (!ObjectUtils.isEmpty(query.getExt2())) {
            list.add(qdo.ext2.eq(query.getExt2()));
        }
        /** 拓展字段3 精确 */
        if (!ObjectUtils.isEmpty(query.getExt3())) {
            list.add(qdo.ext3.eq(query.getExt3()));
        }
        /** 拓展字段4 精确 */
        if (!ObjectUtils.isEmpty(query.getExt4())) {
            list.add(qdo.ext4.eq(query.getExt4()));
        }
        /** 拓展字段5 精确 */
        if (!ObjectUtils.isEmpty(query.getExt5())) {
            list.add(qdo.ext5.eq(query.getExt5()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public OpportunityCostEstimateDetailsVO queryByKey(Long id) {
        JPAQuery<OpportunityCostEstimateDetailsVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qProductSkuDO.deleteFlag.eq(0));
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<OpportunityCostEstimateDetailsVO> queryListDynamic(OpportunityCostEstimateDetailsQuery query) {
        JPAQuery<OpportunityCostEstimateDetailsVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<OpportunityCostEstimateDetailsVO> queryPaging(OpportunityCostEstimateDetailsQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<OpportunityCostEstimateDetailsVO> jpaQuery = getJpaQueryWhere(query);
        List<OpportunityCostEstimateDetailsVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<OpportunityCostEstimateDetailsVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public OpportunityCostEstimateDetailsDO save(OpportunityCostEstimateDetailsDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<OpportunityCostEstimateDetailsDO> saveAll(List<OpportunityCostEstimateDetailsDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(OpportunityCostEstimateDetailsPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 商机主键
        if (payload.getOppoId() != null) {
            update.set(qdo.oppoId, payload.getOppoId());
        }
        // 商机成本估算主表id
        if (payload.getEstimateId() != null) {
            update.set(qdo.estimateId, payload.getEstimateId());
        }
        // 商品sku主键
        if (payload.getSkuId() != null) {
            update.set(qdo.skuId, payload.getSkuId());
        }
        // 产品SKU名称
        if (payload.getSkuName() != null) {
            update.set(qdo.skuName, payload.getSkuName());
        }
        // 产品SKU编码
        if (payload.getSkuCode() != null) {
            update.set(qdo.skuCode, payload.getSkuCode());
        }
        // 产品类型 udc[crm:product:spu_type]
        if (payload.getSpuType() != null) {
            update.set(qdo.spuType, payload.getSpuType());
        }
        // 销售单位 udc[crm:product:sku_sale_unit]
        if (payload.getSaleUnit() != null) {
            update.set(qdo.saleUnit, payload.getSaleUnit());
        }
        // 数量
        if (payload.getQuantity() != null) {
            update.set(qdo.quantity, payload.getQuantity());
        }
        // 价目表价格
        if (payload.getMarkedMoney() != null) {
            update.set(qdo.markedMoney, payload.getMarkedMoney());
        }
        // 成本价格
        if (payload.getCostPrice() != null) {
            update.set(qdo.costPrice, payload.getCostPrice());
        }
        // 成本价格
        if (payload.getSumCostPrice() != null) {
            update.set(qdo.sumCostPrice, payload.getSumCostPrice());
        }
        // 规格属性
        if (payload.getAttributeStr() != null) {
            update.set(qdo.attributeStr, payload.getAttributeStr());
        }
        // 排序号
        if (payload.getSortNo() != null) {
            update.set(qdo.sortNo, payload.getSortNo());
        }
        // 拓展字段1
        if (payload.getExt1() != null) {
            update.set(qdo.ext1, payload.getExt1());
        }
        // 拓展字段2
        if (payload.getExt2() != null) {
            update.set(qdo.ext2, payload.getExt2());
        }
        // 拓展字段3
        if (payload.getExt3() != null) {
            update.set(qdo.ext3, payload.getExt3());
        }
        // 拓展字段4
        if (payload.getExt4() != null) {
            update.set(qdo.ext4, payload.getExt4());
        }
        // 拓展字段5
        if (payload.getExt5() != null) {
            update.set(qdo.ext5, payload.getExt5());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 商机主键
            if (nullFields.contains("oppoId")) {
                update.setNull(qdo.oppoId);
            }
            // 商机成本估算主表id
            if (nullFields.contains("estimateId")) {
                update.setNull(qdo.estimateId);
            }
            // 商品sku主键
            if (nullFields.contains("skuId")) {
                update.setNull(qdo.skuId);
            }
            // 产品SKU名称
            if (nullFields.contains("skuName")) {
                update.setNull(qdo.skuName);
            }
            // 产品SKU编码
            if (nullFields.contains("skuCode")) {
                update.setNull(qdo.skuCode);
            }
            // 产品类型 udc[crm:product:spu_type]
            if (nullFields.contains("spuType")) {
                update.setNull(qdo.spuType);
            }
            // 销售单位 udc[crm:product:sku_sale_unit]
            if (nullFields.contains("saleUnit")) {
                update.setNull(qdo.saleUnit);
            }
            // 数量
            if (nullFields.contains("quantity")) {
                update.setNull(qdo.quantity);
            }
            // 价目表价格
            if (nullFields.contains("markedMoney")) {
                update.setNull(qdo.markedMoney);
            }
            // 成本价格
            if (nullFields.contains("costPrice")) {
                update.setNull(qdo.costPrice);
            }
            // 成本价格
            if (nullFields.contains("sumCostPrice")) {
                update.setNull(qdo.sumCostPrice);
            }
            // 规格属性
            if (nullFields.contains("attributeStr")) {
                update.setNull(qdo.attributeStr);
            }
            // 排序号
            if (nullFields.contains("sortNo")) {
                update.setNull(qdo.sortNo);
            }
            // 拓展字段1
            if (nullFields.contains("ext1")) {
                update.setNull(qdo.ext1);
            }
            // 拓展字段2
            if (nullFields.contains("ext2")) {
                update.setNull(qdo.ext2);
            }
            // 拓展字段3
            if (nullFields.contains("ext3")) {
                update.setNull(qdo.ext3);
            }
            // 拓展字段4
            if (nullFields.contains("ext4")) {
                update.setNull(qdo.ext4);
            }
            // 拓展字段5
            if (nullFields.contains("ext5")) {
                update.setNull(qdo.ext5);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * 根据主表删除
     *
     * @param estimateId 估计id
     * @return long
     */
    public long deleteSoftByEstimateId(Long estimateId) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.estimateId.eq(estimateId));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

