package com.elitesland.tw.tw5crm.server.oppo.dao;

import com.elitesland.tw.tw5crm.api.oppo.payload.OpportunityQuoteDetailsPayload;
import com.elitesland.tw.tw5crm.api.oppo.query.OpportunityQuoteDetailsQuery;
import com.elitesland.tw.tw5crm.api.oppo.vo.OpportunityQuoteDetailsVO;
import com.elitesland.tw.tw5crm.server.oppo.entity.OpportunityQuoteDetailsDO;
import com.elitesland.tw.tw5crm.server.oppo.entity.QOpportunityQuoteDetailsDO;
import com.elitesland.tw.tw5crm.server.oppo.repo.OpportunityQuoteDetailsRepo;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 商机报价明细
 *
 * @author liwenpeng
 * @date 2023-03-23
 */
@Repository
@RequiredArgsConstructor
public class OpportunityQuoteDetailsDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final OpportunityQuoteDetailsRepo repo;
    private final QOpportunityQuoteDetailsDO qdo = QOpportunityQuoteDetailsDO.opportunityQuoteDetailsDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<OpportunityQuoteDetailsVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(OpportunityQuoteDetailsVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 商机报价id
                qdo.quoteId,
                // 商品sku主键
                qdo.skuId,
                // 产品SKU名称
                qdo.skuName,
                // 产品SKU编码
                qdo.skuCode,
                // 产品类型 udc[crm:product:spu_type]
                qdo.spuType,
                qdo.taxRate,
                // 销售单位 udc[crm:product:sku_sale_unit]
                qdo.saleUnit,
                // 数量
                qdo.quantity,
                // 成本价格
                qdo.costPrice,
                // 价目表
                qdo.priceName,
                // 毛利率
                qdo.grossMargin,
                // 排序号
                qdo.sortNo,
                // 拓展字段1
                qdo.extString1,
                // 拓展字段2
                qdo.extString2,
                // 拓展字段3
                qdo.extString3,
                // 拓展字段4
                qdo.extString4,
                // 拓展字段5
                qdo.extString5,
                // 价目表售价
                qdo.markedMoney,
                // 销售折扣
                qdo.salesDiscount,
                // 产品售价
                qdo.productPrice,
                // 产品含税售价
                qdo.productSalesIncludeTax,
                // 规格属性
                qdo.attributeStr
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<OpportunityQuoteDetailsVO> getJpaQueryWhere(OpportunityQuoteDetailsQuery query) {
        JPAQuery<OpportunityQuoteDetailsVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
            }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(OpportunityQuoteDetailsQuery query) {
        long total = jpaQueryFactory
            .select(qdo.count())
            .from(qdo)
            .where(where(query))
            .fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(OpportunityQuoteDetailsQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 商机报价id 精确 */
        if (!ObjectUtils.isEmpty(query.getQuoteId())) {
            list.add(qdo.quoteId.eq(query.getQuoteId()));
        }
        /** 商品sku主键 精确 */
        if (!ObjectUtils.isEmpty(query.getSkuId())) {
            list.add(qdo.skuId.eq(query.getSkuId()));
        }
        /** 产品SKU名称 模糊 */
        if (!ObjectUtils.isEmpty(query.getSkuName())) {
             list.add(qdo.skuName.like(SqlUtil.toSqlLikeString(query.getSkuName())));
        }
        /** 产品SKU编码 模糊 */
        if (!ObjectUtils.isEmpty(query.getSkuCode())) {
             list.add(qdo.skuCode.like(SqlUtil.toSqlLikeString(query.getSkuCode())));
        }
        /** 产品类型 udc[crm:product:spu_type] 精确 */
        if (!ObjectUtils.isEmpty(query.getSpuType())) {
            list.add(qdo.spuType.eq(query.getSpuType()));
        }
        /** 销售单位 udc[crm:product:sku_sale_unit] 精确 */
        if (!ObjectUtils.isEmpty(query.getSaleUnit())) {
            list.add(qdo.saleUnit.eq(query.getSaleUnit()));
        }
        /** 数量 精确 */
        if (!ObjectUtils.isEmpty(query.getQuantity())) {
            list.add(qdo.quantity.eq(query.getQuantity()));
        }
        /** 成本价格 精确 */
        if (!ObjectUtils.isEmpty(query.getCostPrice())) {
            list.add(qdo.costPrice.eq(query.getCostPrice()));
        }
        /** 价目表 模糊 */
        if (!ObjectUtils.isEmpty(query.getPriceName())) {
             list.add(qdo.priceName.like(SqlUtil.toSqlLikeString(query.getPriceName())));
        }
        /** 毛利率 精确 */
        if (!ObjectUtils.isEmpty(query.getGrossMargin())) {
            list.add(qdo.grossMargin.eq(query.getGrossMargin()));
        }
        /** 排序号 精确 */
        if (!ObjectUtils.isEmpty(query.getSortNo())) {
            list.add(qdo.sortNo.eq(query.getSortNo()));
        }
        /** 拓展字段1 精确 */
        if (!ObjectUtils.isEmpty(query.getExtString1())) {
            list.add(qdo.extString1.eq(query.getExtString1()));
        }
        /** 拓展字段2 精确 */
        if (!ObjectUtils.isEmpty(query.getExtString2())) {
            list.add(qdo.extString2.eq(query.getExtString2()));
        }
        /** 拓展字段3 精确 */
        if (!ObjectUtils.isEmpty(query.getExtString3())) {
            list.add(qdo.extString3.eq(query.getExtString3()));
        }
        /** 拓展字段4 精确 */
        if (!ObjectUtils.isEmpty(query.getExtString4())) {
            list.add(qdo.extString4.eq(query.getExtString4()));
        }
        /** 拓展字段5 精确 */
        if (!ObjectUtils.isEmpty(query.getExtString5())) {
            list.add(qdo.extString5.eq(query.getExtString5()));
        }
        /** 价目表售价 精确 */
        if (!ObjectUtils.isEmpty(query.getMarkedMoney())) {
            list.add(qdo.markedMoney.eq(query.getMarkedMoney()));
        }
        /** 销售折扣 精确 */
        if (!ObjectUtils.isEmpty(query.getSalesDiscount())) {
            list.add(qdo.salesDiscount.eq(query.getSalesDiscount()));
        }
        /** 产品售价 精确 */
        if (!ObjectUtils.isEmpty(query.getProductPrice())) {
            list.add(qdo.productPrice.eq(query.getProductPrice()));
        }
        /** 产品含税售价 精确 */
        if (!ObjectUtils.isEmpty(query.getProductSalesIncludeTax())) {
            list.add(qdo.productSalesIncludeTax.eq(query.getProductSalesIncludeTax()));
        }
        /** 规格属性 精确 */
        if (!ObjectUtils.isEmpty(query.getAttributeStr())) {
            list.add(qdo.attributeStr.eq(query.getAttributeStr()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public OpportunityQuoteDetailsVO queryByKey(Long id) {
        JPAQuery<OpportunityQuoteDetailsVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<OpportunityQuoteDetailsVO> queryListDynamic(OpportunityQuoteDetailsQuery query) {
        JPAQuery<OpportunityQuoteDetailsVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<OpportunityQuoteDetailsVO> queryPaging(OpportunityQuoteDetailsQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<OpportunityQuoteDetailsVO> jpaQuery = getJpaQueryWhere(query);
        List<OpportunityQuoteDetailsVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<OpportunityQuoteDetailsVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public OpportunityQuoteDetailsDO save(OpportunityQuoteDetailsDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<OpportunityQuoteDetailsDO> saveAll(List<OpportunityQuoteDetailsDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(OpportunityQuoteDetailsPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 商机报价id
        if (payload.getQuoteId() != null) {
            update.set(qdo.quoteId, payload.getQuoteId());
        }
        // 商品sku主键
        if (payload.getSkuId() != null) {
            update.set(qdo.skuId, payload.getSkuId());
        }
        // 产品SKU名称
        if (payload.getSkuName() != null) {
            update.set(qdo.skuName, payload.getSkuName());
        }
        // 产品SKU编码
        if (payload.getSkuCode() != null) {
            update.set(qdo.skuCode, payload.getSkuCode());
        }
        // 产品类型 udc[crm:product:spu_type]
        if (payload.getSpuType() != null) {
            update.set(qdo.spuType, payload.getSpuType());
        }
        // 销售单位 udc[crm:product:sku_sale_unit]
        if (payload.getSaleUnit() != null) {
            update.set(qdo.saleUnit, payload.getSaleUnit());
        }
        // 数量
        if (payload.getQuantity() != null) {
            update.set(qdo.quantity, payload.getQuantity());
        }
        // 成本价格
        if (payload.getCostPrice() != null) {
            update.set(qdo.costPrice, payload.getCostPrice());
        }
        // 价目表
        if (payload.getPriceName() != null) {
            update.set(qdo.priceName, payload.getPriceName());
        }
        // 毛利率
        if (payload.getGrossMargin() != null) {
            update.set(qdo.grossMargin, payload.getGrossMargin());
        }
        // 排序号
        if (payload.getSortNo() != null) {
            update.set(qdo.sortNo, payload.getSortNo());
        }
        // 拓展字段1
        if (payload.getExtString1() != null) {
            update.set(qdo.extString1, payload.getExtString1());
        }
        // 拓展字段2
        if (payload.getExtString2() != null) {
            update.set(qdo.extString2, payload.getExtString2());
        }
        // 拓展字段3
        if (payload.getExtString3() != null) {
            update.set(qdo.extString3, payload.getExtString3());
        }
        // 拓展字段4
        if (payload.getExtString4() != null) {
            update.set(qdo.extString4, payload.getExtString4());
        }
        // 拓展字段5
        if (payload.getExtString5() != null) {
            update.set(qdo.extString5, payload.getExtString5());
        }
        // 价目表售价
        if (payload.getMarkedMoney() != null) {
            update.set(qdo.markedMoney, payload.getMarkedMoney());
        }
        // 销售折扣
        if (payload.getSalesDiscount() != null) {
            update.set(qdo.salesDiscount, payload.getSalesDiscount());
        }
        // 产品售价
        if (payload.getProductPrice() != null) {
            update.set(qdo.productPrice, payload.getProductPrice());
        }
        // 产品含税售价
        if (payload.getProductSalesIncludeTax() != null) {
            update.set(qdo.productSalesIncludeTax, payload.getProductSalesIncludeTax());
        }
        // 规格属性
        if (payload.getAttributeStr() != null) {
            update.set(qdo.attributeStr, payload.getAttributeStr());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 商机报价id
            if (nullFields.contains("quoteId")) {
                update.setNull(qdo.quoteId);
            }
            // 商品sku主键
            if (nullFields.contains("skuId")) {
                update.setNull(qdo.skuId);
            }
            // 产品SKU名称
            if (nullFields.contains("skuName")) {
                update.setNull(qdo.skuName);
            }
            // 产品SKU编码
            if (nullFields.contains("skuCode")) {
                update.setNull(qdo.skuCode);
            }
            // 产品类型 udc[crm:product:spu_type]
            if (nullFields.contains("spuType")) {
                update.setNull(qdo.spuType);
            }
            // 销售单位 udc[crm:product:sku_sale_unit]
            if (nullFields.contains("saleUnit")) {
                update.setNull(qdo.saleUnit);
            }
            // 数量
            if (nullFields.contains("quantity")) {
                update.setNull(qdo.quantity);
            }
            // 成本价格
            if (nullFields.contains("costPrice")) {
                update.setNull(qdo.costPrice);
            }
            // 价目表
            if (nullFields.contains("priceName")) {
                update.setNull(qdo.priceName);
            }
            // 毛利率
            if (nullFields.contains("grossMargin")) {
                update.setNull(qdo.grossMargin);
            }
            // 排序号
            if (nullFields.contains("sortNo")) {
                update.setNull(qdo.sortNo);
            }
            // 拓展字段1
            if (nullFields.contains("extString1")) {
                update.setNull(qdo.extString1);
            }
            // 拓展字段2
            if (nullFields.contains("extString2")) {
                update.setNull(qdo.extString2);
            }
            // 拓展字段3
            if (nullFields.contains("extString3")) {
                update.setNull(qdo.extString3);
            }
            // 拓展字段4
            if (nullFields.contains("extString4")) {
                update.setNull(qdo.extString4);
            }
            // 拓展字段5
            if (nullFields.contains("extString5")) {
                update.setNull(qdo.extString5);
            }
            // 价目表售价
            if (nullFields.contains("markedMoney")) {
                update.setNull(qdo.markedMoney);
            }
            // 销售折扣
            if (nullFields.contains("salesDiscount")) {
                update.setNull(qdo.salesDiscount);
            }
            // 产品售价
            if (nullFields.contains("productPrice")) {
                update.setNull(qdo.productPrice);
            }
            // 产品含税售价
            if (nullFields.contains("productSalesIncludeTax")) {
                update.setNull(qdo.productSalesIncludeTax);
            }
            // 规格属性
            if (nullFields.contains("attributeStr")) {
                update.setNull(qdo.attributeStr);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    public long deleteByQuoteId(Long quoteId) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.quoteId.eq(quoteId));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

