package com.elitesland.tw.tw5crm.server.oppo.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 商机成本估算
 *
 * @author duwh
 * @date 2023-03-23
 */
@Entity
@Table(name = "crm_opportunity_cost_estimate", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_opportunity_cost_estimate", comment = "商机成本估算")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class OpportunityCostEstimateDO extends BaseModel implements Serializable  {
    /** 编号 */
    @Comment("编号")
    @Column()
    private String code;
    /** 商机主键 */
    @Comment("商机主键")
    @Column()
    private Long oppoId;
    /** 审核状态 */
    @Comment("审核状态")
    @Column()
    private String apprStatus;
    /** 成本单金额 */
    @Comment("成本单金额")
    @Column()
    private BigDecimal costAmt;
    /** 币种 udc[SYSTEM_BASIC:CURRENCY] */
    @Comment("币种 udc[SYSTEM_BASIC:CURRENCY]")
    @Column()
    private String currCode;
    /** 版本 */
    @Comment("版本")
    @Column()
    private String version;
    /** 流程实例ID */
    @Comment("流程实例ID")
    @Column()
    private String procInstId;
    /** 流程实例状态 */
    @Column
    @Comment("流程实例状态")
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;
    /** 提交时间 */
    @Comment("提交时间")
    @Column()
    private LocalDateTime submitTime;
    /** 审批时间 */
    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;
    /** 排序号 */
    @Comment("排序号")
    @Column()
    private Integer sortNo;
    /** 拓展字段1 */
    @Comment("拓展字段1")
    @Column()
    private String ext1;
    /** 拓展字段2 */
    @Comment("拓展字段2")
    @Column()
    private String ext2;
    /** 拓展字段3 */
    @Comment("拓展字段3")
    @Column()
    private String ext3;
    /** 拓展字段4 */
    @Comment("拓展字段4")
    @Column()
    private String ext4;
    /** 拓展字段5 */
    @Comment("拓展字段5")
    @Column()
    private String ext5;
    /** 归属部门主键 */
    @Comment("归属部门主键")
    @Column()
    private Long orgId;
    /** 负责人主键 */
    @Comment("负责人主键")
    @Column()
    private Long manageUserId;

    public void copy(OpportunityCostEstimateDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
