package com.elitesland.tw.tw5crm.server.oppo.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 商机成本估算明细
 *
 * @author duwh
 * @date 2023-03-22
 */
@Entity
@Table(name = "crm_opportunity_cost_estimate_details", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_opportunity_cost_estimate_details", comment = "商机成本估算明细")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class OpportunityCostEstimateDetailsDO extends BaseModel implements Serializable  {
    /** 商机主键 */
    @Comment("商机主键")
    @Column()
    private Long oppoId;
    /** 商机成本估算主表id */
    @Comment("商机成本估算主表id")
    @Column()
    private Long estimateId;
    /** 商品sku主键 */
    @Comment("商品sku主键")
    @Column()
    private Long skuId;
    /** 产品SKU名称 */
    @Comment("产品SKU名称")
    @Column()
    private String skuName;
    /** 产品SKU编码 */
    @Comment("产品SKU编码")
    @Column()
    private String skuCode;
    /** 产品类型 udc[crm:product:spu_type] */
    @Comment("产品类型 udc[crm:product:spu_type]")
    @Column()
    private String spuType;
    /** 销售单位 udc[crm:product:sku_sale_unit] */
    @Comment("销售单位 udc[crm:product:sku_sale_unit]")
    @Column()
    private String saleUnit;
    /** 数量 */
    @Comment("数量")
    @Column()
    private Integer quantity;
    /** 价目表价格 */
    @Comment("价目表价格")
    @Column()
    private BigDecimal markedMoney;
    /** 成本价格 */
    @Comment("成本价格")
    @Column()
    private BigDecimal costPrice;
    /** 成本价格 */
    @Comment("成本价格")
    @Column()
    private BigDecimal sumCostPrice;
    /** 规格属性 */
    @Comment("规格属性")
    @Column()
    private String attributeStr;
    /** 排序号 */
    @Comment("排序号")
    @Column()
    private Integer sortNo;
    /** 拓展字段1 */
    @Comment("拓展字段1")
    @Column()
    private String ext1;
    /** 拓展字段2 */
    @Comment("拓展字段2")
    @Column()
    private String ext2;
    /** 拓展字段3 */
    @Comment("拓展字段3")
    @Column()
    private String ext3;
    /** 拓展字段4 */
    @Comment("拓展字段4")
    @Column()
    private String ext4;
    /** 拓展字段5 */
    @Comment("拓展字段5")
    @Column()
    private String ext5;

    public void copy(OpportunityCostEstimateDetailsDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
