package com.elitesland.tw.tw5crm.server.oppo.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 商机报价
 *
 * @author liwenpeng
 * @date 2023-03-23
 */
@Entity
@Table(name = "crm_opportunity_quote", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_opportunity_quote", comment = "商机报价")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class OpportunityQuoteDO extends BaseModel implements Serializable  {
    /** 商机主键 */
    @Comment("商机主键")
    @Column()
    private Long oppoId;

    /** 报价单编码 */
    @Comment("报价单编码")
    @Column()
    private String quoteNo;

    /** 报价单状态 */
    @Comment("报价单状态")
    @Column()
    private String quoteStatus;

    /** 客户名称 */
    @Comment("客户名称")
    @Column()
    private String customerName;

    /** 整单折扣 */
    @Comment("整单折扣")
    @Column()
    private String wholeOrderDiscount;

    /** 报价单金额 */
    @Comment("报价单金额")
    @Column()
    private BigDecimal quoteAmt;

    /** 报价单金额(含税) */
    @Comment("报价单金额(含税)")
    @Column()
    private BigDecimal quoteTaxAmt;

    /** 币种 udc[SYSTEM_BASIC:CURRENCY] */
    @Comment("币种 udc[SYSTEM_BASIC:CURRENCY]")
    @Column()
    private String currCode;

    /** 归属部门 */
    @Comment("归属部门")
    @Column()
    private Long orgId;

    /** 负责人 */
    @Comment("负责人")
    @Column()
    private Long manageUserId;

    /** 报价日期 */
    @Comment("报价日期")
    @Column()
    private LocalDate quoteDate;

    /** 版本 */
    @Comment("版本")
    @Column()
    private String version;

    /** 流程实例ID */
    @Comment("流程实例ID")
    @Column()
    private String procInstId;

    /** 流程审批状态 */
    @Comment("流程审批状态")
    @Column()
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;

    /** 提交时间 */
    @Comment("提交时间")
    @Column()
    private LocalDateTime submitTime;

    /** 审批时间 */
    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;

    /** 排序号 */
    @Comment("排序号")
    @Column()
    private Integer sortNo;

    /** 拓展字段1 */
    @Comment("拓展字段1")
    @Column()
    private String extString1;

    /** 拓展字段2 */
    @Comment("拓展字段2")
    @Column()
    private String extString2;

    /** 拓展字段3 */
    @Comment("拓展字段3")
    @Column()
    private String extString3;

    /** 拓展字段4 */
    @Comment("拓展字段4")
    @Column()
    private String extString4;

    /** 拓展字段5 */
    @Comment("拓展字段5")
    @Column()
    private String extString5;


    public void copy(OpportunityQuoteDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
