package com.elitesland.tw.tw5crm.server.oppo.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;
import java.math.BigDecimal;

/**
 * 商机报价明细
 *
 * @author liwenpeng
 * @date 2023-03-23
 */
@Entity
@Table(name = "crm_opportunity_quote_details", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_opportunity_quote_details", comment = "商机报价明细")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class OpportunityQuoteDetailsDO extends BaseModel implements Serializable  {
    /** 商机报价id */
    @Comment("商机报价id")
    @Column()
    private Long quoteId;
    /** 商品sku主键 */
    @Comment("商品sku主键")
    @Column()
    private Long skuId;
    /** 产品SKU名称 */
    @Comment("产品SKU名称")
    @Column()
    private String skuName;
    /** 产品SKU编码 */
    @Comment("产品SKU编码")
    @Column()
    private String skuCode;
    /** 产品类型 udc[crm:product:spu_type] */
    @Comment("产品类型 udc[crm:product:spu_type]")
    @Column()
    private String spuType;

    /** 税率 */
    @Comment("税率")
    @Column()
    private BigDecimal taxRate;

    /** 销售单位 udc[crm:product:sku_sale_unit] */
    @Comment("销售单位 udc[crm:product:sku_sale_unit]")
    @Column()
    private String saleUnit;
    /** 数量 */
    @Comment("数量")
    @Column()
    private Integer quantity;
    /** 成本价格 */
    @Comment("成本价格")
    @Column()
    private BigDecimal costPrice;
    /** 价目表 */
    @Comment("价目表")
    @Column()
    private String priceName;

    /** 价目表售价 */
    @Comment("价目表售价")
    @Column()
    private BigDecimal markedMoney;
    /** 销售折扣 */
    @Comment("销售折扣")
    @Column()
    private BigDecimal salesDiscount;
    /** 产品售价 */
    @Comment("产品售价")
    @Column()
    private BigDecimal productPrice;
    /** 产品含税售价 */
    @Comment("产品含税售价")
    @Column()
    private BigDecimal productSalesIncludeTax;
    /** 规格属性 */
    @Comment("规格属性")
    @Column()
    private String attributeStr;

    /** 毛利率 */
    @Comment("毛利率")
    @Column()
    private BigDecimal grossMargin;
    /** 排序号 */
    @Comment("排序号")
    @Column()
    private Integer sortNo;
    /** 拓展字段1 */
    @Comment("拓展字段1")
    @Column()
    private String extString1;
    /** 拓展字段2 */
    @Comment("拓展字段2")
    @Column()
    private String extString2;
    /** 拓展字段3 */
    @Comment("拓展字段3")
    @Column()
    private String extString3;
    /** 拓展字段4 */
    @Comment("拓展字段4")
    @Column()
    private String extString4;
    /** 拓展字段5 */
    @Comment("拓展字段5")
    @Column()
    private String extString5;


    public void copy(OpportunityQuoteDetailsDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
