package com.elitesland.tw.tw5crm.server.oppo.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5crm.api.oppo.payload.OpportunityCostEstimateDetailsPayload;
import com.elitesland.tw.tw5crm.api.oppo.query.OpportunityCostEstimateDetailsQuery;
import com.elitesland.tw.tw5crm.api.oppo.service.OpportunityCostEstimateDetailsService;
import com.elitesland.tw.tw5crm.api.oppo.vo.OpportunityCostEstimateDetailsVO;
import com.elitesland.tw.tw5crm.server.oppo.convert.OpportunityCostEstimateDetailsConvert;
import com.elitesland.tw.tw5crm.server.oppo.dao.OpportunityCostEstimateDetailsDAO;
import com.elitesland.tw.tw5crm.server.oppo.entity.OpportunityCostEstimateDetailsDO;
import com.elitesland.tw.tw5crm.server.oppo.repo.OpportunityCostEstimateDetailsRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Optional;

/**
 * 商机成本估算明细
 *
 * @author duwh
 * @date 2023-03-22
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class OpportunityCostEstimateDetailsServiceImpl extends BaseServiceImpl implements OpportunityCostEstimateDetailsService {

    private final OpportunityCostEstimateDetailsRepo opportunityCostEstimateDetailsRepo;
    private final OpportunityCostEstimateDetailsDAO opportunityCostEstimateDetailsDAO;

    @Override
    public PagingVO<OpportunityCostEstimateDetailsVO> paging(OpportunityCostEstimateDetailsQuery query) {
        Page<OpportunityCostEstimateDetailsDO> page = opportunityCostEstimateDetailsRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest());
        return PageUtil.toPageVo(page.map(OpportunityCostEstimateDetailsConvert.INSTANCE::toVo));
    }

    @Override
    public PagingVO<OpportunityCostEstimateDetailsVO> queryPaging(OpportunityCostEstimateDetailsQuery query) {
        return opportunityCostEstimateDetailsDAO.queryPaging(query);
    }

    @Override
    public List<OpportunityCostEstimateDetailsVO> queryList(OpportunityCostEstimateDetailsQuery query) {
        return OpportunityCostEstimateDetailsConvert.INSTANCE.toVoList(
            opportunityCostEstimateDetailsRepo.findAll(
                (root, criteriaQuery, criteriaBuilder)
                    -> QueryHelp.getPredicate(root, query, criteriaBuilder)
                , query.getPageRequest().getSort()
            )
        );
    }

    @Override
    public List<OpportunityCostEstimateDetailsVO> queryListDynamic(OpportunityCostEstimateDetailsQuery query) {
        return opportunityCostEstimateDetailsDAO.queryListDynamic(query);
    }

    @Override
    public OpportunityCostEstimateDetailsVO queryByKey(Long key) {
        OpportunityCostEstimateDetailsDO entity = opportunityCostEstimateDetailsRepo.findById(key).orElseGet(OpportunityCostEstimateDetailsDO::new);
        Assert.notNull(entity.getId(), "不存在");
        OpportunityCostEstimateDetailsVO vo = OpportunityCostEstimateDetailsConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public OpportunityCostEstimateDetailsVO insert(OpportunityCostEstimateDetailsPayload payload) {
        OpportunityCostEstimateDetailsDO entityDo = OpportunityCostEstimateDetailsConvert.INSTANCE.toDo(payload);
        return OpportunityCostEstimateDetailsConvert.INSTANCE.toVo(opportunityCostEstimateDetailsRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public OpportunityCostEstimateDetailsVO update(OpportunityCostEstimateDetailsPayload payload) {
        OpportunityCostEstimateDetailsDO entity = opportunityCostEstimateDetailsRepo.findById(payload.getId()).orElseGet(OpportunityCostEstimateDetailsDO::new);
        Assert.notNull(entity.getId(), "不存在");
        OpportunityCostEstimateDetailsDO entityDo = OpportunityCostEstimateDetailsConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return OpportunityCostEstimateDetailsConvert.INSTANCE.toVo(opportunityCostEstimateDetailsRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<OpportunityCostEstimateDetailsDO> optional = opportunityCostEstimateDetailsRepo.findById(id);
                if (!optional.isEmpty()) {
                    OpportunityCostEstimateDetailsDO entity = optional.get();
                    entity.setDeleteFlag(1);
                    opportunityCostEstimateDetailsRepo.save(entity);
                }
            });
        }
    }

    @Override
    public long deleteSoftByEstimateId(Long estimateId) {
        if (null != estimateId) {
            return opportunityCostEstimateDetailsDAO.deleteSoftByEstimateId(estimateId);
        }
        return 0L;
    }

}
