package com.elitesland.tw.tw5crm.server.oppo.service;

import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.common.TwWorkFlowCommonVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.common.workFlow.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import com.elitesland.tw.tw5crm.api.common.change.payload.ComBusinessChangePayload;
import com.elitesland.tw.tw5crm.api.common.change.service.ComBusinessChangeService;
import com.elitesland.tw.tw5crm.api.common.change.vo.ComBusinessChangeVO;
import com.elitesland.tw.tw5crm.api.oppo.payload.OpportunityCostEstimateDetailsPayload;
import com.elitesland.tw.tw5crm.api.oppo.payload.OpportunityCostEstimatePayload;
import com.elitesland.tw.tw5crm.api.oppo.query.OpportunityCostEstimateDetailsQuery;
import com.elitesland.tw.tw5crm.api.oppo.query.OpportunityCostEstimateQuery;
import com.elitesland.tw.tw5crm.api.oppo.service.OpportunityCostEstimateDetailsService;
import com.elitesland.tw.tw5crm.api.oppo.service.OpportunityCostEstimateService;
import com.elitesland.tw.tw5crm.api.oppo.vo.OpportunityCostEstimateDetailsVO;
import com.elitesland.tw.tw5crm.api.oppo.vo.OpportunityCostEstimateVO;
import com.elitesland.tw.tw5crm.server.common.change.changeTypeEnum.ChangeTypeEnum;
import com.elitesland.tw.tw5crm.server.common.change.dao.ComBusinessChangeDAO;
import com.elitesland.tw.tw5crm.server.common.constants.GenerateSeqNumConstants;
import com.elitesland.tw.tw5crm.server.oppo.convert.OpportunityCostEstimateConvert;
import com.elitesland.tw.tw5crm.server.oppo.dao.OpportunityCostEstimateDAO;
import com.elitesland.tw.tw5crm.server.oppo.entity.OpportunityCostEstimateDO;
import com.elitesland.tw.tw5crm.server.oppo.repo.OpportunityCostEstimateRepo;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.TaskInfo;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.payload.CurrentTaskInfosPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.google.common.collect.Lists;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.time.LocalDateTime;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 商机成本估算
 *
 * @author duwh
 * @date 2023-03-22
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class OpportunityCostEstimateServiceImpl extends BaseServiceImpl implements OpportunityCostEstimateService {

    private final OpportunityCostEstimateRepo opportunityCostEstimateRepo;
    private final OpportunityCostEstimateDAO opportunityCostEstimateDAO;
    private final OpportunityCostEstimateDetailsService opportunityCostEstimateDetailsService;
    private final CacheUtil cacheUtil;
    private final WorkflowUtil workflowUtil;
    private final ComBusinessChangeService businessChangeService;
    private final ComBusinessChangeDAO businessChangeDao;
    private final WorkflowService workflowService;
    private final UdcUtil udcUtil;
    private final TransactionUtilService transactionUtilService;
    @Value("${tw5.workflow.enabled:false}")
    private Boolean workflow_enabled;
    /**
     * 商机成本估算审批流归属部门负责人审批节点id
     */
    private final String FLOW_BU_MANAGER_NODE_ID = "Activity_02uvbcr";
    /**
     * 商机成本估算变更审批流归属部门负责人审批节点id
     */
    private final String FLOW_BU_MANAGER_CHANGE_NODE_ID = "Activity_0mln9fy";


    @Override
    public PagingVO<OpportunityCostEstimateVO> queryPaging(OpportunityCostEstimateQuery query) {
        final PagingVO<OpportunityCostEstimateVO> pagingVO = opportunityCostEstimateDAO.queryPaging(query);
        final List<OpportunityCostEstimateVO> voList = pagingVO.getRecords();
        // 获取任务信息
        getTaskInfo(voList);
        voList.stream().forEach(opportunityCostEstimateVO -> {
            // 查询明细
            getDetails(opportunityCostEstimateVO.getId(), opportunityCostEstimateVO);
            // 翻译
            translation(opportunityCostEstimateVO.getDetails());
        });
        return pagingVO;
    }

    /**
     * 获取工作流审批信息
     *
     * @param voList 签证官列表
     */
    private void getTaskInfo(List<OpportunityCostEstimateVO> voList) {
        // 查询当前处理的任务名称
        if (!CollectionUtils.isEmpty(voList)) {
            // 1、组装成map，key为流程实例Id,value为对象
            Map<String, TwWorkFlowCommonVO> map = voList
                .stream()
                .filter(vo -> StringUtils.isNoneBlank(vo.getProcInstId()))
                .collect(Collectors.toMap(TwWorkFlowCommonVO::getProcInstId, Function.identity()));
            if (null != map && map.isEmpty() == false) {
                // 2、查询当前处理的任务名称
                final Set<String> procInstIds = map.keySet();
                HashSet hashSet = new HashSet(procInstIds);
                // 3、设置任务名称到业务对象上
                CurrentTaskInfosPayload currentTaskInfosPayload = new CurrentTaskInfosPayload();
                currentTaskInfosPayload.setProcInstIds(hashSet);
                // 调用工作流程方法查询任务信息
                final WorkflowResult<HashMap<String, TaskInfo>> workflowResult = workflowService.currentTaskInfos(currentTaskInfosPayload);
                if (workflowResult.isSuccess()) {
                    HashMap<String, TaskInfo> currentTaskNames = workflowResult.getData();
                    // 3、设置任务名称到业务对象上
                    currentTaskNames.forEach((key, value) -> {
                        TwWorkFlowCommonVO vo = map.get(key);
                        vo.setTaskInfo(value);
                    });
                }
            }
        }
    }

    /**
     * 翻译
     *
     * @param voList 签证官列表
     */
    private void translation(List<OpportunityCostEstimateDetailsVO> voList) {
        voList.stream().forEach(detailsVO -> {
            final PrdSystemSelectionVO prdSystemSelectionVO = cacheUtil.transferSystemSelectionObj("crm:product:spu_type", detailsVO.getSpuType());
            detailsVO.setTaxRate(null != prdSystemSelectionVO ? prdSystemSelectionVO.getExtString1() : "");
        });
    }

    @Override
    public List<OpportunityCostEstimateVO> queryListDynamic(OpportunityCostEstimateQuery query) {
        final List<OpportunityCostEstimateVO> voList = opportunityCostEstimateDAO.queryListDynamic(query);
        //voList.stream().forEach(opportunityCostEstimateVO -> {
        //    // 查询明细
        //    getDetails(opportunityCostEstimateVO.getId(), opportunityCostEstimateVO);
        //});
        return voList;
    }

    @Override
    public OpportunityCostEstimateVO queryByKey(Long key) {
        OpportunityCostEstimateDO entity = opportunityCostEstimateRepo.findById(key).orElseGet(OpportunityCostEstimateDO::new);
        Assert.notNull(entity.getId(), "商机成本估算不存在");
        OpportunityCostEstimateVO vo = OpportunityCostEstimateConvert.INSTANCE.toVo(entity);
        // 流程信息回显
        final WorkflowResult<TaskInfo> workflowResult = workflowService.currentTaskInfo(vo.getProcInstId());
        if (workflowResult.isSuccess()) {
            TaskInfo taskInfo = workflowResult.getData();
            vo.setTaskInfo(taskInfo);
        }
        // 查询明细
        getDetails(key, vo);
        return vo;
    }

    private void getDetails(Long key, OpportunityCostEstimateVO vo) {
        OpportunityCostEstimateDetailsQuery detailsQuery = new OpportunityCostEstimateDetailsQuery();
        detailsQuery.setEstimateId(key);
        final List<OpportunityCostEstimateDetailsVO> detailsVOList = opportunityCostEstimateDetailsService.queryListDynamic(detailsQuery);
        vo.setDetails(detailsVOList);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public OpportunityCostEstimateVO insert(OpportunityCostEstimatePayload payload) {

        // 数据检查
        check(payload);

        // 数据处理
        dataProcess(payload);

        OpportunityCostEstimateDO entityDo = OpportunityCostEstimateConvert.INSTANCE.toDo(payload);
        final OpportunityCostEstimateDO save = opportunityCostEstimateRepo.save(entityDo);

        // 保存明细
        saveDetails(save, payload.getDetails());

        //数据提交,执行工作流
        if (payload.getSubmit()) {
            payload.setId(save.getId());
            submitProc(payload);

        }
        return OpportunityCostEstimateConvert.INSTANCE.toVo(save);
    }

    /**
     * 保存明细
     *
     * @param entity  实体
     * @param details 细节
     */
    private void saveDetails(OpportunityCostEstimateDO entity, List<OpportunityCostEstimateDetailsPayload> details) {
        final Long estimateId = entity.getId();
        // 先清空 再插入明细
        opportunityCostEstimateDetailsService.deleteSoftByEstimateId(estimateId);
        if (!CollectionUtils.isEmpty(details)) {
            for (OpportunityCostEstimateDetailsPayload detail : details) {
                detail.setEstimateId(estimateId);
                detail.setOppoId(entity.getOppoId());
                opportunityCostEstimateDetailsService.insert(detail);
            }
        }

    }

    /**
     * 数据处理
     *
     * @param payload 有效载荷
     */
    private void dataProcess(OpportunityCostEstimatePayload payload) {
        // 编号处理
        if (ObjectUtils.isEmpty(payload.getCode())) {
            String code = generateSeqNum(GenerateSeqNumConstants.CRM_OPPO_COST_ESTIMATE);
            payload.setCode(code);
        }
        if (ObjectUtils.isEmpty(payload.getApprStatus())) {
            payload.setApprStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
        }
        if (ObjectUtils.isEmpty(payload.getVersion())) {
            payload.setVersion("v0");
        }
    }

    /**
     * 检查
     *
     * @param payload 有效载荷
     */
    private void check(OpportunityCostEstimatePayload payload) {
        if (payload.getOppoId() == null) {
            throw TwException.error("", "oppoId参数缺失");
        }

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public OpportunityCostEstimateVO update(OpportunityCostEstimatePayload payload) {
        final OpportunityCostEstimateVO vo = queryByKey(payload.getId());
        final String apprStatus = vo.getApprStatus();
        if (apprStatus.equals(WorkFlowStatusEnum.CREATE_WORK.getCode())) {
            final OpportunityCostEstimateVO result = updatePro(payload);
            //数据提交,执行工作流
            if (payload.getSubmit()) {
                submitProc(payload);
            }
            return result;
        } else if (apprStatus.equals(WorkFlowStatusEnum.APPROVED_WORK.getCode())) {
            //激活状态的变更
            Long saveId = businessChangeService.save(ChangeTypeEnum.OPPO_COST_ESTIMATE.getCode(), vo, payload, payload.getId() + "");

            // 启动变更流程
            //ProcessInfo processInfo = startChangeWorkFlow(vo, saveId);
            ProcessInfo processInfo = new ProcessInfo();
            String apprStatusTemp = WorkFlowStatusEnum.APPROVED_WORK.getCode();
            String changeApprStatusTemp = WorkFlowStatusEnum.APPROVED_WORK.getCode();
            String changeStatusTemp = WorkFlowStatusEnum.APPROVED_WORK.getCode();
            if (workflow_enabled) {
                apprStatusTemp = WorkFlowStatusEnum.CHANGING_WORK.getCode();
                changeApprStatusTemp = WorkFlowStatusEnum.APPROVING_WORK.getCode();
                changeStatusTemp = WorkFlowStatusEnum.CHANGING_WORK.getCode();
                Long orgManageUserId = cacheUtil.getOrgManageUserId(vo.getOrgId());
                HashMap<String, Object> batchMap = new HashMap<>();
                batchMap.put(FLOW_BU_MANAGER_NODE_ID, Lists.newArrayList(orgManageUserId.toString()));
                //发起流程审批
                processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                    ProcDefKey.OPPO_ESTIMATE_CHANGE.name(),
                    "商机成本估算-" + vo.getCode() + "-变更审批流程",
                    //vo.getCode() + "-" + ProcDefKey.OPPO_ESTIMATE_CHANGE.getName(),
                    saveId + "",
                    batchMap)
                );
            }
            OpportunityCostEstimatePayload payload0 = new OpportunityCostEstimatePayload();
            payload0.setId(payload.getId());
            payload0.setSubmitTime(LocalDateTime.now());
            payload0.setApprStatus(apprStatusTemp);

            ComBusinessChangePayload businessChangePayload = new ComBusinessChangePayload();
            businessChangePayload.setId(saveId);
            businessChangePayload.setApprProcInstId(processInfo.getProcInstId());
            businessChangePayload.setApprStatus(changeApprStatusTemp);
            businessChangePayload.setChangeStatus(changeStatusTemp);
            //主要是修改审批状态
            //开启事务执行修改，主要是修改审批状态
            transactionUtilService.executeWithRunnable(() -> {
                opportunityCostEstimateDAO.updateWorkFlow(payload0);
                businessChangeDao.updateWorkFlow(businessChangePayload);
            });

            // 未走流程的 变更直接生效
            if (!workflow_enabled) {
                //根据业务key查询当前业务对象
                ComBusinessChangeVO comBusinessChangeVO = businessChangeDao.queryByKey(saveId);
                if(null != comBusinessChangeVO){
                    // 业务信息
                    OpportunityCostEstimatePayload opportunityCostEstimatePayload = new OpportunityCostEstimatePayload();
                    opportunityCostEstimatePayload.setId(Long.valueOf(comBusinessChangeVO.getChangeDocId()));
                    opportunityCostEstimatePayload.setApprStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());


                    opportunityCostEstimatePayload = JSON.parseObject(comBusinessChangeVO.getChangeContent(), OpportunityCostEstimatePayload.class);
                    opportunityCostEstimatePayload.setApprStatus(WorkFlowStatusEnum.APPROVED.getCode());
                    opportunityCostEstimatePayload.setApprovedTime(LocalDateTime.now());
                    opportunityCostEstimatePayload.setVersion("v" + comBusinessChangeVO.getVersionNo().toString());

                    // 变更信息
                    ComBusinessChangePayload changePayload = new ComBusinessChangePayload();
                    changePayload.setId(comBusinessChangeVO.getId());
                    //changePayload.setApprStatus(procInstStatus.name());
                    changePayload.setChangeStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
                    businessChangeDao.updateWorkFlow(changePayload);
                    updatePro(opportunityCostEstimatePayload);
                }
            }

            return vo;
        } else {
            throw TwException.error("", "仅激活状态支持变更，请核验！");
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public OpportunityCostEstimateVO updatePro(OpportunityCostEstimatePayload payload) {
        OpportunityCostEstimateDO entity = opportunityCostEstimateRepo.findById(payload.getId()).orElseGet(OpportunityCostEstimateDO::new);
        Assert.notNull(entity.getId(), "成本估算不存在");
        OpportunityCostEstimateDO entityDo = OpportunityCostEstimateConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        final OpportunityCostEstimateDO save = opportunityCostEstimateRepo.save(entity);
        // 保存明细
        saveDetails(save, payload.getDetails());
        return OpportunityCostEstimateConvert.INSTANCE.toVo(save);
    }

    /**
     * 创建工作流
     *
     * @param payload
     */
    void submitProc(OpportunityCostEstimatePayload payload) {
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
        if (workflow_enabled) {
            status = WorkFlowStatusEnum.APPROVING_WORK.getCode();
            Long orgManageUserId = cacheUtil.getOrgManageUserId(payload.getOrgId());
            HashMap<String, Object> batchMap = new HashMap<>();
            // 部门负责人
            batchMap.put(FLOW_BU_MANAGER_CHANGE_NODE_ID, Lists.newArrayList(orgManageUserId.toString()));
            //发起流程审批
            processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                ProcDefKey.OPPO_ESTIMATE.name(),
                "商机成本估算-" + payload.getCode() + "-审批流程",
                //payload.getCode() + "-" + ProcDefKey.OPPO_ESTIMATE.getName(),
                payload.getId() + "",
                batchMap)
            );
        }
        OpportunityCostEstimatePayload payload0 = new OpportunityCostEstimatePayload();
        payload0.setId(payload.getId());
        payload0.setProcInstId(processInfo.getProcInstId());
        payload0.setProcInstStatus(processInfo.getProcInstStatus());
        payload0.setSubmitTime(LocalDateTime.now());
        payload0.setApprStatus(status);
        //开启事务执行修改，主要是修改审批状态
        transactionUtilService.executeWithRunnable(() -> {
            opportunityCostEstimateDAO.updateWorkFlow(payload0);
        });
    }

    /**
     * 发起变更工作流
     *
     * @param vo
     * @return
     */
    private ProcessInfo startChangeWorkFlow(OpportunityCostEstimateVO vo, Long saveId) {
        Long orgManageUserId = cacheUtil.getOrgManageUserId(vo.getOrgId());
        HashMap<String, Object> batchMap = new HashMap<>();
        batchMap.put(FLOW_BU_MANAGER_NODE_ID, Lists.newArrayList(orgManageUserId.toString()));
        //发起流程审批
        ProcessInfo processInfo = workflowUtil.startProcess(StartProcessPayload.of(
            ProcDefKey.OPPO_ESTIMATE_CHANGE.name(),
            "商机成本估算-" + vo.getCode() + "-变更审批流程",
            //vo.getCode() + "-" + ProcDefKey.OPPO_ESTIMATE_CHANGE.getName(),
            saveId + "",
            batchMap)
        );
        return processInfo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<OpportunityCostEstimateDO> optional = opportunityCostEstimateRepo.findById(id);
                if (!optional.isEmpty()) {
                    OpportunityCostEstimateDO entity = optional.get();
                    if (!entity.getApprStatus().equals(WorkFlowStatusEnum.CREATE_WORK.getCode())) {
                        throw TwException.error("", "当前状态不能删除");
                    }
                    entity.setDeleteFlag(1);
                    opportunityCostEstimateRepo.save(entity);
                }
            });
        }
    }

}
