package com.elitesland.tw.tw5crm.server.oppo.service;

import com.elitesland.tw.tw5crm.server.oppo.repo.OpportunityQuoteDetailsRepo;
import com.elitesland.tw.tw5crm.server.oppo.dao.OpportunityQuoteDetailsDAO;
import com.elitesland.tw.tw5crm.server.oppo.convert.OpportunityQuoteDetailsConvert;
import com.elitesland.tw.tw5crm.api.oppo.service.OpportunityQuoteDetailsService;
import com.elitesland.tw.tw5crm.api.oppo.payload.OpportunityQuoteDetailsPayload;
import com.elitesland.tw.tw5crm.server.oppo.entity.OpportunityQuoteDetailsDO;
import com.elitesland.tw.tw5crm.api.oppo.vo.OpportunityQuoteDetailsVO;
import com.elitesland.tw.tw5crm.api.oppo.query.OpportunityQuoteDetailsQuery;
import com.elitesland.tw.tw5crm.server.oppo.convert.OpportunityQuoteDetailsConvert;
import org.springframework.stereotype.Service;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import org.springframework.transaction.annotation.Transactional;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.util.PageUtil;

import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * 商机报价明细
 *
 * @author liwenpeng
 * @date 2023-03-23
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class OpportunityQuoteDetailsServiceImpl extends BaseServiceImpl implements OpportunityQuoteDetailsService {

    private final OpportunityQuoteDetailsRepo opportunityQuoteDetailsRepo;
    private final OpportunityQuoteDetailsDAO opportunityQuoteDetailsDAO;

    @Override
    public PagingVO<OpportunityQuoteDetailsVO> paging(OpportunityQuoteDetailsQuery query){
        Page<OpportunityQuoteDetailsDO> page = opportunityQuoteDetailsRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root,query,criteriaBuilder),query.getPageRequest());
        return PageUtil.toPageVo(page.map(OpportunityQuoteDetailsConvert.INSTANCE::toVo));
    }

    @Override
    public PagingVO<OpportunityQuoteDetailsVO> queryPaging(OpportunityQuoteDetailsQuery query){
        return opportunityQuoteDetailsDAO.queryPaging(query);
    }

    @Override
    public List<OpportunityQuoteDetailsVO> queryList(OpportunityQuoteDetailsQuery query){
        return OpportunityQuoteDetailsConvert.INSTANCE.toVoList(
                opportunityQuoteDetailsRepo.findAll(
                (root, criteriaQuery, criteriaBuilder)
                    -> QueryHelp.getPredicate(root, query, criteriaBuilder)
                , query.getPageRequest().getSort()
             )
        );
    }

    @Override
    public List<OpportunityQuoteDetailsVO> queryListDynamic(OpportunityQuoteDetailsQuery query){
        return opportunityQuoteDetailsDAO.queryListDynamic(query);
    }

    @Override
    public OpportunityQuoteDetailsVO queryByKey(Long key) {
        OpportunityQuoteDetailsDO entity = opportunityQuoteDetailsRepo.findById(key).orElseGet(OpportunityQuoteDetailsDO::new);
        Assert.notNull(entity.getId(), "不存在");
        OpportunityQuoteDetailsVO vo = OpportunityQuoteDetailsConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public OpportunityQuoteDetailsVO insert(OpportunityQuoteDetailsPayload payload) {
        OpportunityQuoteDetailsDO entityDo = OpportunityQuoteDetailsConvert.INSTANCE.toDo(payload);
        return OpportunityQuoteDetailsConvert.INSTANCE.toVo(opportunityQuoteDetailsRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public OpportunityQuoteDetailsVO update(OpportunityQuoteDetailsPayload payload) {
        OpportunityQuoteDetailsDO entity = opportunityQuoteDetailsRepo.findById(payload.getId()).orElseGet(OpportunityQuoteDetailsDO::new);
        Assert.notNull(entity.getId(), "不存在");
        OpportunityQuoteDetailsDO entityDo = OpportunityQuoteDetailsConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return OpportunityQuoteDetailsConvert.INSTANCE.toVo(opportunityQuoteDetailsRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<OpportunityQuoteDetailsDO> optional = opportunityQuoteDetailsRepo.findById(id);
                if (!optional.isEmpty()) {
                    OpportunityQuoteDetailsDO entity = optional.get();
                    entity.setDeleteFlag(1);
                    opportunityQuoteDetailsRepo.save(entity);
                }
             });
        }
    }

}
