package com.elitesland.tw.tw5crm.server.product.controller;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5crm.api.product.payload.CrmBusinessAttributeGroupPayload;
import com.elitesland.tw.tw5crm.api.product.query.CrmBusinessAttributeGroupQuery;
import com.elitesland.tw.tw5crm.api.product.service.CrmBusinessAttributeGroupService;
import io.swagger.annotations.Api;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
* 产品管理-通用扩展属性组
*
* @author liwenpeng
* @date 2023-03-02
*/
@Api(tags = "产品管理-通用扩展属性组")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/product/attributeGroup")
@Slf4j
public class CrmBusinessAttributeGroupController {

    private final CrmBusinessAttributeGroupService businessAttributeGroupService;

    /**
    * 新增
    *
    * @param payload 有效载荷
    * @return {@link TwOutputUtil}
    */
    @PostMapping
    public TwOutputUtil insert(@RequestBody CrmBusinessAttributeGroupPayload payload){
        return TwOutputUtil.ok(businessAttributeGroupService.insert(payload));
    }

    /**
    * 更新
    *
    * @param payload 有效载荷
    * @return {@link TwOutputUtil}
    */
    @PutMapping
    public TwOutputUtil update(@RequestBody CrmBusinessAttributeGroupPayload payload){
        return TwOutputUtil.ok(businessAttributeGroupService.update(payload));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("/updateStatus")
    public TwOutputUtil updateStatus(@RequestBody CrmBusinessAttributeGroupPayload payload){
        return TwOutputUtil.ok(businessAttributeGroupService.updateStatus(payload));
    }

    /**
    * 主键查询
    *
    * @param key 关键
    * @return {@link TwOutputUtil}
    */
    @GetMapping("/{key}")
    // @UdcNameClass
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(businessAttributeGroupService.queryByKey(key));
    }

    /**
    * 分页
    *
    * @param query 查询
    * @return {@link TwOutputUtil}
    */
    @GetMapping("/paging")
    // @UdcNameClass
    public TwOutputUtil paging(CrmBusinessAttributeGroupQuery query) {
        return TwOutputUtil.ok(businessAttributeGroupService.paging(query));
    }

    /**
    * 查询列表
    *
    * @param query 查询
    * @return {@link TwOutputUtil}
    */
    @GetMapping("/list")
    // @UdcNameClass
    public TwOutputUtil queryList(CrmBusinessAttributeGroupQuery query) {
        return TwOutputUtil.ok(businessAttributeGroupService.queryList(query));
    }

    /**
    * 删除
    *
    * @param keys 主键id
    * @return result
    */
    @DeleteMapping("/deleteSoft")
    public TwOutputUtil deleteSoft(Long[] keys) {
        businessAttributeGroupService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
