package com.elitesland.tw.tw5crm.server.product.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5crm.api.product.payload.CrmBusinessTableColumnsPayload;
import com.elitesland.tw.tw5crm.api.product.query.CrmBusinessTableColumnsQuery;
import com.elitesland.tw.tw5crm.api.product.service.CrmBusinessTableColumnsService;
import com.elitesland.tw.tw5crm.api.product.vo.CrmBusinessTableColumnsVO;
import io.swagger.annotations.Api;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;


/**
 * 产品属性
 *
 * @author duwh
 * @date 2023/03/03
 */
@Api(tags = "产品管理-产品属性")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/product/attribute/")
@Slf4j
public class CrmBusinessTableColumnsController {

    private final CrmBusinessTableColumnsService service;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/insert")
    public TwOutputUtil insert(@RequestBody CrmBusinessTableColumnsPayload payload){
        CrmBusinessTableColumnsVO insert = service.insert(payload);
        return TwOutputUtil.ok(insert);
    }

    /**
     * 修改
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/update")
    public TwOutputUtil update(@RequestBody CrmBusinessTableColumnsPayload payload){
        service.update(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/findByKey/{key}")
    public TwOutputUtil findByKey(@PathVariable Long key) {
        CrmBusinessTableColumnsVO vo = service.findByKey(key);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 分页查询
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    public TwOutputUtil findByConditionPaging(CrmBusinessTableColumnsQuery query) {
        PagingVO<CrmBusinessTableColumnsVO> paging = service.paging(query);
        return TwOutputUtil.ok(paging);
    }


}
