package com.elitesland.tw.tw5crm.server.product.controller;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5crm.api.product.payload.ProductCategoryAttrGroupDetailRefPayload;
import com.elitesland.tw.tw5crm.api.product.query.ProductCategoryAttrGroupDetailRefQuery;
import com.elitesland.tw.tw5crm.api.product.service.ProductCategoryAttrGroupDetailRefService;
import io.swagger.annotations.Api;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 产品管理-产品分类属性组明细关系表
 *
 * @author duwh
 * @date 2023-03-03
 */
@Api(tags = "产品管理-产品分类属性组明细关系表")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/product/categoryAttrGroupDetailRef")
@Slf4j
public class ProductCategoryAttrGroupDetailRefController {

    private final ProductCategoryAttrGroupDetailRefService productCategoryAttrGroupDetailRefService;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    public TwOutputUtil insert(@RequestBody ProductCategoryAttrGroupDetailRefPayload payload) {
        return TwOutputUtil.ok(productCategoryAttrGroupDetailRefService.insert(payload));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    public TwOutputUtil update(@RequestBody ProductCategoryAttrGroupDetailRefPayload payload) {
        return TwOutputUtil.ok(productCategoryAttrGroupDetailRefService.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(productCategoryAttrGroupDetailRefService.queryByKey(key));
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    public TwOutputUtil paging(ProductCategoryAttrGroupDetailRefQuery query) {
        if (null == query.getGroupRefId()) {
            return TwOutputUtil.error("", "参数缺失", null);
        }
        return TwOutputUtil.ok(productCategoryAttrGroupDetailRefService.paging(query));
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    public TwOutputUtil queryList(ProductCategoryAttrGroupDetailRefQuery query) {
        if (null == query.getGroupRefId()) {
            return TwOutputUtil.error("", "参数缺失", null);
        }
        return TwOutputUtil.ok(productCategoryAttrGroupDetailRefService.queryList(query));
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    public TwOutputUtil deleteSoft(Long[] keys) {
        productCategoryAttrGroupDetailRefService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
