package com.elitesland.tw.tw5crm.server.product.controller;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.annotation.ReSubmitCheck;
import com.elitesland.tw.tw5crm.api.product.payload.ProductCategoryAttrGroupRefListPayload;
import com.elitesland.tw.tw5crm.api.product.payload.ProductCategoryAttrGroupRefPayload;
import com.elitesland.tw.tw5crm.api.product.query.ProductCategoryAttrGroupRefQuery;
import com.elitesland.tw.tw5crm.api.product.service.ProductCategoryAttrGroupRefService;
import io.swagger.annotations.Api;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 产品分类属性组关系表
 *
 * @author duwh
 * @date 2023-03-03
 */
@Api(tags = "产品管理-产品分类属性组关系表")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/product/categoryAttrGroupRef")
@Slf4j
public class ProductCategoryAttrGroupRefController {

    private final ProductCategoryAttrGroupRefService productCategoryAttrGroupRefService;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    public TwOutputUtil insert(@RequestBody ProductCategoryAttrGroupRefPayload payload) {
        return TwOutputUtil.ok(productCategoryAttrGroupRefService.insert(payload));
    }

    /**
     * 批量新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping("batchInsert")
    @ReSubmitCheck(argExpressions = {"[0].categoryAttrGroupRefList[0].id", "[0].categoryAttrGroupRefList[0].groupId"})
    public TwOutputUtil batchSaveOrUpdate(@RequestBody ProductCategoryAttrGroupRefListPayload payload) {
        return TwOutputUtil.ok(productCategoryAttrGroupRefService.batchSaveOrUpdate(payload));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    //@PutMapping
    //public TwOutputUtil update(@RequestBody ProductCategoryAttrGroupRefPayload payload) {
    //    return TwOutputUtil.ok(productCategoryAttrGroupRefService.update(payload));
    //}

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(productCategoryAttrGroupRefService.queryByKey(key));
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    public TwOutputUtil paging(ProductCategoryAttrGroupRefQuery query) {
        if (null == query.getCategoryId()) {
            return TwOutputUtil.error("", "参数缺失", null);
        }
        return TwOutputUtil.ok(productCategoryAttrGroupRefService.paging(query));
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    public TwOutputUtil queryList(ProductCategoryAttrGroupRefQuery query) {
        if (null == query.getCategoryId()) {
            return TwOutputUtil.error("", "参数缺失", null);
        }
        return TwOutputUtil.ok(productCategoryAttrGroupRefService.queryList(query));
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    public TwOutputUtil deleteSoft(Long[] keys) {
        productCategoryAttrGroupRefService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
