package com.elitesland.tw.tw5crm.server.product.controller;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.annotation.ReSubmitCheck;
import com.elitesland.tw.tw5crm.api.product.payload.ProductCategoryColumnRefListPayload;
import com.elitesland.tw.tw5crm.api.product.payload.ProductCategoryColumnRefPayload;
import com.elitesland.tw.tw5crm.api.product.query.ProductCategoryColumnRefQuery;
import com.elitesland.tw.tw5crm.api.product.service.ProductCategoryColumnRefService;
import io.swagger.annotations.Api;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 产品管理-产品分类属性关系
 *
 * @author duwh
 * @date 2023-03-02
 */
@Api(tags = "产品管理-产品分类属性关系")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/product/categoryColumnRef")
@Slf4j
public class ProductCategoryColumnRefController {

    private final ProductCategoryColumnRefService productCategoryColumnRefService;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    public TwOutputUtil insert(@RequestBody ProductCategoryColumnRefPayload payload) {
        return TwOutputUtil.ok(productCategoryColumnRefService.insert(payload));
    }

    /**
     * 批量新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping("batchInsert")
    @ReSubmitCheck(argExpressions = {"[0].categoryColumnRefList[0].id", "[0].categoryColumnRefList[0].columnId"})
    public TwOutputUtil batchSaveOrUpdate(@RequestBody ProductCategoryColumnRefListPayload payload) {
        return TwOutputUtil.ok(productCategoryColumnRefService.batchSaveOrUpdate(payload));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    public TwOutputUtil update(@RequestBody ProductCategoryColumnRefPayload payload) {
        return TwOutputUtil.ok(productCategoryColumnRefService.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(productCategoryColumnRefService.queryByKey(key));
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    public TwOutputUtil paging(ProductCategoryColumnRefQuery query) {
        if (null == query.getCategoryId()) {
            return TwOutputUtil.error("", "参数缺失", null);
        }
        return TwOutputUtil.ok(productCategoryColumnRefService.paging(query));
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    public TwOutputUtil queryList(ProductCategoryColumnRefQuery query) {
        if (null == query.getCategoryId()) {
            return TwOutputUtil.error("", "参数缺失", null);
        }
        return TwOutputUtil.ok(productCategoryColumnRefService.queryList(query));
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    public TwOutputUtil deleteSoft(Long[] keys) {
        productCategoryColumnRefService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
