package com.elitesland.tw.tw5crm.server.product.controller;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitesland.tw.tw5crm.api.product.payload.ProductPricePayload;
import com.elitesland.tw.tw5crm.api.product.query.ProductPriceQuery;
import com.elitesland.tw.tw5crm.api.product.service.ProductPriceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 产品管理-商品价目
 *
 * @author carl
 * @date 2023-03-14
 */
@Api(tags = "产品管理-商品价目")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/product/price")
@Slf4j
public class ProductPriceController {

    private final ProductPriceService productPriceService;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("新增")
    public TwOutputUtil insert(@RequestBody ProductPricePayload payload) {
        return TwOutputUtil.ok(productPriceService.insert(payload));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("更新")
    public TwOutputUtil update(@RequestBody ProductPricePayload payload) {
        return TwOutputUtil.ok(productPriceService.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("主键查询")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(productPriceService.queryByKey(key));
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("分页")
    public TwOutputUtil paging(ProductPriceQuery query) {
        return TwOutputUtil.ok(productPriceService.queryPaging(query));
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("查询列表")
    public TwOutputUtil queryList(ProductPriceQuery query) {
        return TwOutputUtil.ok(productPriceService.queryListDynamic(query));
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        productPriceService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 修改状态
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/updateStatus")
    @ApiOperation("修改状态")
    public TwOutputUtil updateStatus(Long[] keys) {
        productPriceService.updateStatus(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }
}
