package com.elitesland.tw.tw5crm.server.product.controller;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitesland.tw.tw5crm.api.product.query.ProductPriceDetailQuery;
import com.elitesland.tw.tw5crm.api.product.service.ProductPriceDetailService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 产品管理-商品价目明细
 *
 * @author carl
 * @date 2023-03-14
 */
@Api(tags = "产品管理-商品价目明细")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/product/priceDetail")
@Slf4j
public class ProductPriceDetailController {

    private final ProductPriceDetailService productPriceDetailService;


    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("分页")
    public TwOutputUtil paging(ProductPriceDetailQuery query) {
        return TwOutputUtil.ok(productPriceDetailService.queryPaging(query));
    }


//    /**
//     * 新增
//     *
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PostMapping
//    @ApiOperation("新增")
//    public TwOutputUtil insert(@RequestBody ProductPriceDetailPayload payload) {
//        return TwOutputUtil.ok(productPriceDetailService.insert(payload));
//    }

//    /**
//     * 更新
//     *
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PutMapping
//    @ApiOperation("更新")
//    public TwOutputUtil update(@RequestBody ProductPriceDetailPayload payload) {
//        return TwOutputUtil.ok(productPriceDetailService.update(payload));
//    }
//
//    /**
//     * 主键查询
//     *
//     * @param key 关键
//     * @return {@link TwOutputUtil}
//     */
//    @GetMapping("/{key}")
//    // @UdcNameClass
//    @ApiOperation("主键查询")
//    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
//        return TwOutputUtil.ok(productPriceDetailService.queryByKey(key));
//    }
//
//
//    /**
//     * 查询列表
//     *
//     * @param query 查询
//     * @return {@link TwOutputUtil}
//     */
//    @GetMapping("/list")
//    // @UdcNameClass
//    @ApiOperation("查询列表")
//    public TwOutputUtil queryList(ProductPriceDetailQuery query) {
//        return TwOutputUtil.ok(productPriceDetailService.queryListDynamic(query));
//    }
//
//    /**
//     * 删除
//     *
//     * @param keys 主键id
//     * @return result
//     */
//    @DeleteMapping("/deleteSoft")
//    @ApiOperation("删除")
//    public TwOutputUtil deleteSoft(Long[] keys) {
//        productPriceDetailService.deleteSoft(Arrays.asList(keys));
//        return TwOutputUtil.ok();
//    }

}
