package com.elitesland.tw.tw5crm.server.product.controller;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5crm.api.product.payload.ProductSkuPayload;
import com.elitesland.tw.tw5crm.api.product.query.ProductSkuQuery;
import com.elitesland.tw.tw5crm.api.product.service.ProductSkuService;
import io.swagger.annotations.Api;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

/**
 * 产品管理-商品规格组合表SKU
 *
 * @author carl.wang
 * @date 2023-03-03
 */
@Api(tags = "产品管理-商品规格组合表SKU")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/product/sku")
@Slf4j
public class ProductSkuController {

    private final ProductSkuService productSkuService;

//    /**
//     * 新增
//     *
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PostMapping
//    public TwOutputUtil insert(@RequestBody ProductSkuPayload payload) {
//        return TwOutputUtil.ok(productSkuService.insert(payload));
//    }
//
//    /**
//     * 更新
//     *
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PutMapping
//    public TwOutputUtil update(@RequestBody ProductSkuPayload payload) {
//        return TwOutputUtil.ok(productSkuService.update(payload));
//    }

    /**
     * 修改上下架状态
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("/updateStatus")
    public TwOutputUtil updateStatus(@RequestBody ProductSkuPayload payload) {
        productSkuService.updateStatus(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(productSkuService.queryByKey(key));
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    public TwOutputUtil paging(ProductSkuQuery query) {
        return TwOutputUtil.ok(productSkuService.paging(query));
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    public TwOutputUtil queryList(ProductSkuQuery query) {
        return TwOutputUtil.ok(productSkuService.queryList(query));
    }

//    /**
//     * 删除
//     *
//     * @param keys 主键id
//     * @return result
//     */
//    @DeleteMapping("/deleteSoft")
//    public TwOutputUtil deleteSoft(Long[] keys) {
//        productSkuService.deleteSoft(Arrays.asList(keys));
//        return TwOutputUtil.ok();
//    }

}
