package com.elitesland.tw.tw5crm.server.product.controller;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5crm.api.product.payload.ProductSpuPayload;
import com.elitesland.tw.tw5crm.api.product.query.ProductSpuQuery;
import com.elitesland.tw.tw5crm.api.product.service.ProductSpuService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 产品管理-商品主表SPU
 *
 * @author carl.wang
 * @date 2023-03-03
 */
@Api(tags = "产品管理-商品SPU")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/product/spu")
@Slf4j
public class ProductSpuController {

    private final ProductSpuService productSpuService;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @ApiOperation("新增")
    @PostMapping
    public TwOutputUtil insert(@RequestBody ProductSpuPayload payload) {
        return TwOutputUtil.ok(productSpuService.insert(payload));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @ApiOperation("更新")
    @PutMapping
    public TwOutputUtil update(@RequestBody ProductSpuPayload payload) {
        return TwOutputUtil.ok(productSpuService.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @ApiOperation("主键查询")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(productSpuService.queryByKey(key));
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("分页")
    public TwOutputUtil paging(ProductSpuQuery query) {
        return TwOutputUtil.ok(productSpuService.paging(query));
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("查询列表")
    public TwOutputUtil queryList(ProductSpuQuery query) {
        return TwOutputUtil.ok(productSpuService.queryList(query));
    }

    /**
     * 删除spu
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("删除spu")
    public TwOutputUtil deleteSoft(Long[] keys) {
        productSpuService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 删除sku
     *
     * @param keys 主键id
     * @return result
     */
    @ApiOperation("删除sku")
    @DeleteMapping("/deleteSoftSku")
    public TwOutputUtil deleteSoftSku(Long[] keys) {
        productSpuService.deleteSoftSku(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
