package com.elitesland.tw.tw5crm.server.product.convert;

import com.elitesland.tw.tw5.server.common.BaseConvertMapper;
import com.elitesland.tw.tw5crm.api.product.payload.ProductCategoryPayload;
import com.elitesland.tw.tw5crm.api.product.vo.ProductCategoryAttrsAndAttrGroupsVO;
import com.elitesland.tw.tw5crm.api.product.vo.ProductCategoryVO;
import com.elitesland.tw.tw5crm.server.product.entity.ProductCategoryDO;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

/**
* 产品分类
*
* @author duwh
* @date 2023-03-02
*/
@Mapper
public interface ProductCategoryConvert extends BaseConvertMapper<ProductCategoryVO, ProductCategoryDO> {

    ProductCategoryConvert INSTANCE = Mappers.getMapper(ProductCategoryConvert.class);

    ProductCategoryDO toDo(ProductCategoryPayload payload);

    ProductCategoryVO toVo(ProductCategoryDO ado);

    ProductCategoryAttrsAndAttrGroupsVO toVoAttrsAndAttrGroups(ProductCategoryDO ado);

    ProductCategoryPayload toPayload(ProductCategoryVO vo);
}
