package com.elitesland.tw.tw5crm.server.product.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5crm.api.product.payload.CrmBusinessAttributeGroupPayload;
import com.elitesland.tw.tw5crm.api.product.query.CrmBusinessAttributeGroupQuery;
import com.elitesland.tw.tw5crm.api.product.vo.CrmBusinessAttributeGroupVO;
import com.elitesland.tw.tw5crm.api.product.vo.CrmBusinessTableColumnsVO;
import com.elitesland.tw.tw5crm.server.product.entity.CrmBusinessAttributeGroupDO;
import com.elitesland.tw.tw5crm.server.product.entity.QCrmBusinessAttributeGroupDO;
import com.elitesland.tw.tw5crm.server.product.repo.CrmBusinessAttributeGroupRepo;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
* 通用扩展属性组
*
* @author liwenpeng
* @date 2023-03-02
*/
@Repository
@RequiredArgsConstructor
public class CrmBusinessAttributeGroupDAO {

private final JPAQueryFactory jpaQueryFactory;
private final CrmBusinessAttributeGroupRepo repo;
private final QCrmBusinessAttributeGroupDO qdo = QCrmBusinessAttributeGroupDO.crmBusinessAttributeGroupDO;
/**
* 拼装查询字段
*
* @return jpaQuery对象
*/
private JPAQuery
<CrmBusinessAttributeGroupVO> getJpaQuerySelect() {
    return jpaQueryFactory.select(Projections.bean(CrmBusinessAttributeGroupVO.class,
                // 扩展属性组名称
            qdo.id,
            qdo.creator,
            qdo.createTime,
            qdo.groupName,
                // 状态，0未启用，1已启用
            qdo.status,
            qdo.creator,
            qdo.createTime,
            qdo.createUserId,
            qdo.updater,
            qdo.modifyTime,
            qdo.modifyUserId,
                // 排序号
            qdo.sortNo
    )).from(qdo);
    }

    /**
    * 拼装查询条件
    *
    * @param query 查询参数
    * @return jpaQuery对象
    */
    private JPAQuery<CrmBusinessAttributeGroupVO> getJpaQueryWhere(CrmBusinessAttributeGroupQuery query) {
        JPAQuery<CrmBusinessAttributeGroupVO> jpaQuery = getJpaQuerySelect();
//            // 条件封装
//            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));

            if (!ObjectUtils.isEmpty(query.getGroupName())) {
                jpaQuery.where(qdo.groupName.like(SqlUtil.toSqlLikeString(query.getGroupName())));
            }
            if (!ObjectUtils.isEmpty(query.getStatus())) {
                jpaQuery.where(qdo.status.eq(query.getStatus()));
            }
            return jpaQuery;
            }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private long count(CrmBusinessAttributeGroupQuery query) {
        long total = jpaQueryFactory
            .select(qdo.count())
            .from(qdo)
            .where(where(query))
            .fetchOne();
        return total;
    }

    /**
    * 查询条件封装
    *
    * @param query 条件
    * @return {@link Predicate}
    */
    private Predicate where(CrmBusinessAttributeGroupQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 扩展属性组名称 模糊 */
        if (!ObjectUtils.isEmpty(query.getGroupName())) {
             list.add(qdo.groupName.like(SqlUtil.toSqlLikeString(query.getGroupName())));
        }
        /** 状态，0未启用，1已启用 精确 */
        if (!ObjectUtils.isEmpty(query.getStatus())) {
            list.add(qdo.status.eq(query.getStatus()));
        }
        /** 排序号 精确 */
        if (!ObjectUtils.isEmpty(query.getSortNo())) {
            list.add(qdo.sortNo.eq(query.getSortNo()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public CrmBusinessAttributeGroupVO queryByKey(Long id) {
        JPAQuery<CrmBusinessAttributeGroupVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<CrmBusinessAttributeGroupVO> queryListDynamic(CrmBusinessAttributeGroupQuery query) {
        JPAQuery<CrmBusinessAttributeGroupVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<CrmBusinessAttributeGroupVO> queryPaging(CrmBusinessAttributeGroupQuery query) {
        JPAQuery<CrmBusinessAttributeGroupVO> jpaQuery = getJpaQueryWhere(query);
        QueryResults<CrmBusinessAttributeGroupVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
//        System.out.println(result.getTotal());
        return PagingVO.<CrmBusinessAttributeGroupVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public CrmBusinessAttributeGroupDO save(CrmBusinessAttributeGroupDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<CrmBusinessAttributeGroupDO> saveAll(List<CrmBusinessAttributeGroupDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(CrmBusinessAttributeGroupPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
                // 记录唯一ID
        if (payload.getGroupName() != null) {
            update.set(qdo.groupName, payload.getGroupName());
        }
                // 状态，0未启用，1已启用
        if (payload.getStatus() != null) {
            update.set(qdo.status, payload.getStatus());
        }
                // 排序号
        if (payload.getSortNo() != null) {
            update.set(qdo.sortNo, payload.getSortNo());
        }
//        // 处理要设置成空的字段
//        List<String> nullFields = payload.getNullFields();
//        if (nullFields != null && nullFields.size() > 0) {
//            // 记录唯一ID
//            if (nullFields.contains("id")) {
//                update.setNull(qdo.id);
//            }
//            // 扩展属性组名称
//            if (nullFields.contains("groupName")) {
//                update.setNull(qdo.groupName);
//            }
//            // 状态，0未启用，1已启用
//            if (nullFields.contains("status")) {
//                update.setNull(qdo.status);
//            }
//            // 排序号
//            if (nullFields.contains("sortNo")) {
//                update.setNull(qdo.sortNo);
//            }
//        }
//        //拼装更新
//        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

