package com.elitesland.tw.tw5crm.server.product.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5crm.api.product.payload.CrmBusinessTableColumnsPayload;
import com.elitesland.tw.tw5crm.api.product.query.CrmBusinessTableColumnsQuery;
import com.elitesland.tw.tw5crm.api.product.vo.CrmBusinessTableColumnsVO;
import com.elitesland.tw.tw5crm.server.product.entity.CrmBusinessTableColumnsDO;
import com.elitesland.tw.tw5crm.server.product.entity.QCrmBusinessTableColumnsDO;
import com.elitesland.tw.tw5crm.server.product.repo.CrmBusinessTableColumnsRepo;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

import java.util.List;

/**
 * @Author : liwenpeng
 * @create 2023/3/1 15:54
 */
@Repository
@RequiredArgsConstructor
public class CrmBusinessTableColumnsDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final CrmBusinessTableColumnsRepo repo;

    private final QCrmBusinessTableColumnsDO qdo = QCrmBusinessTableColumnsDO.crmBusinessTableColumnsDO;


    public CrmBusinessTableColumnsDO save(CrmBusinessTableColumnsDO ado){
        return repo.save(ado);
    }

//    public List<CrmBusinessTableColumnsDO> findAllByTableName(String tableName){
//        return repo.findAllByTableName(tableName);
//    }

    public CrmBusinessTableColumnsVO findByKey(Long key){
        JPAQuery<CrmBusinessTableColumnsVO> jpaQuerySelect = getJpaQuerySelect();
        jpaQuerySelect.where(qdo.id.eq(key));
        jpaQuerySelect.where(qdo.deleteFlag.eq(0));
        return jpaQuerySelect.fetchFirst();
    }

    public long update(CrmBusinessTableColumnsPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo);
        if (payload.getAttributeDesc()!=null){
            update.set(qdo.attributeDesc,payload.getAttributeDesc());
        }
        if (payload.getComponentType()!=null){
            update.set(qdo.componentType,payload.getComponentType());
        }
        if (payload.getIsMultiple()!=null){
            update.set(qdo.isMultiple,payload.getIsMultiple());
        }
        if (payload.getStatus()!=null){
            update.set(qdo.status,payload.getStatus());
        }
        if (payload.getAttributeScope()!=null){
            update.set(qdo.attributeScope,payload.getAttributeScope());
        }
        update.where(qdo.id.eq(payload.getId()));
        return update.execute();
    }

    public PagingVO<CrmBusinessTableColumnsVO> queryPaging(CrmBusinessTableColumnsQuery query) {
        JPAQuery<CrmBusinessTableColumnsVO> jpaQuery = getJpaQueryWhere(query);
        QueryResults<CrmBusinessTableColumnsVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
//        System.out.println(result.getTotal());
        return PagingVO.<CrmBusinessTableColumnsVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<CrmBusinessTableColumnsVO> queryListDynamic(CrmBusinessTableColumnsQuery query) {
        JPAQuery<CrmBusinessTableColumnsVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    private JPAQuery<CrmBusinessTableColumnsVO> getJpaQueryWhere(CrmBusinessTableColumnsQuery query) {
        JPAQuery<CrmBusinessTableColumnsVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.tableName.eq(query.getTableName()));
        if (!ObjectUtils.isEmpty(query.getAttributeDesc())) {
            jpaQuery.where(qdo.attributeDesc.like(SqlUtil.toSqlLikeString(query.getAttributeDesc())));
        }
        if (!ObjectUtils.isEmpty(query.getStatus())) {
            jpaQuery.where(qdo.status.eq(query.getStatus()));
        }
        if (!ObjectUtils.isEmpty(query.getAttributeType())) {
            jpaQuery.where(qdo.attributeType.eq(query.getAttributeType()));
        }
        if (!ObjectUtils.isEmpty(query.getComponentType())) {
            jpaQuery.where(qdo.componentType.eq(query.getComponentType()));
        }
        if (!ObjectUtils.isEmpty(query.getIsMultiple())) {
            jpaQuery.where(qdo.isMultiple.eq(query.getIsMultiple()));
        }
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

//    public List<String[]> findTableAndColumnsInfoByTableName(String tableName){
//        return repo.findTableInfoByTableName(Arrays.asList(tableName));
//    }

    public int getCountByTableNameAndAttributeType(String tableName,String attributeType){
        JPAQuery<CrmBusinessTableColumnsVO> jpaQuerySelect = getJpaQuerySelect();
        jpaQuerySelect.where(qdo.tableName.eq(tableName));
        jpaQuerySelect.where(qdo.attributeType.eq(attributeType));
        return jpaQuerySelect.fetch().size();
    }

    public CrmBusinessTableColumnsVO geMaxSortByTableNameAndAttributeType(String tableName,String attributeType){
        return jpaQueryFactory.select(Projections.bean(CrmBusinessTableColumnsVO.class,
                        qdo.tenantId,
                        qdo.countNo.max().as("countNo")))
                .from(qdo)
                .where(qdo.tableName.eq(tableName))
                .where(qdo.attributeType.eq(attributeType))
                .groupBy(qdo.tenantId)
                .fetchOne();
    }

    public JPAQuery<CrmBusinessTableColumnsVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(CrmBusinessTableColumnsVO.class,
                        qdo.id,
                        qdo.tableName,
                        qdo.columnName,
                        qdo.columnDesc,
                        qdo.attributeDesc,
                        qdo.attributeType,
                        qdo.componentType,
                        qdo.selectionCode,
                        qdo.isMultiple,
                        qdo.attributeScope,
                        qdo.attributePrompt,
                        qdo.status,
                        qdo.updater,
                        qdo.modifyTime,
                        qdo.modifyUserId,
                        qdo.createUserId,
                        qdo.creator,
                        qdo.createTime))
                .from(qdo);
    }


}
