package com.elitesland.tw.tw5crm.server.product.dao;

import com.elitesland.tw.tw5crm.server.product.entity.CrmBusinessTableDO;
import com.elitesland.tw.tw5crm.server.product.repo.CrmBusinessTableRepo;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @Author : liwenpeng
 * @create 2023/3/1 15:37
 */
@Repository
@RequiredArgsConstructor
public class CrmBusinessTableDAO {

    private final CrmBusinessTableRepo repo;

    public CrmBusinessTableDO save(CrmBusinessTableDO ado){
        return repo.save(ado);
    }

    public int getCountByTableName(String tableName){
        List<CrmBusinessTableDO> byTableName = repo.findByTableName(tableName);
        return byTableName == null ? 0 :byTableName.size();
    }


}
