package com.elitesland.tw.tw5crm.server.product.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;

/**
* 通用扩展属性组
*
* @author liwenpeng
* @date 2023-03-02
*/
@Entity
@Table(name = "crm_business_attribute_group", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_business_attribute_group", comment = "通用扩展属性组")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CrmBusinessAttributeGroupDO extends BaseModel implements Serializable  {
    /** 扩展属性组名称 */
    @Comment("扩展属性组名称")
    @Column()
    private String groupName;
    /** 状态，0未启用，1已启用 */
    @Comment("状态，0未启用，1已启用")
    @Column()
    private Integer status;
    /** 排序号 */
    @Comment("排序号")
    @Column()
    private Integer sortNo;

    public void copy(CrmBusinessAttributeGroupDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
