package com.elitesland.tw.tw5crm.server.product.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
* 通用扩展属性明细
*
* @author liwenpeng
* @date 2023-03-02
*/
@Entity
@Table(name = "crm_business_attribute_group_detail", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_business_attribute_group_detail", comment = "通用扩展属性明细")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CrmBusinessAttributeGroupDetailDO extends BaseModel implements Serializable  {
    /** 属性组id */
    @Comment("属性组id")
    @Column()
    private Long groupId;
    /** 属性id */
    @Comment("属性id")
    @Column()
    private Long attributeId;
    /** 维护级别 SPU、SKU */
    @Comment("维护级别 SPU、SKU")
    @Column()
    private String unitClass;
    /** 是否必填 */
    @Comment("是否必填")
    @Column()
    private Integer isRequired;
    /** 排序号 */
    @Comment("排序号")
    @Column()
    private Integer sortNo;

    public void copy(CrmBusinessAttributeGroupDetailDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
