package com.elitesland.tw.tw5crm.server.product.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @Author : liwenpeng
 * @create 2023/3/1 14:23
 */

@Entity
@Table(name = "crm_business_table_columns")
@org.hibernate.annotations.Table(appliesTo = "crm_business_table_columns", comment = "通用属性配置字段表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CrmBusinessTableColumnsDO extends BaseModel {

    @Comment("表名称")
    @Column(name = "table_name")
    private String tableName;

    @Comment("字段名称")
    @Column(name = "column_name")
    private String columnName;

    @Comment("字段描述")
    @Column(name = "column_desc")
    private String columnDesc;

    @Comment("属性名称")
    @Column(name = "attribute_desc")
    private String attributeDesc;

    @Comment("属性类型")
    @Column(name = "attribute_type")
    private String attributeType;

    @Comment("组件类型 udc[attribute:componentType]")
    @Column(name = "component_type")
    private String componentType;

    @Comment("值范围")
    @Column(name = "attribute_scope")
    private String attributeScope;

    @Comment("提示")
    @Column(name = "attribute_prompt")
    private String attributePrompt;

    @Comment("状态，0未启用，1已启用")
    @Column(name = "status")
    private Integer status;

    @Comment("系统选择项code")
    @Column(name = "selection_code")
    private String selectionCode;

    @Comment("是否多选，0单选，1多选")
    @Column(name = "is_multiple")
    private Integer isMultiple;

    @Comment("排序号")
    @Column(name = "sort_no")
    private Integer sortNo;

    @Comment("计数字段")
    @Column(name = "count_no")
    private Integer countNo;

}
