package com.elitesland.tw.tw5crm.server.product.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
* 产品分类属性组关系表
*
* @author duwh
* @date 2023-03-03
*/
@Entity
@Table(name = "crm_product_category_attr_group_ref", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_product_category_attr_group_ref", comment = "产品分类属性组关系表")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ProductCategoryAttrGroupRefDO extends BaseModel implements Serializable  {
    /** 产品分类ID:crm_product_category.id */
    @Comment("产品分类ID:crm_product_category.id")
    @Column()
    private Long categoryId;
    /** 分类名称（冗余）crm_product_category.obj_name */
    @Comment("分类名称（冗余）crm_product_category.obj_name")
    @Column()
    private String categoryName;
    /** 属性表ID:crm_business_attribute_group.id */
    @Comment("属性表ID:crm_business_attribute_group.id")
    @Column()
    private Long groupId;
    /** 扩展属性组名称（冗余） */
    @Comment("扩展属性组名称（冗余）")
    @Column()
    private String groupName;
    /** 状态，0未启用，1已启用 */
    @Comment("状态，0未启用，1已启用")
    @Column()
    private Integer status;
    /** 排序号（冗余） */
    @Comment("排序号（冗余）")
    @Column()
    private Integer sortNo;
    /** 自定义排序号（分类） */
    @Comment("自定义排序号（分类）")
    @Column()
    private Integer sortNoSelf;

    public void copy(ProductCategoryAttrGroupRefDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
