package com.elitesland.tw.tw5crm.server.product.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;

/**
* 产品分类属性关系
*
* @author duwh
* @date 2023-03-02
*/
@Entity
@Table(name = "crm_product_category_column_ref", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_product_category_column_ref", comment = "产品分类属性关系")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ProductCategoryColumnRefDO extends BaseModel implements Serializable  {
    /** 产品分类ID:crm_product_category.id */
    @Comment("产品分类ID:crm_product_category.id")
    @Column()
    private Long categoryId;
    /** 分类名称（冗余） */
    @Comment("分类名称（冗余）")
    @Column()
    private String categoryName;
    /** 属性表ID:crm_business_table_columns.id */
    @Comment("属性表ID:crm_business_table_columns.id")
    @Column()
    private Long columnId;
    /** 字段名称（冗余） */
    @Comment("字段名称（冗余）")
    @Column()
    private String columnName;
    /** 字段描述（冗余） */
    @Comment("字段描述（冗余）")
    @Column()
    private String columnDesc;
    /** 属性名称（冗余） */
    @Comment("属性名称（冗余）")
    @Column()
    private String attributeDesc;
    /** 属性类型（冗余） */
    @Comment("属性类型（冗余）")
    @Column()
    private String attributeType;
    /** 组件类型（冗余） */
    @Comment("组件类型（冗余）")
    @Column()
    private String componentType;
    /** 值范围（冗余） */
    @Comment("值范围（冗余）")
    @Column()
    private String attributeScope;
    /** 提示（冗余） */
    @Comment("提示（冗余）")
    @Column()
    private String attributePrompt;
    /** 系统选择项code（冗余） */
    @Comment("系统选择项code（冗余）")
    @Column()
    private String selectionCode;
    /** 是否多选，0单选，1多选（冗余） */
    @Comment("是否多选，0单选，1多选（冗余）")
    @Column()
    private Integer isMultiple;
    /** 排序号（冗余） */
    @Comment("排序号（冗余）")
    @Column()
    private Integer sortNo;
    /** 自定义排序号（分类） */
    @Comment("自定义排序号（分类）")
    @Column()
    private Integer sortNoSelf;
    /** 状态，0未启用，1已启用 */
    @Comment("状态，0未启用，1已启用")
    @Column()
    private Integer status;

    public void copy(ProductCategoryColumnRefDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
