package com.elitesland.tw.tw5crm.server.product.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
* 产品分类
*
* @author duwh
* @date 2023-03-02
*/
@Entity
@Table(name = "crm_product_category", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_product_category", comment = "产品分类")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ProductCategoryDO extends BaseModel implements Serializable  {
    /** 分类名称 */
    @Comment("分类名称")
    @Column()
    private String objName;
    /** 分类编号 */
    @Comment("分类编号")
    @Column()
    private String objNo;
    /** 父ID */
    @Comment("父ID")
    @Column()
    private Long parentId;
    /** 排序号 */
    @Comment("排序号")
    @Column()
    private Integer sortNo;
    /** 层级 */
    @Comment("层级")
    @Column()
    private String level;
    /** 设置前预览 */
    @Comment("设置前预览")
    @Column()
    private String previewBefore;
    /** 设置后预览 */
    @Comment("设置后预览")
    @Column()
    private String previewAfter;
    /** 状态，0未启用，1已启用 */
    @Comment("状态，0未启用，1已启用")
    @Column()
    private Integer status;
    /**
     * 子节点数目
     */
    @Comment("子节点数目")
    @Column()
    private Integer subCount = 0;

    public void copy(ProductCategoryDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
