package com.elitesland.tw.tw5crm.server.product.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 商品价目销售客户
 *
 * @author carl
 * @date 2023-03-14
 */
@Entity
@Table(name = "crm_product_price_customer", indexes = {
        @Index(name = "price_index", columnList = "price_id"),
        @Index(name = "cust_index", columnList = "cust_id")
})
@org.hibernate.annotations.Table(appliesTo = "crm_product_price_customer", comment = "商品价目销售客户")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ProductPriceCustomerDO extends BaseModel implements Serializable {
    /**
     * 价目主键
     */
    @Comment("价目主键")
    @Column(name = "price_id")
    private Long priceId;
    /**
     * 客户主键
     */
    @Comment("客户主键")
    @Column(name = "cust_id")
    private Long custId;
    /**
     * 客户名称
     */
    @Comment("客户名称")
    @Column()
    private String customerName;


    public void copy(ProductPriceOrgDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
