package com.elitesland.tw.tw5crm.server.product.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 商品价目
 *
 * @author carl
 * @date 2023-03-14
 */
@Entity
@Table(name = "crm_product_price", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_product_price", comment = "商品价目")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ProductPriceDO extends BaseModel implements Serializable {
    /**
     * 价目表编码
     */
    @Comment("价目表编码")
    @Column()
    private String priceCode;
    /**
     * 价目表名称
     */
    @Comment("价目表名称")
    @Column()
    private String priceName;
    /**
     * 负责人id
     */
    @Comment("负责人id")
    @Column()
    private Long manageUserId;
    /**
     * 归属部门
     */
    @Comment("归属部门")
    @Column()
    private Long orgId;
    /**
     * 有效期开始时间
     */
    @Comment("有效期开始时间")
    @Column()
    private LocalDate startTime;
    /**
     * 结束时间
     */
    @Comment("结束时间")
    @Column()
    private LocalDate endTime;
    /**
     * 币种
     */
    @Comment("币种")
    @Column()
    private String currCode;
    /**
     * 状态
     */
    @Comment("状态")
    @Column()
    private String priceStatus;
    /**
     * 销售组织类型：
     */
    @Comment("销售组织类型：")
    @Column()
    private String saleOrgType;
    /**
     * 销售组织内容
     */
    @Comment("销售组织内容")
    @Column()
    private String saleOrgIds;
    /**
     * 销售客户类型
     */
    @Comment("销售客户类型")
    @Column()
    private String saleCustType;
    /**
     * 销售客户
     */
    @Comment("销售客户")
    @Column()
    private String saleCustIds;

    @Comment("流程实例ID")
    @Column()
    private String procInstId;

    @Comment("流程审批状态")
    @Column()
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;

    @Comment("提交时间")
    @Column()
    private LocalDateTime submitTime;

    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;

    public void copy(ProductPriceDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
