package com.elitesland.tw.tw5crm.server.product.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 商品价目明细
 *
 * @author carl
 * @date 2023-03-14
 */
@Entity
@Table(name = "crm_product_price_detail", indexes = {
        @Index(name = "price_index", columnList = "price_id"),
        @Index(name = "sku_index", columnList = "sku_id")
})
@org.hibernate.annotations.Table(appliesTo = "crm_product_price_detail", comment = "商品价目明细")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ProductPriceDetailDO extends BaseModel implements Serializable {
    /**
     * 价目主键
     */
    @Comment("价目主键")
    @Column(name = "price_id")
    private Long priceId;

    /**
     * sku主键
     */
    @Comment("sku主键")
    @Column(name = "sku_id")
    private Long skuId;
    /**
     * 产品名称
     */
    @Comment("sku名称")
    @Column()
    private String skuName;
    /**
     * 产品sku编号
     */
    @Comment("产品sku编号")
    @Column()
    private String skuCode;
    /**
     * 标准价格
     */
    @Comment("标准价格")
    @Column()
    private BigDecimal standardPrice;
    /**
     * 标准价格是否改变
     */
    @Comment("标准价格是否改变")
    @Column()
    private Boolean isChange = false;

    /**
     * 销售单位udc[crm:product:sku_sale_unit]
     */
    @Comment("销售单位udc")
    @Column()
    private String saleUnit;
    /**
     * 折扣
     */
    @Comment("折扣")
    @Column()
    private BigDecimal discount;
    /**
     * 价目表价格
     */
    @Comment("价目表价格")
    @Column()
    private BigDecimal markedMoney;
    /**
     * 价格上限
     */
    @Comment("价格上限")
    @Column()
    private BigDecimal topMoney;
    /**
     * 价格下限
     */
    @Comment("价格下限")
    @Column()
    private BigDecimal floorMoney;

    public void copy(ProductPriceDetailDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
