package com.elitesland.tw.tw5crm.server.product.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 商品价目销售组织
 *
 * @author carl
 * @date 2023-03-14
 */
@Entity
@Table(name = "crm_product_price_org", indexes = {
        @Index(name = "price_index", columnList = "price_id"),
        @Index(name = "user_index", columnList = "user_id"),
        @Index(name = "org_index", columnList = "org_id")
})
@org.hibernate.annotations.Table(appliesTo = "crm_product_price_org", comment = "商品价目销售组织")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ProductPriceOrgDO extends BaseModel implements Serializable {
    /**
     * 价目主键
     */
    @Comment("价目主键")
    @Column(name = "price_id")
    private Long priceId;
    /**
     * 组织主键
     */
    @Comment("组织主键")
    @Column(name = "org_id")
    private Long orgId;
    /**
     * 组织名称
     */
    @Comment("组织名称")
    @Column()
    private String orgName;
    /**
     * 用户主键
     */
    @Comment("用户主键")
    @Column(name = "user_id")
    private Long userId;
    /**
     * 用户名称
     */
    @Comment("用户名称")
    @Column()
    private String userName;

    public void copy(ProductPriceOrgDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
