package com.elitesland.tw.tw5crm.server.product.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 商品规格组合表SKU
 *
 * @author carl.wang
 * @date 2023-03-03
 */
@Entity
@Table(name = "crm_product_sku", indexes = {
        @Index(name = "spu_index", columnList = "spu_id")
})
@org.hibernate.annotations.Table(appliesTo = "crm_product_sku", comment = "商品规格组合表SKU")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ProductSkuDO extends BaseModel implements Serializable {
    /**
     * 产品id
     */
    @Comment("产品id")
    @Column(name = "spu_id")
    private Long spuId;
    /**
     * 产品分类ID:crm_product_category.id(冗余)
     */
    @Comment("产品分类ID:crm_product_category.id(冗余)")
    @Column()
    private Long categoryId;
    /**
     * 产品分类
     */
    @Comment("产品分类")
    @Column()
    private String spuCategory;
    /**
     * 产品类型
     */
    @Comment("产品类型")
    @Column()
    private String spuType;
    /**
     * 产品名称
     */
    @Comment("产品名称")
    @Column()
    private String skuName;
    /**
     * 产品sku编号
     */
    @Comment("产品sku编号")
    @Column()
    private String skuCode;
    /**
     * 标准价格
     */
    @Comment("标准价格")
    @Column()
    private BigDecimal standardPrice;
    /**
     * 销售单位udc[crm:product:sku_sale_unit]
     */
    @Comment("销售单位udc[crm:product:sku_sale_unit]")
    @Column()
    private String saleUnit;
    /**
     * 图片地址codes（“，”分割字符串）
     */
    @Comment("图片地址codes（“，”分割字符串）")
    @Column()
    private String imgCodes;
    /**
     * 规格属性Json
     */
    @Comment("规格属性Json")
    @Column(
            name = "attribute",
            columnDefinition = "TEXT comment '规格属性Json' "
    )
    private String attribute;
    /**
     * 属性组Json
     */
    @Comment("属性组Json")
    @Column(
            name = "attribute_group",
            columnDefinition = "TEXT comment '属性组Json' "
    )
    private String attributeGroup;
    /**
     * 图文内容
     */
    @Comment("图文内容")
    @Column(
            name = "sku_content",
            columnDefinition = "TEXT comment '图文内容' "
    )
    private String skuContent;
    /**
     * 文档地址codes（“，”分割字符串）
     */
    @Comment("文档地址codes（“，”分割字符串）")
    @Column(
            name = "file_codes",
            columnDefinition = "TEXT comment '文档地址codes（“，”分割字符串）' "
    )
    private String fileCodes;
    /**
     * 状态udc[crm:product:sku_status]
     */
    @Comment("状态udc[crm:product:sku_status]")
    @Column()
    private String skuStatus;
    /**
     * 排序号
     */
    @Comment("排序号")
    @Column()
    private Integer sortNo;
    /**
     * 规格属性展示
     */
    @Comment("规格属性展示")
    @Column(
            name = "attribute_str",
            columnDefinition = "TEXT comment '规格属性展示' "
    )
    private String attributeStr;

    public void copy(ProductSkuDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
