package com.elitesland.tw.tw5crm.server.product.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 商品主表SPU
 *
 * @author carl.wang
 * @date 2023-03-03
 */
@Entity
@Table(name = "crm_product_spu", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_product_spu", comment = "商品主表SPU")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ProductSpuDO extends BaseModel implements Serializable {
    /**
     * 产品分类ID:crm_product_category.id
     */
    @Comment("产品分类ID:crm_product_category.id")
    @Column()
    private Long categoryId;
    /**
     * 产品分类
     */
    @Comment("产品分类")
    @Column()
    private String spuCategory;
    /**
     * 产品名称
     */
    @Comment("产品名称")
    @Column()
    private String spuName;
    /**
     * 产品编号
     */
    @Comment("产品编号")
    @Column()
    private String spuCode;
    /**
     * 简介
     */
    @Comment("简介")
    @Column()
    private String spuProfile;
    /**
     * 产品类型
     */
    @Comment("产品类型")
    @Column()
    private String spuType;
    /**
     * 负责人id
     */
    @Comment("负责人id")
    @Column()
    private Long manageUserId;
    /**
     * 归属部门
     */
    @Comment("归属部门")
    @Column()
    private Long orgId;
    /**
     * 图片地址codes（“，”分割字符串）
     */
    @Comment("图片地址codes（“，”分割字符串）")
    @Column()
    private String imgCodes;
    /**
     * 规格属性Json
     */
    @Comment("规格属性Json")
    @Column(
            name = "attribute",
            columnDefinition = "TEXT comment '规格属性Json' "
    )
    private String attribute;
    /**
     * 属性组Json
     */
    @Comment("属性组Json")
    @Column(
            name = "attribute_group",
            columnDefinition = "TEXT comment '属性组Json' "
    )
    private String attributeGroup;
    /**
     * 状态udc[crm:product:spu_status]
     */
    @Comment("状态udc[crm:product:spu_status]")
    @Column()
    private String spuStatus;
    /**
     * 排序号
     */
    @Comment("排序号")
    @Column()
    private Integer sortNo;

    public void copy(ProductSpuDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
