package com.elitesland.tw.tw5crm.server.product.repo;

import com.elitesland.tw.tw5crm.server.product.entity.ProductCategoryDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;

import java.util.List;

/**
* 产品分类
*
* @author duwh
* @date 2023-03-02
*/
public interface ProductCategoryRepo extends JpaRepository<ProductCategoryDO, Long>, JpaSpecificationExecutor<ProductCategoryDO> {

    /**
     * 根据父Id查询分类
     *
     * @param pid pid
     * @return {@link List}<{@link ProductCategoryDO}>
     */
    List<ProductCategoryDO> findByParentId(Long pid);

    /**
     * 查询顶级类别
     *
     * @return {@link List}<{@link ProductCategoryDO}>
     */
    List<ProductCategoryDO> findByParentIdIsNull();

    /**
     * 获取节点数量
     *
     * @param parentId 父id
     * @return int
     */
    int countByParentId(Long parentId);

    /**
     * 更新节点数目
     *
     * @param count 数
     * @param pid   pid
     */
    @Modifying
    @Query(value = " update crm_product_category set sub_count = ?1 where parent_id = ?2 ",nativeQuery = true)
    void updateSubCntById(int count, Long pid);
}
