package com.elitesland.tw.tw5crm.server.product.repo;

import com.elitesland.tw.tw5crm.server.product.entity.ProductPriceCustomerDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;

import java.util.List;

/**
 * 商品价目销售客户
 *
 * @author carl
 * @date 2023-03-14
 */
public interface ProductPriceCustomerRepo extends JpaRepository<ProductPriceCustomerDO, Long>, JpaSpecificationExecutor<ProductPriceCustomerDO> {

    @Modifying
    @Query("delete from  ProductPriceCustomerDO where  priceId =?1")
    void deleteByPriceId(Long priceId);

    /**
     * 查询销售客户
     *
     * @param priceId
     * @param deletFlag
     * @return
     */
    List<ProductPriceCustomerDO> findByPriceIdAndDeleteFlag(Long priceId, Integer deletFlag);
}
