package com.elitesland.tw.tw5crm.server.product.repo;

import com.elitesland.tw.tw5crm.server.product.entity.ProductPriceOrgDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;

import java.util.List;

/**
 * 商品价目销售组织
 *
 * @author carl
 * @date 2023-03-14
 */
public interface ProductPriceOrgRepo extends JpaRepository<ProductPriceOrgDO, Long>, JpaSpecificationExecutor<ProductPriceOrgDO> {
    @Modifying
    @Query("delete from  ProductPriceOrgDO where  priceId =?1")
    void deleteByPriceId(Long priceId);

    /**
     * 查询销售组织
     *
     * @param priceId
     * @param deletFlag
     * @return
     */
    List<ProductPriceOrgDO> findByPriceIdAndDeleteFlag(Long priceId, Integer deletFlag);
}
