package com.elitesland.tw.tw5crm.server.product.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5crm.api.product.payload.CrmBusinessAttributeGroupDetailPayload;
import com.elitesland.tw.tw5crm.api.product.payload.CrmBusinessAttributeGroupPayload;
import com.elitesland.tw.tw5crm.api.product.query.CrmBusinessAttributeGroupQuery;
import com.elitesland.tw.tw5crm.api.product.service.CrmBusinessAttributeGroupService;
import com.elitesland.tw.tw5crm.api.product.vo.CrmBusinessAttributeGroupDetailVO;
import com.elitesland.tw.tw5crm.api.product.vo.CrmBusinessAttributeGroupVO;
import com.elitesland.tw.tw5crm.server.product.convert.CrmBusinessAttributeGroupConvert;
import com.elitesland.tw.tw5crm.server.product.convert.CrmBusinessAttributeGroupDetailConvert;
import com.elitesland.tw.tw5crm.server.product.dao.CrmBusinessAttributeGroupDAO;
import com.elitesland.tw.tw5crm.server.product.dao.CrmBusinessAttributeGroupDetailDAO;
import com.elitesland.tw.tw5crm.server.product.entity.CrmBusinessAttributeGroupDO;
import com.elitesland.tw.tw5crm.server.product.entity.CrmBusinessAttributeGroupDetailDO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
* 通用扩展属性组
*
* @author liwenpeng
* @date 2023-03-02
*/
@Service
@RequiredArgsConstructor
@Slf4j
public class CrmBusinessAttributeGroupServiceImpl implements CrmBusinessAttributeGroupService {

    private final CrmBusinessAttributeGroupDAO groupDAO;
    private final CrmBusinessAttributeGroupDetailDAO groupDetailDAO;

    @Override
    public PagingVO<CrmBusinessAttributeGroupVO> paging(CrmBusinessAttributeGroupQuery query){
        PagingVO<CrmBusinessAttributeGroupVO> crmBusinessAttributeGroupVOPagingVO = groupDAO.queryPaging(query);
        List<CrmBusinessAttributeGroupVO> records = crmBusinessAttributeGroupVOPagingVO.getRecords();
        List<Long> groupIds = records.stream().map(CrmBusinessAttributeGroupVO::getId).collect(Collectors.toList());
//        List<CrmBusinessAttributeGroupDetailVO> detailsInfo = groupDetailDAO.queryDetailNameStrByGroupIdList(groupIds);
//        Map<Long, CrmBusinessAttributeGroupDetailVO> detailsMap = detailsInfo.stream().collect(Collectors.toMap(CrmBusinessAttributeGroupDetailVO::getGroupId, Function.identity()));
        List<CrmBusinessAttributeGroupDetailVO> detailsInfo = groupDetailDAO.queryByGroupId(groupIds);
        Map<Long, List<CrmBusinessAttributeGroupDetailVO>> detailsMap = detailsInfo.stream().collect(Collectors.groupingBy(CrmBusinessAttributeGroupDetailVO::getGroupId));
        records.forEach(e->{
            //完善明细信息
            if (detailsMap.get(e.getId())!=null){
                List<CrmBusinessAttributeGroupDetailVO> detailVOList = detailsMap.get(e.getId());
                e.setDetail(detailVOList);
                String detailDesc = detailVOList.stream().map(CrmBusinessAttributeGroupDetailVO::getAttributeDesc).collect(Collectors.joining("、"));
                e.setDetailDesc(detailDesc);
            }
            e.setStatusDesc(e.getStatus() == 0 ? "未启用":"已启用");/** 状态，0未启用，1已启用 */
        });
//        Page<CrmBusinessAttributeGroupDO> page = businessAttributeGroupRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root,query,criteriaBuilder),query.getPageRequest());
//        return PageUtil.toPageVo(page.map(CrmBusinessAttributeGroupConvert.INSTANCE::toVo));
        return crmBusinessAttributeGroupVOPagingVO;
    }

    @Override
    public List<CrmBusinessAttributeGroupVO> queryList(CrmBusinessAttributeGroupQuery query){
//        return CrmBusinessAttributeGroupConvert.INSTANCE.toVoList(businessAttributeGroupRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root,query,criteriaBuilder)));
        return null;
    }

    @Override
    public CrmBusinessAttributeGroupVO queryByKey(Long key) {
        CrmBusinessAttributeGroupVO vo = groupDAO.queryByKey(key);
        List<CrmBusinessAttributeGroupDetailVO> details = groupDetailDAO.queryByGroupId(key);
        vo.setDetail(details);
//        CrmBusinessAttributeGroupDO entity = businessAttributeGroupRepo.findById(key).orElseGet(CrmBusinessAttributeGroupDO::new);
//        Assert.notNull(entity.getId(), "不存在");
//        CrmBusinessAttributeGroupVO vo = CrmBusinessAttributeGroupConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public CrmBusinessAttributeGroupVO insert(CrmBusinessAttributeGroupPayload payload) {
        List<CrmBusinessAttributeGroupDetailPayload> detail = payload.getDetail();
        if (detail == null || detail.size() < 1){
            throw new RuntimeException("属性组必须设置明细属性");
        }
        payload.setStatus(0);
        CrmBusinessAttributeGroupDO entityDo = CrmBusinessAttributeGroupConvert.INSTANCE.toDo(payload);
        CrmBusinessAttributeGroupDO save = groupDAO.save(entityDo);
        Long groupId = save.getId();
        //保存明细
        insertDetail(payload,groupId);
        return CrmBusinessAttributeGroupConvert.INSTANCE.toVo(save);
    }

    private void insertDetail(CrmBusinessAttributeGroupPayload payload,Long groupId){
        List<CrmBusinessAttributeGroupDetailPayload> detail = payload.getDetail();
        if (detail != null && detail.size() > 0){
            for (CrmBusinessAttributeGroupDetailPayload detailPayload : detail){
                CrmBusinessAttributeGroupDetailDO crmBusinessAttributeGroupDetailDO = CrmBusinessAttributeGroupDetailConvert.INSTANCE.toDo(detailPayload);
                crmBusinessAttributeGroupDetailDO.setGroupId(groupId);
                groupDetailDAO.save(crmBusinessAttributeGroupDetailDO);
            }
        }

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public CrmBusinessAttributeGroupVO update(CrmBusinessAttributeGroupPayload payload) {
        if (payload.getId() == null || payload.getId() < 0){
            throw new RuntimeException("获取id异常");
        }
        List<CrmBusinessAttributeGroupDetailPayload> detail = payload.getDetail();
        if (detail == null || detail.size() < 1){
            throw new RuntimeException("属性组必须设置明细属性");
        }
        groupDAO.updateByKeyDynamic(payload);
        //先删除后新增
        groupDetailDAO.deleteByGroupId(payload.getId());
        insertDetail(payload,payload.getId());
//        CrmBusinessAttributeGroupDO entity = businessAttributeGroupRepo.findById(payload.getId()).orElseGet(CrmBusinessAttributeGroupDO::new);
//        Assert.notNull(entity.getId(), "不存在");
//        CrmBusinessAttributeGroupDO entityDo = CrmBusinessAttributeGroupConvert.INSTANCE.toDo(payload);
//        entity.copy(entityDo);
        return null;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public CrmBusinessAttributeGroupVO updateStatus(CrmBusinessAttributeGroupPayload payload) {
        if (payload.getId() == null || payload.getId() < 0){
            throw new RuntimeException("获取id异常");
        }
        groupDAO.updateByKeyDynamic(payload);
        return null;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
//        if (!keys.isEmpty()) {
//            keys.stream().forEach(id -> {
//                Optional<CrmBusinessAttributeGroupDO> optional = businessAttributeGroupRepo.findById(id);
//                if (!optional.isEmpty()) {
//                    CrmBusinessAttributeGroupDO entity = optional.get();
//                    entity.setDeleteFlag(1);
//                    businessAttributeGroupRepo.save(entity);
//                }
//             });
//        }
    }

}
