package com.elitesland.tw.tw5crm.server.product.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemSelectionPayload;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemSelectionService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5crm.api.product.payload.CrmBusinessTableColumnsPayload;
import com.elitesland.tw.tw5crm.api.product.query.CrmBusinessTableColumnsQuery;
import com.elitesland.tw.tw5crm.api.product.vo.CrmBusinessTableColumnsVO;
import com.elitesland.tw.tw5crm.api.product.payload.CrmSelectChild;
import com.elitesland.tw.tw5crm.api.product.service.CrmBusinessTableColumnsService;
import com.elitesland.tw.tw5crm.server.product.convert.CrmBusinessTableColumnsConvert;
import com.elitesland.tw.tw5crm.server.product.dao.CrmBusinessTableColumnsDAO;
import com.elitesland.tw.tw5crm.server.product.dao.CrmBusinessTableDAO;
import com.elitesland.tw.tw5crm.server.product.entity.CrmBusinessTableColumnsDO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @Author : liwenpeng
 * @create 2023/3/1 15:59
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class CrmBusinessTableColumnsServiceImpl implements CrmBusinessTableColumnsService {

    private final CrmBusinessTableColumnsDAO columnsDAO;
    private final CrmBusinessTableDAO tableDAO;
    private final PrdSystemSelectionService systemSelectionService;
    private final CacheUtil cacheUtil;

    private static final String TABLE_NAME="crm_business_table_columns";
    private static final String ATTRIBUTE_TYPE_CUSTOM="CUSTOM";
    private static final String ATTRIBUTE_TYPE_STANDARD="STANDARD";
    private static final String CUSTOM_PREFIX="custom_column";
    private static final String CUSTOM_DESC_PREFIX="自定义属性";
    private static final String SELECTION_SUFFIX="选择项";
    private static final String SELECTION_KEY_PREFIX="crm:";
    private static final String SELECTION_PARENTID="34318493798105090";
    private static final String SELECTION_FUNCTIONID="1";


    @Transactional
    @Override
    public CrmBusinessTableColumnsVO insert(CrmBusinessTableColumnsPayload payload){
        // 判断该表是否已经存入 没有就存入标准属性
//        String tableName = saveStandardColumns();
//        String tableName = saveStandardColumns();
//        if (!StringUtils.hasLength(tableName)){
//            throw new RuntimeException("没有查询到相关表数据");
//        }
        // 判断是否有系统选择项的子项 有就新增系统选择项
//        int countByTableNameAndAttributeType = columnsDAO.getCountByTableNameAndAttributeType(TABLE_NAME, ATTRIBUTE_TYPE_CUSTOM);
        // 计数用来生成系统选择项
        CrmBusinessTableColumnsVO maxSortVo = columnsDAO.geMaxSortByTableNameAndAttributeType(TABLE_NAME, ATTRIBUTE_TYPE_CUSTOM);
        int countNo = 0;
        Long tenantId = -1L;
        if (maxSortVo != null && maxSortVo.getCountNo() != null){
            countNo = maxSortVo.getCountNo();
            tenantId = maxSortVo.getTenantId();
        }
        Integer countByTableNameAndAttributeType = countNo + 1 ;

        List<CrmSelectChild> selectChildren = payload.getSelectChildren();
        if (selectChildren != null && selectChildren.size() > 0){
            //新增父级 自定义生成父级name、key、选择项值  上级和所属功能为固定值
            String pSelectionName = CUSTOM_DESC_PREFIX + countByTableNameAndAttributeType + SELECTION_SUFFIX;
            // 增加租户、防止key重复
            String pSelectionKey = SELECTION_KEY_PREFIX + TABLE_NAME + ":" + CUSTOM_PREFIX + ":" + tenantId + countByTableNameAndAttributeType;
            String pSelectionValue =  CUSTOM_PREFIX + countByTableNameAndAttributeType;

            PrdSystemSelectionVO pSystemSelectionVO = insertSelection(pSelectionName, pSelectionKey, pSelectionValue, Long.valueOf(SELECTION_PARENTID));
            Long pid = pSystemSelectionVO.getId();

            for (int i = 0; i < selectChildren.size(); i++) {
                //新增子级 自定义生成key、选择项值  上级和所属功能为固定值
                String selectionName = selectChildren.get(i).getName();
                String key = i > 9 ? i + "" : "0" + i;
                String selectionKey = pSelectionKey + ":" + key;
                String selectionValue =  key;

                insertSelection(selectionName, selectionKey, selectionValue, pid);
            }

            // 父级选择项的code存起来
            payload.setSelectionCode(pSelectionKey);
            // 值范围存一下
            String attributeScope = payload.getSelectChildren().stream().map(CrmSelectChild::getName).collect(Collectors.joining(";"));
            payload.setAttributeScope(attributeScope);

        }

        // 新增自定义属性，设置固定格式为扩展字段格式
        CrmBusinessTableColumnsDO customColumn = new CrmBusinessTableColumnsDO();
        customColumn.setTableName(TABLE_NAME);
        customColumn.setAttributeType(ATTRIBUTE_TYPE_CUSTOM);
        customColumn.setStatus(1);
        customColumn.setAttributeDesc(payload.getAttributeDesc());
        customColumn.setComponentType(payload.getComponentType());
        customColumn.setIsMultiple(payload.getIsMultiple());
        customColumn.setSelectionCode(payload.getSelectionCode());
        customColumn.setAttributeScope(payload.getAttributeScope());
        customColumn.setColumnName(CUSTOM_PREFIX + countByTableNameAndAttributeType);
        customColumn.setColumnDesc(CUSTOM_DESC_PREFIX + countByTableNameAndAttributeType);
        customColumn.setCountNo(countByTableNameAndAttributeType);
        CrmBusinessTableColumnsDO save = columnsDAO.save(customColumn);
        CrmBusinessTableColumnsVO crmBusinessTableColumnsVO = CrmBusinessTableColumnsConvert.INSTANCE.toVo(save);
        return crmBusinessTableColumnsVO;

    }
    @Override
    public CrmBusinessTableColumnsVO findByKey(Long key){
        CrmBusinessTableColumnsVO vo = columnsDAO.findByKey(key);
        if (StringUtils.hasLength(vo.getSelectionCode())){
            PrdSystemSelectionVO view = cacheUtil.getSystemSelection(vo.getSelectionCode());
            List<PrdSystemSelectionVO> children = view.getChildren();
            List<CrmSelectChild> selectChildren = children.stream().map(e -> CrmSelectChild.builder().id(e.getId()).name(e.getSelectionName()).build()).toList();
            vo.setSelectChildren(selectChildren);
        }
        return vo;

    }
    @Transactional
    @Override
    public void update(CrmBusinessTableColumnsPayload payload){
        if (payload.getSelectChildren()!=null && payload.getSelectChildren().size() > 0){
            String attributeScope = payload.getSelectChildren().stream().map(CrmSelectChild::getName).collect(Collectors.joining(";"));
            payload.setAttributeScope(attributeScope);
        }
        long update = columnsDAO.update(payload);

        //如果不是修改状态 并且有系统选择项 就要处理系统选择项的子级
        if (payload.getStatus() == null && payload.getSelectionCode() != null){
            //更新系统选择项的孩子
            String selectionCode = payload.getSelectionCode();
            PrdSystemSelectionVO systemSelection = cacheUtil.getSystemSelection(selectionCode);
            Long pid = systemSelection.getId();
            int childrenSize = systemSelection.getChildren().size();
            if (payload.getSelectChildren()!=null && payload.getSelectChildren().size() > 0){
                List<CrmSelectChild> selectChildren = payload.getSelectChildren();

                //判断需要删除的数据
                List<Long> selectChildrenIds = selectChildren.stream().filter(e -> e.getId() != null && e.getId() > 0).map(CrmSelectChild::getId).toList(); //1
                List<Long> systemSelectionChildrenIds = systemSelection.getChildren().stream().map(PrdSystemSelectionVO::getId).toList();       //1\2\3
                List<Long> deleteSystemSelectionChildrenIds = systemSelectionChildrenIds.stream().filter(e -> !selectChildrenIds.contains(e)).toList();
                systemSelectionService.deleteSoft(deleteSystemSelectionChildrenIds);

                for (CrmSelectChild selectChild : selectChildren){
                    if (selectChild.getId() != null && selectChild.getId() > 0){
                        // 更新
                        updateSelection(selectChild.getName(),selectChild.getId());
                    }else {
                        // 新增
                        //新增子级 自定义生成key、选择项值  上级和所属功能为固定值
                        String selectionName = selectChild.getName();
                        String key =childrenSize > 9 ? childrenSize + "" : "0" + childrenSize;
                        String selectionKey = selectionCode + ":" + key;
                        String selectionValue =  key;
                        insertSelection(selectionName,selectionKey,selectionValue,pid);
                        childrenSize++;
                    }

                }
            }else {
                List<Long> systemSelectionChildrenIds = systemSelection.getChildren().stream().map(PrdSystemSelectionVO::getId).toList();       //1\2\3
                systemSelectionService.deleteSoft(systemSelectionChildrenIds);
            }
        }

    }
    @Override
    public PagingVO<CrmBusinessTableColumnsVO> paging(CrmBusinessTableColumnsQuery query){
        query.setTableName(TABLE_NAME);
        PagingVO<CrmBusinessTableColumnsVO> crmBusinessTableColumnsVOPagingVO = columnsDAO.queryPaging(query);
        List<CrmBusinessTableColumnsVO> records = crmBusinessTableColumnsVOPagingVO.getRecords();
        records.forEach(e->{
            String attributeTypeDesc = Objects.equals(e.getAttributeType(), ATTRIBUTE_TYPE_CUSTOM) ? "自定义" : "标准";
            String componentTypeDesc = cacheUtil.transferSystemSelection("attribute:componentType",e.getComponentType());
            e.setAttributeTypeDesc(attributeTypeDesc);
            e.setComponentTypeDesc(componentTypeDesc);
        });
        return crmBusinessTableColumnsVOPagingVO;
    }

    private PrdSystemSelectionVO insertSelection(String pSelectionName,String pSelectionKey,String pSelectionValue,Long parentId){
        PrdSystemSelectionPayload selectionPayload = new PrdSystemSelectionPayload();
        selectionPayload.setSelectionName(pSelectionName);
        selectionPayload.setSelectionKey(pSelectionKey);
        selectionPayload.setSelectionValue(pSelectionValue);
        selectionPayload.setParentId(parentId);
        selectionPayload.setRemark("产品属性自动生成，请勿操作");
        selectionPayload.setFunctionId(Long.valueOf(SELECTION_FUNCTIONID));
        return systemSelectionService.insert(selectionPayload);
    }

    private Long updateSelection(String pSelectionName,Long id){
        PrdSystemSelectionVO prdSystemSelectionVO = systemSelectionService.queryByKey(id);
        PrdSystemSelectionPayload payload = new PrdSystemSelectionPayload();
        payload.setSelectionName(pSelectionName);
        payload.setSelectionKey(prdSystemSelectionVO.getSelectionKey());
        payload.setSelectionValue(prdSystemSelectionVO.getSelectionValue());
        payload.setParentId(prdSystemSelectionVO.getParentId());
        payload.setFunctionId(prdSystemSelectionVO.getFunctionId());
        payload.setId(id);
        return systemSelectionService.update(payload);
    }



//    private String saveStandardColumns(){
//
//        String tableName = "";
//
//        int countByTableName = tableDAO.getCountByTableName(TABLE_NAME);
//        if (countByTableName == 0){
//            List<String[]> tableAndColumnsInfo = columnsDAO.findTableAndColumnsInfoByTableName(TABLE_NAME);
//            // select a.TABLE_NAME tableName, a.TABLE_COMMENT tableComment,b.COLUMN_NAME columnName,b.DATA_TYPE dataType,b.COLUMN_COMMENT columnComment
//            if (tableAndColumnsInfo!=null && tableAndColumnsInfo.size()>0){
//                String[] infoArr = tableAndColumnsInfo.get(0);
//                tableName = infoArr[0];
//                String tableComment = infoArr[1];
//                CrmBusinessTableDO tableAdo = new CrmBusinessTableDO();
//                tableAdo.setTableName(tableName);
//                tableAdo.setTableDesc(tableComment);
//                tableDAO.save(tableAdo);
//                for (String[] columnsArr:tableAndColumnsInfo) {
//                    String columnName = columnsArr[2];
//                    String dataType = columnsArr[3];
//                    String columnComment = columnsArr[4];
//                    CrmBusinessTableColumnsDO columnsAdo = new CrmBusinessTableColumnsDO();
//                    columnsAdo.setTableName(tableName);
//                    columnsAdo.setColumnName(columnName);
//                    columnsAdo.setColumnDesc(columnComment);
//                    columnsAdo.setAttributeType(ATTRIBUTE_TYPE_STANDARD);
//                    columnsAdo.setAttributeDesc(columnName);
//                    columnsDAO.save(columnsAdo);
//                }
//
//            }
//        }
//
//        return tableName;
//
//    }
}
