package com.elitesland.tw.tw5crm.server.product.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5crm.api.product.payload.ProductCategoryAttrGroupDetailRefPayload;
import com.elitesland.tw.tw5crm.api.product.query.ProductCategoryAttrGroupDetailRefQuery;
import com.elitesland.tw.tw5crm.api.product.service.ProductCategoryAttrGroupDetailRefService;
import com.elitesland.tw.tw5crm.api.product.vo.ProductCategoryAttrGroupDetailRefVO;
import com.elitesland.tw.tw5crm.server.product.convert.ProductCategoryAttrGroupDetailRefConvert;
import com.elitesland.tw.tw5crm.server.product.entity.ProductCategoryAttrGroupDetailRefDO;
import com.elitesland.tw.tw5crm.server.product.repo.ProductCategoryAttrGroupDetailRefRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Optional;

/**
 * 产品分类属性组明细关系表
 *
 * @author duwh
 * @date 2023-03-03
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class ProductCategoryAttrGroupDetailRefServiceImpl extends BaseServiceImpl implements ProductCategoryAttrGroupDetailRefService {

    private final ProductCategoryAttrGroupDetailRefRepo productCategoryAttrGroupDetailRefRepo;

    @Override
    public PagingVO<ProductCategoryAttrGroupDetailRefVO> paging(ProductCategoryAttrGroupDetailRefQuery query) {
        Page<ProductCategoryAttrGroupDetailRefDO> page = productCategoryAttrGroupDetailRefRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest());
        return PageUtil.toPageVo(page.map(ProductCategoryAttrGroupDetailRefConvert.INSTANCE::toVo));
    }

    @Override
    public List<ProductCategoryAttrGroupDetailRefVO> queryList(ProductCategoryAttrGroupDetailRefQuery query) {
        return ProductCategoryAttrGroupDetailRefConvert.INSTANCE.toVoList(
            productCategoryAttrGroupDetailRefRepo.findAll(
                (root, criteriaQuery, criteriaBuilder)
                    -> QueryHelp.getPredicate(root, query, criteriaBuilder)
                , query.getPageRequest().getSort()
            )
        );
    }

    @Override
    public ProductCategoryAttrGroupDetailRefVO queryByKey(Long key) {
        ProductCategoryAttrGroupDetailRefDO entity = productCategoryAttrGroupDetailRefRepo.findById(key).orElseGet(ProductCategoryAttrGroupDetailRefDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ProductCategoryAttrGroupDetailRefVO vo = ProductCategoryAttrGroupDetailRefConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ProductCategoryAttrGroupDetailRefVO insert(ProductCategoryAttrGroupDetailRefPayload payload) {
        ProductCategoryAttrGroupDetailRefDO entityDo = ProductCategoryAttrGroupDetailRefConvert.INSTANCE.toDo(payload);
        return ProductCategoryAttrGroupDetailRefConvert.INSTANCE.toVo(productCategoryAttrGroupDetailRefRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ProductCategoryAttrGroupDetailRefVO update(ProductCategoryAttrGroupDetailRefPayload payload) {
        ProductCategoryAttrGroupDetailRefDO entity = productCategoryAttrGroupDetailRefRepo.findById(payload.getId()).orElseGet(ProductCategoryAttrGroupDetailRefDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ProductCategoryAttrGroupDetailRefDO entityDo = ProductCategoryAttrGroupDetailRefConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ProductCategoryAttrGroupDetailRefConvert.INSTANCE.toVo(productCategoryAttrGroupDetailRefRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<ProductCategoryAttrGroupDetailRefDO> optional = productCategoryAttrGroupDetailRefRepo.findById(id);
                if (!optional.isEmpty()) {
                    ProductCategoryAttrGroupDetailRefDO entity = optional.get();
                    entity.setDeleteFlag(1);
                    productCategoryAttrGroupDetailRefRepo.save(entity);
                }
            });
        }
    }

}
