package com.elitesland.tw.tw5crm.server.product.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5crm.api.product.payload.ProductPriceDetailPayload;
import com.elitesland.tw.tw5crm.api.product.query.ProductPriceDetailQuery;
import com.elitesland.tw.tw5crm.api.product.service.ProductPriceDetailService;
import com.elitesland.tw.tw5crm.api.product.vo.ProductPriceDetailVO;
import com.elitesland.tw.tw5crm.server.product.convert.ProductPriceDetailConvert;
import com.elitesland.tw.tw5crm.server.product.dao.ProductPriceDetailDAO;
import com.elitesland.tw.tw5crm.server.product.entity.ProductPriceDetailDO;
import com.elitesland.tw.tw5crm.server.product.repo.ProductPriceDetailRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

import java.util.*;

/**
 * 商品价目明细
 *
 * @author carl
 * @date 2023-03-14
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class ProductPriceDetailServiceImpl extends BaseServiceImpl implements ProductPriceDetailService {
    private final CacheUtil cacheUtil;
    private final ProductPriceDetailRepo productPriceDetailRepo;
    private final ProductPriceDetailDAO productPriceDetailDAO;

    @Override
    public PagingVO<ProductPriceDetailVO> paging(ProductPriceDetailQuery query) {
        Page<ProductPriceDetailDO> page = productPriceDetailRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest());
        return PageUtil.toPageVo(page.map(ProductPriceDetailConvert.INSTANCE::toVo));
    }

    @Override
    public PagingVO<ProductPriceDetailVO> queryPaging(ProductPriceDetailQuery query) {
        //处理权限
        operPermissionFlag(query);
        // 完善产品类型的税率 商机报价使用
        PagingVO<ProductPriceDetailVO> productPriceDetailVOPagingVO = productPriceDetailDAO.queryPaging(query);
        List<ProductPriceDetailVO> records = productPriceDetailVOPagingVO.getRecords();
        records.forEach(e -> {
            PrdSystemSelectionVO systemSelection = cacheUtil.getSystemSelection("crm:product:spu_type");
            if (systemSelection != null) {
                List<PrdSystemSelectionVO> systemSelectionChildren = systemSelection.getChildren();
                PrdSystemSelectionVO prdSystemSelectionVO = systemSelectionChildren.stream().filter(s -> s.getSelectionValue().equals(e.getSpuType())).findFirst().orElse(null);
                if (prdSystemSelectionVO != null) {
                    String extString1 = prdSystemSelectionVO.getExtString1();
                    e.setTaxRate(extString1);
                }
            }
        });

        return productPriceDetailVOPagingVO;
    }

    /**
     * 权限处理
     *
     * @param query
     */
    void operPermissionFlag(ProductPriceDetailQuery query) {
        Boolean rolePermission = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode()));
        query.setPermissionFlag(!rolePermission);
        if (!rolePermission) {


            Long userId = GlobalUtil.getLoginUserId();
            query.setLoginUserId(GlobalUtil.getLoginUserId());
            //负责组织
            List<Long> orgIdList = cacheUtil.getManagerOrgIdsByUserId(userId);
            Set<Long> orgIds = new HashSet<>();
            if (!ObjectUtils.isEmpty(orgIdList)) {
                orgIds.addAll(orgIdList);
            }
            //所在组织
            List<Long> longs = cacheUtil.getMyOrgIdsByUserId(userId);
            if (!ObjectUtils.isEmpty(longs)) {
                orgIds.addAll(longs);
            }
            query.setOrgIdList(orgIds);

//
//            //需要处理权限
//            Long userId = GlobalUtil.getLoginUserId();
//            query.setCreateUserId(GlobalUtil.getLoginUserId());
//            //归属组织
//            List<Long> orgIdList = cacheUtil.getManagerOrgIdsByUserId(userId);
//            query.setOrgIdList(new HashSet<>());
//            query.getOrgIdList().addAll(orgIdList);
//            //
//            List<Long> longs = cacheUtil.getMyOrgIdsByUserId(userId);
//            if (!ObjectUtils.isEmpty(longs)) {
//                query.getOrgIdList().addAll(longs);
//            }
        }
    }

    @Override
    public List<ProductPriceDetailVO> queryList(ProductPriceDetailQuery query) {
        return ProductPriceDetailConvert.INSTANCE.toVoList(
                productPriceDetailRepo.findAll(
                        (root, criteriaQuery, criteriaBuilder)
                                -> QueryHelp.getPredicate(root, query, criteriaBuilder)
                        , query.getPageRequest().getSort()
                )
        );
    }

    @Override
    public List<ProductPriceDetailVO> queryListDynamic(ProductPriceDetailQuery query) {
        return productPriceDetailDAO.queryListDynamic(query);
    }

    @Override
    public ProductPriceDetailVO queryByKey(Long key) {
        ProductPriceDetailDO entity = productPriceDetailRepo.findById(key).orElseGet(ProductPriceDetailDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ProductPriceDetailVO vo = ProductPriceDetailConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ProductPriceDetailVO insert(ProductPriceDetailPayload payload) {
        ProductPriceDetailDO entityDo = ProductPriceDetailConvert.INSTANCE.toDo(payload);
        return ProductPriceDetailConvert.INSTANCE.toVo(productPriceDetailRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ProductPriceDetailVO update(ProductPriceDetailPayload payload) {
        ProductPriceDetailDO entity = productPriceDetailRepo.findById(payload.getId()).orElseGet(ProductPriceDetailDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ProductPriceDetailDO entityDo = ProductPriceDetailConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ProductPriceDetailConvert.INSTANCE.toVo(productPriceDetailRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<ProductPriceDetailDO> optional = productPriceDetailRepo.findById(id);
                if (!optional.isEmpty()) {
                    ProductPriceDetailDO entity = optional.get();
                    entity.setDeleteFlag(1);
                    productPriceDetailRepo.save(entity);
                }
            });
        }
    }

//    @Override
//    @Transactional(rollbackFor = Exception.class)
//    public void deleteSoftBySkuIds(List<Long> skuIds) {
//        productPriceDetailDAO.deleteSoftBySkuIds(skuIds);
//    }
//
//    @Override
//    public List<ProductPriceDetailVO> queryListBySkuIds(List<Long> skuIds) {
//        return productPriceDetailDAO.queryBySkuIds(skuIds);
//    }

}
