package com.elitesland.tw.tw5crm.server.product.service;

import com.alibaba.fastjson.JSONObject;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgOrganizationDO;
import com.elitesland.tw.tw5crm.api.common.change.service.ComBusinessChangeService;
import com.elitesland.tw.tw5crm.api.product.dto.ProductAttrGroupJsonDTO;
import com.elitesland.tw.tw5crm.api.product.dto.ProductAttrJsonDTO;
import com.elitesland.tw.tw5crm.api.product.dto.ProductAttrUdcValueDTO;
import com.elitesland.tw.tw5crm.api.product.payload.ProductSkuPayload;
import com.elitesland.tw.tw5crm.api.product.payload.ProductSpuPayload;
import com.elitesland.tw.tw5crm.api.product.query.ProductSpuQuery;
import com.elitesland.tw.tw5crm.api.product.service.ProductSkuService;
import com.elitesland.tw.tw5crm.api.product.service.ProductSpuService;
import com.elitesland.tw.tw5crm.api.product.vo.ProductSkuVO;
import com.elitesland.tw.tw5crm.api.product.vo.ProductSpuVO;
import com.elitesland.tw.tw5crm.server.common.change.changeTypeEnum.ChangeTypeEnum;
import com.elitesland.tw.tw5crm.server.common.constants.GenerateSeqNumConstants;
import com.elitesland.tw.tw5crm.server.common.constants.ProductComponentType;
import com.elitesland.tw.tw5crm.server.product.convert.ProductSpuConvert;
import com.elitesland.tw.tw5crm.server.product.dao.ProductSkuDAO;
import com.elitesland.tw.tw5crm.server.product.dao.ProductSpuDAO;
import com.elitesland.tw.tw5crm.server.product.entity.ProductSpuDO;
import com.elitesland.tw.tw5crm.server.product.repo.ProductSpuRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 商品主表SPU
 *
 * @author carl.wang
 * @date 2023-03-03
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class ProductSpuServiceImpl extends BaseServiceImpl implements ProductSpuService {
    private final ComBusinessChangeService service;
    private final ProductSpuRepo productSpuRepo;
    private final ProductSpuDAO dao;
    private final ProductSkuDAO daoSku;
    //    private final ProductSkuRepo productSkuRepo;
    private final CacheUtil cacheUtil;
    private final PrdOrgOrganizationDAO prdOrgOrganizationDAO;
    private final FileUtil fileUtil;
    private final ProductSkuService productSkuService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ProductSpuVO insert(ProductSpuPayload payload) {

        return saveData(payload, null);
    }

    /**
     * 数据保存
     *
     * @param payload
     * @return
     */
    ProductSpuVO saveData(ProductSpuPayload payload, ProductSpuVO productSpuVO) {
        //规格属性
        List<ProductAttrJsonDTO> attributes = payload.getAttributes();
        //规格属性组
        List<ProductAttrGroupJsonDTO> attributeGroups = payload.getAttributeGroups();
        //规格租户数据
        List<ProductSkuPayload> skuPayloads = payload.getSkuPayloads();

        //数据校验
        checkDatas(attributes, attributeGroups, skuPayloads);

        String attributeStr = JSONObject.toJSONString(attributes);
        ProductSpuDO entityDo = ProductSpuConvert.INSTANCE.toDo(payload);

        entityDo.setAttribute(attributeStr);
        if (!ObjectUtils.isEmpty(attributeGroups)) {
            String attributeGroupStr = JSONObject.toJSONString(attributeGroups);
            entityDo.setAttributeGroup(attributeGroupStr);
        }
        if (payload.getId() == null) {
            String code = generateSeqNum(GenerateSeqNumConstants.CRM_PRODUCT_SPU);
            entityDo.setSpuCode(code);
        } else {
            //删除skuids
            if (!ObjectUtils.isEmpty(payload.getDelSkuIds())) {
                productSkuService.deleteSoft(payload.getDelSkuIds());
            }
        }

        entityDo = dao.save(entityDo);
        //保存sku数据
        if (!ObjectUtils.isEmpty(skuPayloads)) {
            //表示变更数据
            List<ProductSkuVO> skuPayloads1 = null;
            if (!ObjectUtils.isEmpty(productSpuVO)) {
                skuPayloads1 = productSpuVO.getSkuPayloads();

            }

            //  List<ProductSkuDO> productSkuDOs = new ArrayList<>();
            for (int i = 0; i < skuPayloads.size(); i++) {

                ProductSkuPayload skuPayload = skuPayloads.get(i);

                List<ProductAttrJsonDTO> attributes1 = skuPayload.getAttributes();
                //拼装列表展示字符串
                String attributeStr1 = "";
                for (ProductAttrJsonDTO attribute : attributes1) {
                    List<ProductAttrUdcValueDTO> attrValues = attribute.getAttrValues();
                    if (!CollectionUtils.isEmpty(attrValues)) {
                        String collect = attrValues.stream().map(ProductAttrUdcValueDTO::getSelectionName).collect(Collectors.joining(","));
                        attributeStr1 += collect + ",";
                    }
                }
                if (!"".equals(attributeStr1)) {
                    attributeStr1 = attributeStr1.substring(0, attributeStr1.length() - 1);
                }
                //ProductSkuDO productSkuDO = ProductSkuConvert.INSTANCE.toDo(skuPayload);
                skuPayload.setSpuCategory(entityDo.getSpuCategory());
                skuPayload.setSpuType(entityDo.getSpuType());
                skuPayload.setAttribute(JSONObject.toJSONString(attributes1));
                List<ProductAttrGroupJsonDTO> attributeGroups1 = skuPayload.getAttributeGroups();
                if (!ObjectUtils.isEmpty(attributeGroups1)) {
                    skuPayload.setAttributeGroup(JSONObject.toJSONString(attributeGroups1));
                }
                skuPayload.setAttributeStr(attributeStr1);
                skuPayload.setSpuId(entityDo.getId());
                //原始不可变更值重新赋值
                if (skuPayload.getId() != null && skuPayloads1 != null) {
                    Optional<ProductSkuVO> first = skuPayloads1.stream().filter(skuPayload1 -> skuPayload1.getId().equals(skuPayload.getId())).findFirst();
                    if (first.isPresent()) {
                        ProductSkuVO productSkuVO = first.get();
                        skuPayload.setSkuStatus(productSkuVO.getSkuStatus());
                        skuPayload.setSkuCode(productSkuVO.getSkuCode());
                        skuPayload.setSpuId(productSkuVO.getSpuId());
                        skuPayload.setCreateUserId(productSkuVO.getCreateUserId());

                    }
                }
                // productSkuDOs.add(productSkuDO);
            }
            List<ProductSkuPayload> collect = skuPayloads.stream().filter(productSku -> productSku.getId() == null).collect(Collectors.toList());
            if (!ObjectUtils.isEmpty(collect)) {
                int count = skuPayloads.size() - collect.size();
                for (int i = 0; i < collect.size(); i++) {
                    ProductSkuPayload productSkuDO = collect.get(i);
                    String skuCode = entityDo.getSpuCode() + "-" + (i + count + 1);
                    productSkuDO.setSkuCode(skuCode);
                    productSkuDO.setSkuStatus("off");
                }
            }
            productSkuService.saveAll(skuPayloads);

        }
        return ProductSpuConvert.INSTANCE.toVo(entityDo);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ProductSpuVO update(ProductSpuPayload payload) {
        if (payload.getId() == null) {
            throw TwException.error("", "变更数据主键不可为空，请核验！");
        }
        ProductSpuVO productSpuVO = queryByKey(payload.getId());

        saveData(payload, productSpuVO);

        ProductSpuVO productSpuVO1 = queryByKey(payload.getId());
        service.save(ChangeTypeEnum.PROJECT.getCode(), productSpuVO, productSpuVO1, productSpuVO.getId() + "");

        return productSpuVO1;
    }

    /**
     * 校验数据
     *
     * @param attributes
     * @param attributeGroups
     * @param skuPayloads
     */
    void checkDatas(List<ProductAttrJsonDTO> attributes, List<ProductAttrGroupJsonDTO> attributeGroups, List<ProductSkuPayload> skuPayloads) {

        /**
         * 校验范围
         *  spu范围：
         *    1.spu规格属性必须要有
         *    2.规格属性不能重复
         *    3.必填字段不可为空
         *    4.spu中拓展属性组中不能存在sku类型的属性
         *    2.spu中拓展属性组中属性必填校验
         *  sku范围：
         *    1.sku属性范围必须实在spu属性范围内
         *    2.sku对拓展属性组中的spu类型属性不能编辑
         *    3.sku属性类型必填校验
         */


        //1.校验属性规格
        if (ObjectUtils.isEmpty(attributes)) {
            throw TwException.error("", "规格属性不可为空，请核验！");
        }
        Map<String, List<String>> attributeMap = new HashMap<>();
        attributes.forEach(attribute -> {
            if (attributeMap.containsKey(attribute.getAttrId())) {
                throw TwException.error("", "规格属性名不可重复，请核验！");
            }
            List<ProductAttrUdcValueDTO> attrValues = attribute.getAttrValues();
            if (!ObjectUtils.isEmpty(attrValues)) {
                List<String> selectValues = attrValues.stream().map(ProductAttrUdcValueDTO::getSelectionValue).distinct().collect(Collectors.toList());
                //判断属性选项是否重复
                if (attrValues.size() != selectValues.size()) {
                    throw TwException.error("", "规格属性值不可重复，请核验！");
                }
                attributeMap.put(attribute.getAttrId(), selectValues);
            } else {
                if (attribute.getIsRequired() == 1) {
                    if (!ObjectUtils.isEmpty(attribute.getObjValue())) {
                        attributeMap.put(attribute.getAttrId(), List.of(attribute.getObjValue() + ""));
                    } else {
                        throw TwException.error("", "[" + attribute.getAttrDesc() + "]为必填字段不可为空，请核验！");
                    }

                }
            }
        });
        //存储拓展属性组
        Map<String, Map<String, List<ProductAttrUdcValueDTO>>> groupMap = new HashMap<>();
        // 2.校验拓展属性组
        if (!ObjectUtils.isEmpty(attributeGroups)) {
            attributeGroups.forEach(attributeGroup -> {
                Map<String, List<ProductAttrUdcValueDTO>> longListMap = groupMap.get(attributeGroup.getGroupId());
                if (ObjectUtils.isEmpty(longListMap)) {
                    longListMap = new HashMap<>();
                    groupMap.put(attributeGroup.getGroupId(), longListMap);
                }
                List<ProductAttrJsonDTO> attrValues = attributeGroup.getAttrList();
                groupMap.put(attributeGroup.getGroupId(), longListMap);
                for (ProductAttrJsonDTO attrValue : attrValues) {
                    String unitClass = attrValue.getUnitClass();
                    //只有spu的拓展属性组能在产品里展示
                    if (!unitClass.toLowerCase().equals("spu")) {
                        //判断是选择项
                        if (attrValue.getComponentType().equals(ProductComponentType.SELECT.getCode())) {
                            if (!ObjectUtils.isEmpty(attrValue.getAttrValues())) {
                                throw TwException.error("", "拓展属性中维护级别非spu属性不能存储，请核验！");
                            }
                        }
                        //判断是输入框
                        if (attrValue.getComponentType().equals(ProductComponentType.INPUT.getCode())) {
                            if (!ObjectUtils.isEmpty(attrValue.getObjValue())) {
                                throw TwException.error("", "拓展属性中维护级别非spu属性不能存储，请核验！");
                            }
                        }
                    } else {
                        //必填校验
                        if (!ObjectUtils.isEmpty(attrValue.getAttrValues())) {
                            longListMap.put(attrValue.getAttrId(), attrValue.getAttrValues());
                        } else {
                            if (attrValue.getIsRequired() == 1) {
                                if (attrValue.getComponentType().equals(ProductComponentType.INPUT.getCode())) {
                                    if (ObjectUtils.isEmpty(attrValue.getObjValue())) {
                                        throw TwException.error("", "拓展属性组[" + attributeGroup.getGroupName() + "]—[" + attrValue.getAttrDesc() + "]为必填字段不可为空，请核验！");

                                    }
                                } else {
                                    throw TwException.error("", "拓展属性组[" + attributeGroup.getGroupName() + "]—[" + attrValue.getAttrDesc() + "]为必填字段不可为空，请核验！");

                                }
                            }
                        }
                    }
                }
            });

        }

        //3.校验产品组合
        if (!ObjectUtils.isEmpty(skuPayloads)) {

            int size = attributes.size();
            skuPayloads.forEach(skuPayload -> {
                //3.1产品组合中规格属性校验
                List<ProductAttrJsonDTO> attributes1 = skuPayload.getAttributes();
                //
//                if (size != attributes1.size()) {
//                    throw TwException.error("", "产品组合属性名范围必须在产品属性名范畴内，请核验！");
//                }
                attributes1.forEach(attribute -> {
                    List<String> strings = attributeMap.get(attribute.getAttrId());
                    List<ProductAttrUdcValueDTO> attrValues = attribute.getAttrValues();
                    if (!CollectionUtils.isEmpty(attrValues)) {
                        attrValues.forEach(attrValue -> {
                            if (!strings.contains(attrValue.getSelectionValue())) {
                                throw TwException.error("", "产品组合属性值范围必须在产品属性值范畴内，请核验！");
                            }
                        });
                    }
                });
                //3.2.校验拓展属性组
                List<ProductAttrGroupJsonDTO> attributeGroups1 = skuPayload.getAttributeGroups();
                if (!ObjectUtils.isEmpty(attributeGroups1)) {
                    attributeGroups1.forEach(attributeGroup -> {
                        List<ProductAttrJsonDTO> attrValues = attributeGroup.getAttrList();
                        for (ProductAttrJsonDTO attrValue : attrValues) {
                            String unitClass = attrValue.getUnitClass();
                            if (unitClass.toLowerCase().equals("spu")) {
                                //判断拓展属性组中归属spu的属性是否发生变更
                                Map<String, List<ProductAttrUdcValueDTO>> longListMap = groupMap.get(attributeGroup.getGroupId());
                                if (!ObjectUtils.isEmpty(longListMap)) {
                                    List<ProductAttrUdcValueDTO> productAttrUdcValueDTOS = longListMap.get(attrValue.getAttrId());
                                    List<ProductAttrUdcValueDTO> attrValues1 = attrValue.getAttrValues();
                                    if (!ObjectUtils.isEmpty(productAttrUdcValueDTOS) && !ObjectUtils.isEmpty(attrValues1) && !productAttrUdcValueDTOS.containsAll(attrValues1)) {
                                        if (productAttrUdcValueDTOS.size() != attrValues1.size()) {
                                            throw TwException.error("", "sku对拓展属性组中的spu类型属性不能编辑，请核验！");
                                        }
                                    }
                                }
                            } else {
                                //必填校验
                                if (ObjectUtils.isEmpty(attrValue.getAttrValues()) && ObjectUtils.isEmpty(attrValue.getObjValue())) {
                                    if (attrValue.getIsRequired() == 1) {
                                        throw TwException.error("", "拓展属性组[" + attributeGroup.getGroupName() + "]—[" + attrValue.getAttrDesc() + "]为必填字段不可为空，请核验！");
                                    }
                                }
//                                if (ObjectUtils.isEmpty(attrValue.getObjValue())) {
//                                    if (attrValue.getIsRequired() == 1) {
//                                        throw TwException.error("", "拓展属性组[" + attributeGroup.getGroupName() + "]—[" + attrValue.getAttrDesc() + "]为必填字段不可为空，请核验！");
//                                    }
//                                }

                            }
                        }
                    });
                }
            });
        }

    }

    /**
     * 权限处理
     *
     * @param query
     */
    void operPermissionFlag(ProductSpuQuery query) {
        Boolean rolePermission = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode()));
        query.setPermissionFlag(!rolePermission);
        if (!rolePermission) {
            //需要处理权限
            Long userId = GlobalUtil.getLoginUserId();
            query.setCreateUserId(GlobalUtil.getLoginUserId());
            final List<PrdOrgOrganizationDO> organizationDOList = prdOrgOrganizationDAO.queryByManagerId(userId);
            Set<Long> orgIdList = null;
            if (!CollectionUtils.isEmpty(organizationDOList)) {
                orgIdList = organizationDOList.stream().map(PrdOrgOrganizationDO::getId).collect(Collectors.toSet());
            }
            query.setOrgIdList(orgIdList);

        }
    }

    @Override
    public PagingVO<ProductSpuVO> paging(ProductSpuQuery query) {
        //权限处理
        operPermissionFlag(query);

        PagingVO<ProductSpuVO> productSpuVOPagingVO = dao.queryPaging(query);
        List<ProductSpuVO> spuVOs = productSpuVOPagingVO.getRecords();
        if (!ObjectUtils.isEmpty(spuVOs)) {
            List<Long> spuVOIds = spuVOs.stream().map(ProductSpuVO::getId).collect(Collectors.toList());
            //获取sku数据
            List<ProductSkuVO> productSkuVOS = daoSku.queryListBySpuIds(spuVOIds);
            spuVOs.forEach(spuVO -> {
                //筛选归属产品sku
                List<ProductSkuVO> collect = productSkuVOS.stream().filter(productSkuVO -> productSkuVO.getSpuId().equals(spuVO.getId())).collect(Collectors.toList());
                spuVO.setSkuPayloads(collect);
                //数据翻译
                transferSpuData(spuVO);
            });

        }
        return productSpuVOPagingVO;
//        Page<ProductSpuDO> page = productSpuRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest());
//        return PageUtil.toPageVo(page.map(ProductSpuConvert.INSTANCE::toVo));
    }


    @Override
    public List<ProductSpuVO> queryList(ProductSpuQuery query) {
        return ProductSpuConvert.INSTANCE.toVoList(productSpuRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    /**
     * spu数据翻译
     *
     * @param spuVO
     */
    void transferSpuData(ProductSpuVO spuVO) {
        spuVO.setImgDatas(fileUtil.getFileDatas(spuVO.getImgCodes()));
        String attribute = spuVO.getAttribute();
        if (StringUtils.hasText(attribute)) {
            spuVO.setAttributes(JSONObject.parseArray(attribute, ProductAttrJsonDTO.class));
        }
        String attributeGroup = spuVO.getAttributeGroup();
        if (StringUtils.hasText(attributeGroup)) {
            spuVO.setAttributeGroups(JSONObject.parseArray(attributeGroup, ProductAttrGroupJsonDTO.class));
        }
        List<ProductSkuVO> skuPayloads = spuVO.getSkuPayloads();
        if (!ObjectUtils.isEmpty(skuPayloads)) {
            skuPayloads.forEach(skuPayload -> transferSkuData(skuPayload));
        }
        spuVO.setAttribute("");
        spuVO.setAttributeGroup("");
        spuVO.setManageUserName(cacheUtil.getUserName(spuVO.getManageUserId()));
        spuVO.setOrgName(cacheUtil.getOrgName(spuVO.getOrgId()));
    }

    /**
     * sku数据翻译
     *
     * @param skuVO
     */
    void transferSkuData(ProductSkuVO skuVO) {
        skuVO.setImgDatas(fileUtil.getFileDatas(skuVO.getImgCodes()));
        skuVO.setFileDatas(fileUtil.getFileDatas(skuVO.getFileCodes()));
        String attribute = skuVO.getAttribute();
        if (StringUtils.hasText(attribute)) {
            skuVO.setAttributes(JSONObject.parseArray(attribute, ProductAttrJsonDTO.class));
        }
        String attributeGroup = skuVO.getAttributeGroup();
        if (StringUtils.hasText(attributeGroup)) {
            skuVO.setAttributeGroups(JSONObject.parseArray(attributeGroup, ProductAttrGroupJsonDTO.class));
        }
    }

    @Override
    public ProductSpuVO queryByKey(Long key) {
        ProductSpuVO spuVO = dao.queryByKey(key);
        if (ObjectUtils.isEmpty(spuVO)) {
            throw TwException.error("", "产品数据不存在，请核验！");
        }
        List<ProductSkuVO> productSkuVOS = daoSku.queryListBySpuIds(List.of(spuVO.getId()));
        spuVO.setSkuPayloads(productSkuVOS);
        //数据翻译
        transferSpuData(spuVO);

        return spuVO;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            List<ProductSkuVO> productSkuVOS = daoSku.queryListBySpuIds(keys);
            List<Long> skuIds = new ArrayList<>();
            productSkuVOS.forEach(skuDO -> {
                if (skuDO.getSkuStatus().equals("on")) {
                    throw TwException.error("", "请先将产品下架后再进行删除！");
                }
                skuIds.add(skuDO.getId());
            });
            //删除spu
            dao.deleteSoft(keys);
            //删除sku
            productSkuService.deleteSoft(skuIds);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoftSku(List<Long> keys) {
        if (!keys.isEmpty()) {
            List<ProductSkuVO> productSkuDOs = daoSku.queryByKeys(keys);
            productSkuDOs.forEach(skuDO -> {
                if (skuDO.getSkuStatus().equals("on")) {
                    throw TwException.error("", "请先将产品下架后再进行删除！");
                }
            });
            //删除sku
            productSkuService.deleteSoft(keys);
        }
    }
}
