package com.elitesland.tw.tw5crm.server.sale.controller;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitesland.tw.tw5crm.api.sale.payload.ExamInformationPayload;
import com.elitesland.tw.tw5crm.api.sale.query.ExamInformationQuery;
import com.elitesland.tw.tw5crm.api.sale.service.ExamInformationService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;


import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 指标考核信息
 *
 * @author kola
 * @date 2023-04-03
 */
@Api(tags = "sale")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/examInformation")
@Slf4j
public class ExamInformationController {

    private final ExamInformationService examInformationService;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("新增")
    public TwOutputUtil insert(@RequestBody ExamInformationPayload payload){
        return TwOutputUtil.ok(examInformationService.insert(payload));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("更新")
    public TwOutputUtil update(@RequestBody ExamInformationPayload payload){
        return TwOutputUtil.ok(examInformationService.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("主键查询")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(examInformationService.queryByKey(key));
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("分页")
    public TwOutputUtil paging(ExamInformationQuery query) {
        return TwOutputUtil.ok(examInformationService.queryPaging(query));
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("查询列表")
    public TwOutputUtil queryList(ExamInformationQuery query) {
        return TwOutputUtil.ok(examInformationService.queryListDynamic(query));
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        examInformationService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
