package com.elitesland.tw.tw5crm.server.sale.controller;


import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitesland.tw.tw5crm.api.sale.payload.SaleGoalPayload;
import com.elitesland.tw.tw5crm.api.sale.query.SaleGoalQuery;
import com.elitesland.tw.tw5crm.api.sale.query.SaleTargetStatisticalQuery;
import com.elitesland.tw.tw5crm.api.sale.service.SaleGoalService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 销售目标主表
 *
 * @author kola
 * @date 2023-04-03
 */
@Api(tags = "sale")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/sale/goal")
@Slf4j
public class SaleGoalController {

    private final SaleGoalService saleGoalService;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("新增")
    public TwOutputUtil insert(@RequestBody SaleGoalPayload payload){
        return TwOutputUtil.ok(saleGoalService.insert(payload));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("更新")
    public TwOutputUtil update(@RequestBody SaleGoalPayload payload){
        return TwOutputUtil.ok(saleGoalService.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("主键查询")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(saleGoalService.queryByKey(key));
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("分页")
    public TwOutputUtil paging(SaleGoalQuery query) {
        return TwOutputUtil.ok(saleGoalService.queryPaging(query));
    }

    @GetMapping("/saleTargetStatistical")
    @ApiOperation("销售目标统计")
    public TwOutputUtil saleTargetStatistical(SaleTargetStatisticalQuery query) {
        return TwOutputUtil.ok(saleGoalService.saleTargetStatistical(query));
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("查询列表")
    public TwOutputUtil queryList(SaleGoalQuery query) {
        return TwOutputUtil.ok(saleGoalService.queryListDynamic(query));
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        saleGoalService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
