package com.elitesland.tw.tw5crm.server.sale.controller;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitesland.tw.tw5crm.api.sale.payload.SaleTargetPayload;
import com.elitesland.tw.tw5crm.api.sale.query.SaleTargetCustomerQuery;
import com.elitesland.tw.tw5crm.api.sale.query.SaleTargetQuery;
import com.elitesland.tw.tw5crm.api.sale.query.SaleTargetStatisticalQuery;
import com.elitesland.tw.tw5crm.api.sale.query.SaleTargetUserOrgQuery;
import com.elitesland.tw.tw5crm.api.sale.service.SaleTargetService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;


import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 销售目标明细
 *
 * @author kola
 * @date 2023-04-03
 */
@Api(tags = "sale")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/sale/target")
@Slf4j
public class SaleTargetController {

    private final SaleTargetService saleTargetService;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("新增")
    public TwOutputUtil insert(@RequestBody SaleTargetPayload payload){
        return TwOutputUtil.ok(saleTargetService.insert(payload));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("更新")
    public TwOutputUtil update(@RequestBody SaleTargetPayload payload){
        return TwOutputUtil.ok(saleTargetService.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("主键查询")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(saleTargetService.queryByKey(key));
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("分页")
    public TwOutputUtil paging(SaleTargetQuery query) {
        return TwOutputUtil.ok(saleTargetService.queryPaging(query));
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("查询列表")
    public TwOutputUtil queryList(SaleTargetQuery query) {
        return TwOutputUtil.ok(saleTargetService.queryListDynamic(query));
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        saleTargetService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }
    /**
     * 统计
     * @param query
     * @return
     */
    @GetMapping("countUserOrder")
    @ApiOperation("人员销售目标排行榜")
    @UdcNameClass
    public TwOutputUtil countUserOrder(SaleTargetStatisticalQuery query) {
        return TwOutputUtil.ok(saleTargetService.queryCountUserOrder(query));
    }


    /**
     * 人员组织维度统计
     * @param query
     * @return
     */
    @GetMapping("countUserOrg")
    @ApiOperation("人员组织维度统计")
    public TwOutputUtil countUserOrg(SaleTargetUserOrgQuery query) {
        return TwOutputUtil.ok(saleTargetService.queryUserOrgCount(query));
    }

    @GetMapping("countCustomer")
    @ApiOperation("客户维度统计")
    public TwOutputUtil countCustomer(SaleTargetCustomerQuery query) {
        return TwOutputUtil.ok(saleTargetService.queryCustomerCount(query));
    }


    @GetMapping("countCustomerOrder")
    @ApiOperation("客户销售目标排行榜")
    public TwOutputUtil countCustomerOrder(SaleTargetStatisticalQuery query) {
        return TwOutputUtil.ok(saleTargetService.countCustomerOrder(query));
    }
    @GetMapping("countProductOrder")
    @ApiOperation("客户销售目标排行榜")
    public TwOutputUtil countProductOrder(SaleTargetStatisticalQuery query) {
        return TwOutputUtil.ok(saleTargetService.countProductOrder(query));
    }

}
