package com.elitesland.tw.tw5crm.server.sale.dao;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.ab.entity.QPrdAbDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmCustomerDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmLeadsDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmOpportunityDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgCompanyDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeRefDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.prj.entity.QPrjProjectDO;
import com.elitesland.tw.tw5crm.api.sale.payload.SaleGoalPayload;
import com.elitesland.tw.tw5crm.api.sale.query.SaleGoalQuery;
import com.elitesland.tw.tw5crm.api.sale.query.SaleTargetStatisticalQuery;
import com.elitesland.tw.tw5crm.api.sale.vo.ExamInformationVO;
import com.elitesland.tw.tw5crm.api.sale.vo.SaleGoalVO;
import com.elitesland.tw.tw5crm.api.sale.vo.SaleTargetDualVO;
import com.elitesland.tw.tw5crm.api.sale.vo.SaleTargetVO;
import com.elitesland.tw.tw5crm.server.common.constants.*;
import com.elitesland.tw.tw5crm.server.sale.entity.QSaleGoalDO;
import com.elitesland.tw.tw5crm.server.sale.entity.QSaleTargetDO;
import com.elitesland.tw.tw5crm.server.sale.entity.SaleGoalDO;
import com.elitesland.tw.tw5crm.server.sale.repo.SaleGoalRepo;
import com.elitesland.tw.tw5crm.server.visit.entity.QVisitPlanDetailDO;
import com.elitesland.tw.tw5crm.server.visit.entity.QVisitTaskDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.StringTemplate;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.*;

/**
 * sale
 *
 * @author kola
 * @date 2023-04-03
 */
@Repository
@RequiredArgsConstructor
public class SaleGoalDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final SaleGoalRepo repo;
    private final QSaleGoalDO qdo = QSaleGoalDO.saleGoalDO;
    private final QSaleTargetDO qSaleTargetDO = QSaleTargetDO.saleTargetDO;

    private final QVisitTaskDO qVisitTaskDO = QVisitTaskDO.visitTaskDO;
    private final QCrmCustomerDO qCrmCustomerDO = QCrmCustomerDO.crmCustomerDO;
    private final QPrdAbDO qdoAb = QPrdAbDO.prdAbDO;
//    private final QCrmLeadsDO qdoLeads = QCrmLeadsDO.crmLeadsDO;
//    private final QCrmLeadsDO qdoLeads1 = new QCrmLeadsDO("qdoLeads1");
//    private final QCrmOpportunityDO qdoOpportunity = QCrmOpportunityDO.crmOpportunityDO;
    private final QPrdOrgCompanyDO qdoCompany = QPrdOrgCompanyDO.prdOrgCompanyDO;
    private final QVisitPlanDetailDO qVisitPlanDetailDO=QVisitPlanDetailDO.visitPlanDetailDO;
    private final QPrdOrgEmployeeDO qEmp = QPrdOrgEmployeeDO.prdOrgEmployeeDO;
    private final QPrdOrgOrganizationDO qdoOrg = QPrdOrgOrganizationDO.prdOrgOrganizationDO;
    private final QPrdOrgEmployeeRefDO qdoRef = QPrdOrgEmployeeRefDO.prdOrgEmployeeRefDO;

    // 线索
    private final QCrmLeadsDO qdoLeads = QCrmLeadsDO.crmLeadsDO;
    // 项目表
    private final QPrjProjectDO qPrjProjectDO = QPrjProjectDO.prjProjectDO;
    // 商机表
    private final QCrmOpportunityDO qCrmOpportunityDO = QCrmOpportunityDO.crmOpportunityDO;
    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<SaleGoalVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(SaleGoalVO.class,
                        qdo.id,
                        //qdo.remark,
                        //qdo.createUserId,
                        //qdo.creator,
                        //qdo.createTime,
                        //qdo.modifyUserId,
                        //qdo.updater,
                        //qdo.modifyTime,
                        // 主目标名称
                        qdo.goalName,
                        // 统计财年
                        qdo.fiscalYear,
                        // 主目标负责人主键 prd_org_employee.user_id
                        qdo.dutyId,
                        // 主目标负责人姓名 prd_org_employee.employee_name
                        qdo.dutyName,
                        // udc[crm:goal_type](人员目标、客户目标、产品目标)
                        qdo.goalType,
                        // 拓展字段1
                        qdo.ext1,
                        // 拓展字段2
                        qdo.ext2,
                        // 拓展字段3
                        qdo.ext3,
                        // 拓展字段4
                        qdo.ext4,
                        // 拓展字段5
                        qdo.ext5,
                        //目标总值
                        qdo.targetCount,
                        //考核指标
                        qdo.examTarget
                )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<SaleGoalVO> getJpaQueryWhere(SaleGoalQuery query) {
        JPAQuery<SaleGoalVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(SaleGoalQuery query) {
        long total = jpaQueryFactory
                .select(qdo.count())
                .from(qdo)
                .where(where(query))
                .fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(SaleGoalQuery query) {
        List<Predicate> list = new ArrayList<>();
        /** 主目标ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 主目标名称 模糊 */
        if (!ObjectUtils.isEmpty(query.getGoalName())) {
            list.add(qdo.goalName.like(SqlUtil.toSqlLikeString(query.getGoalName())));
        }
        /** 统计财年 精确 */
        if (!ObjectUtils.isEmpty(query.getFiscalYear())) {
            list.add(qdo.fiscalYear.eq(query.getFiscalYear()));
        }
        /** 主目标负责人主键 prd_org_employee.user_id 精确 */
        if (!ObjectUtils.isEmpty(query.getDutyId())) {
            list.add(qdo.dutyId.eq(query.getDutyId()));
        }
        /** 主目标负责人姓名 prd_org_employee.employee_name 精确 */
        if (!ObjectUtils.isEmpty(query.getDutyName())) {
            list.add(qdo.dutyName.eq(query.getDutyName()));
        }
        /** udc[crm:goal_type](人员目标、客户目标、产品目标) 精确 */
        if (!ObjectUtils.isEmpty(query.getGoalType())) {
            list.add(qdo.goalType.eq(query.getGoalType()));
        }
        /** udc[crm:target:exam_target](线索数A(个)、商机金额B(元)、客户数(个)、合同额(元)、拜访数(个))、回款额(元)精确 */
        if (!ObjectUtils.isEmpty(query.getExamTarget())) {
            list.add(qdo.examTarget.eq(query.getExamTarget()));
        }
        /** 拓展字段1 精确 */
        if (!ObjectUtils.isEmpty(query.getExt1())) {
            list.add(qdo.ext1.eq(query.getExt1()));
        }
        /** 拓展字段2 精确 */
        if (!ObjectUtils.isEmpty(query.getExt2())) {
            list.add(qdo.ext2.eq(query.getExt2()));
        }
        /** 拓展字段3 精确 */
        if (!ObjectUtils.isEmpty(query.getExt3())) {
            list.add(qdo.ext3.eq(query.getExt3()));
        }
        /** 拓展字段4 精确 */
        if (!ObjectUtils.isEmpty(query.getExt4())) {
            list.add(qdo.ext4.eq(query.getExt4()));
        }
        /** 拓展字段5 精确 */
        if (!ObjectUtils.isEmpty(query.getExt5())) {
            list.add(qdo.ext5.eq(query.getExt5()));
        }
        //需要权限
        if (query.getPermissionFlag()) {
            BooleanExpression jpaQueryOr = qdo.createUserId.eq(query.getLoginUserId());
            list.add(jpaQueryOr);
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public SaleGoalVO queryByKey(Long id) {
        JPAQuery<SaleGoalVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<SaleGoalVO> queryListDynamic(SaleGoalQuery query) {
        JPAQuery<SaleGoalVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<SaleGoalVO> queryPaging(SaleGoalQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<SaleGoalVO> jpaQuery = getJpaQueryWhere(query);
        List<SaleGoalVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<SaleGoalVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public SaleGoalDO save(SaleGoalDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<SaleGoalDO> saveAll(List<SaleGoalDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(SaleGoalPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 主目标ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 主目标名称
        if (payload.getGoalName() != null) {
            update.set(qdo.goalName, payload.getGoalName());
        }
        // 统计财年
        if (payload.getFiscalYear() != null) {
            update.set(qdo.fiscalYear, payload.getFiscalYear());
        }
        // 主目标负责人主键 prd_org_employee.user_id
        if (payload.getDutyId() != null) {
            update.set(qdo.dutyId, payload.getDutyId());
        }
        // 主目标负责人姓名 prd_org_employee.employee_name
        if (payload.getDutyName() != null) {
            update.set(qdo.dutyName, payload.getDutyName());
        }
        // udc[crm:goal_type](人员目标、客户目标、产品目标)
        if (payload.getGoalType() != null) {
            update.set(qdo.goalType, payload.getGoalType());
        }
        // 拓展字段1
        if (payload.getExt1() != null) {
            update.set(qdo.ext1, payload.getExt1());
        }
        // 拓展字段2
        if (payload.getExt2() != null) {
            update.set(qdo.ext2, payload.getExt2());
        }
        // 拓展字段3
        if (payload.getExt3() != null) {
            update.set(qdo.ext3, payload.getExt3());
        }
        // 拓展字段4
        if (payload.getExt4() != null) {
            update.set(qdo.ext4, payload.getExt4());
        }
        // 拓展字段5
        if (payload.getExt5() != null) {
            update.set(qdo.ext5, payload.getExt5());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 主目标ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 主目标名称
            if (nullFields.contains("goalName")) {
                update.setNull(qdo.goalName);
            }
            // 统计财年
            if (nullFields.contains("fiscalYear")) {
                update.setNull(qdo.fiscalYear);
            }
            // 主目标负责人主键 prd_org_employee.user_id
            if (nullFields.contains("dutyId")) {
                update.setNull(qdo.dutyId);
            }
            // 主目标负责人姓名 prd_org_employee.employee_name
            if (nullFields.contains("dutyName")) {
                update.setNull(qdo.dutyName);
            }
            // udc[crm:goal_type](人员目标、客户目标、产品目标)
            if (nullFields.contains("goalType")) {
                update.setNull(qdo.goalType);
            }
            // 拓展字段1
            if (nullFields.contains("ext1")) {
                update.setNull(qdo.ext1);
            }
            // 拓展字段2
            if (nullFields.contains("ext2")) {
                update.setNull(qdo.ext2);
            }
            // 拓展字段3
            if (nullFields.contains("ext3")) {
                update.setNull(qdo.ext3);
            }
            // 拓展字段4
            if (nullFields.contains("ext4")) {
                update.setNull(qdo.ext4);
            }
            // 拓展字段5
            if (nullFields.contains("ext5")) {
                update.setNull(qdo.ext5);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * 拜访任务统计
     *
     * @param userIds            用户id
     * @param examInformationVOS 考试信息vos
     * @param startTime          开始时间
     * @param endTime            结束时间
     * @return long
     */
    public long countVisitByExamInformation(Collection<Long> userIds, List<ExamInformationVO> examInformationVOS, LocalDateTime startTime, LocalDateTime endTime) {
        List<Predicate> list = new ArrayList<>();
        visitExamWhere(list, userIds, null, examInformationVOS);
        if (null != startTime) {
            list.add(qVisitTaskDO.modifyTime.goe(startTime));
        }
        if (null != endTime) {
            list.add(qVisitTaskDO.modifyTime.loe(endTime));
        }
        Predicate predicate = ExpressionUtils.allOf(list);
        long total = jpaQueryFactory
            .select(qVisitTaskDO.count())
            .from(qVisitTaskDO)
            .leftJoin(qCrmCustomerDO).on(qVisitTaskDO.customerId.eq(qCrmCustomerDO.id))
            .leftJoin(qdoAb).on(qdoAb.id.longValue().eq(qCrmCustomerDO.bookId.longValue()))
            .leftJoin(qdoCompany).on(qdoAb.id.longValue().eq(qdoCompany.bookId.longValue()))
            .where(predicate)
            .fetchOne();
        return total;
    }

    /**
     * 拜访任务统计实际完成值
     *
     * @param query 查询
     * @return {@link List}<{@link SaleTargetDualVO}>
     */
    public List<SaleTargetDualVO> countVisitTaskByExamInformation(SaleTargetStatisticalQuery query) {
        List<Predicate> list = new ArrayList<>();
        final Collection<Long> userIds = query.getUserIds();
        final Long userId = query.getUserId();
        // 根据考核范围 动态拼装条件
        final List<ExamInformationVO> examInformationVOList = query.getExamInformationVOList();
        visitExamWhere(list, userIds, userId, examInformationVOList);

        // 人员维度 动态条件
        if (null != query.getOrgId()) {
            list.add(qdoOrg.id.eq(query.getOrgId()));
        }
        if (null != userId) {
            list.add(qVisitTaskDO.visitMemberId.eq(userId));
        }
        if (null != query.getStartTime()) {
            list.add(qVisitTaskDO.modifyTime.goe(query.getStartTime()));
        }
        if (null != query.getEndTime()) {
            list.add(qVisitTaskDO.modifyTime.loe(query.getEndTime()));
        }

        // 客户维度
        if (null != query.getCustomerId()) {
            list.add(qVisitTaskDO.customerId.eq(query.getCustomerId()));
        }
        // 客户级别
        if (null != query.getCustomerGrade()) {
            list.add(qCrmCustomerDO.customerGrade.eq(query.getCustomerGrade()));
        }
        // 客户行业
        if (null != query.getCustIndustry()) {
            list.add(qdoCompany.companyIndustry.eq(query.getCustIndustry()));
        }

        if (null != query.getCustRegion()) {
            //list.add(qVisitTaskDO.customerId.eq(query.getCustomerId()));
        }

        // 固定条件
        list.add(qdoRef.deleteFlag.eq(0));
        list.add(qdoRef.isCopy.eq(0));
        list.add(qdoRef.isDefault.eq(0));
        list.add(qdoOrg.deleteFlag.eq(0));


        Predicate predicate = ExpressionUtils.allOf(list);
        StringTemplate searchTimePro = Expressions.stringTemplate("DATE_FORMAT({0},'%y年%m月')", qVisitTaskDO.modifyTime);;
        StringTemplate searchTime = Expressions.stringTemplate("DATE_FORMAT({0},'%m月')", qVisitTaskDO.modifyTime);;
        if (query.getSearchType().equals(SaleTargetStatisticalEnum.MONTH.getCode())) {
            searchTimePro = Expressions.stringTemplate("DATE_FORMAT({0},'%y年%m月')", qVisitTaskDO.modifyTime);
            searchTime = Expressions.stringTemplate("DATE_FORMAT({0},'%m月')", qVisitTaskDO.modifyTime);
        } else if (query.getSearchType().equals(SaleTargetStatisticalEnum.QUARTER.getCode())) {
            searchTime = Expressions.stringTemplate("CONCAT((FLOOR((DATE_FORMAT({0}, '%m') - 1) / 3) + 1),'')", qVisitTaskDO.modifyTime);
            searchTimePro = searchTime;
        }

        JPAQuery<SaleTargetDualVO> jpaQuery = jpaQueryFactory
            .select(Projections.bean(SaleTargetDualVO.class,
                searchTime.as("time"),
                searchTimePro.as("timePro"),
                //"actual".as("type"),
                qVisitTaskDO.count().as("valueLong")
            ))
            .from(qVisitTaskDO)
            .leftJoin(qdoRef).on(qdoRef.userId.eq(qVisitTaskDO.visitMemberId))
            .leftJoin(qdoOrg).on(qdoOrg.id.eq(qdoRef.orgId))
            .leftJoin(qCrmCustomerDO).on(qVisitTaskDO.customerId.eq(qCrmCustomerDO.id))
            .leftJoin(qdoAb).on(qdoAb.id.eq(qCrmCustomerDO.bookId))
            .leftJoin(qdoCompany).on(qdoAb.id.eq(qdoCompany.bookId))
            .where(predicate)
            .groupBy(searchTime);
        List<SaleTargetDualVO> resultList = jpaQuery.fetch();
        return resultList;

    }

    /**
     * 拜访任务
     *
     * @param list                  列表
     * @param userIds               用户id
     * @param userId                用户id
     * @param examInformationVOList 考试信息volist
     */
    private void visitExamWhere(List<Predicate> list, Collection<Long> userIds, Long userId, List<ExamInformationVO> examInformationVOList) {
        examInformationVOList.forEach(examInformationVO -> {
            final String fieldKey = examInformationVO.getFieldKey();
            final String searchScope = examInformationVO.getSearchScope();
            // 值
            final String searchCondition = examInformationVO.getSearchCondition();
            if (!ObjectUtils.isEmpty(fieldKey)
                && !ObjectUtils.isEmpty(searchCondition)) {
                List<String> searchConditionList = Arrays.asList(searchCondition.split(","));
                //目标负责人
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.DUTY.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        if (!CollectionUtils.isEmpty(userIds)) {
                            if (null != userId) {
                                list.add(qVisitTaskDO.visitMemberId.eq(userId));
                            } else {
                                list.add(qVisitTaskDO.visitMemberId.in(userIds));
                            }
                        }
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        //list.add(qVisitTaskDO.visitMemberId.eq(searchCondition));
                    }
                }
                //任务状态
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.STATUS.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qVisitTaskDO.status.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qVisitTaskDO.status.eq(searchCondition));
                    }
                }
                //客户区域
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.AREA.getCode())) {

                }
                //客户级别
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.LEVEL.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qCrmCustomerDO.customerGrade.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qCrmCustomerDO.customerGrade.eq(searchCondition));
                    }
                }
                //客户行业
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.INDUSTRY.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qdoCompany.companyIndustry.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qdoCompany.companyIndustry.eq(searchCondition));
                    }
                }
            }

        });
    }

    /**
     * 销售目标
     *
     * @param goalId 目标id
     * @param ext1   ext1
     * @param orgId  org id
     * @param userId 用户id
     * @return {@link List}<{@link SaleTargetVO}>
     */
    public List<SaleTargetVO> countSaleTarget(Long goalId, String ext1, Long orgId, Long userId,String custIndustry,String customerGrade) {
        List<Predicate> list = new ArrayList<>();
        // 动态条件
        if (null != goalId) {
            list.add(qSaleTargetDO.goalId.eq(goalId));
        }
        if (!ObjectUtils.isEmpty(ext1)) {
            list.add(qSaleTargetDO.ext1.eq(ext1));
        }
        if (null != orgId) {
            list.add(qdoOrg.id.eq(orgId));
        }
        if (null != userId) {
            list.add(qSaleTargetDO.dutyId.eq(userId));
        }
        if (!ObjectUtils.isEmpty(customerGrade)) {
            list.add(qCrmCustomerDO.customerGrade.eq(customerGrade));
        }
        if (!ObjectUtils.isEmpty(custIndustry)) {
            list.add(qdoCompany.companyIndustry.eq(custIndustry));
        }


        // 固定条件
        list.add(qdoRef.deleteFlag.eq(0));
        list.add(qdoRef.isCopy.eq(0));
        list.add(qdoRef.isDefault.eq(0));
        list.add(qdoOrg.deleteFlag.eq(0));


        Predicate predicate = ExpressionUtils.allOf(list);
        JPAQuery<SaleTargetVO> jpaQuery = jpaQueryFactory
            .select(Projections.bean(SaleTargetVO.class,
                qSaleTargetDO.id,
                //qSaleTargetDO.remark,
                //qSaleTargetDO.createUserId,
                //qSaleTargetDO.creator,
                //qSaleTargetDO.createTime,
                //qSaleTargetDO.modifyUserId,
                //qSaleTargetDO.updater,
                //qSaleTargetDO.modifyTime,
                // 主表主键 crm_sale_goal.goal_id
                qSaleTargetDO.goalId,
                // 上级目标ID
                qSaleTargetDO.parentId,
                // 目标名称
                qSaleTargetDO.goalName,
                // 统计财年 crm_sale_goal.fiscal_year(冗余)
                qSaleTargetDO.fiscalYear,
                // 第一季度目标值
                qSaleTargetDO.firstQuarter,
                // 第二季度目标值
                qSaleTargetDO.secondQuarter,
                // 第三季度目标值
                qSaleTargetDO.thirdQuarter,
                // 第四季度目标值
                qSaleTargetDO.forthQuarter,
                // 一月目标值
                qSaleTargetDO.january,
                // 二月目标值
                qSaleTargetDO.february,
                // 三月目标值
                qSaleTargetDO.march,
                // 四月目标值
                qSaleTargetDO.april,
                // 五月目标值
                qSaleTargetDO.may,
                // 六月目标值
                qSaleTargetDO.june,
                // 七月目标值
                qSaleTargetDO.july,
                // 八月目标值
                qSaleTargetDO.august,
                // 九月目标值
                qSaleTargetDO.september,
                // 十月目标值
                qSaleTargetDO.october,
                // 十一月目标值
                qSaleTargetDO.november,
                // 十二月目标值
                qSaleTargetDO.december,
                // 目标总值
                qSaleTargetDO.targetCount,
                // udc[crm:goal_type](人员目标、客户目标、产品目标)
                qSaleTargetDO.goalType,
                // 目标负责人主键 prd_org_employee.user_id
                qSaleTargetDO.dutyId,
                // 目标负责人姓名  prd_org_employee.employee_name
                qSaleTargetDO.dutyName,
                // 产品主键 crm_product_spu.id
                qSaleTargetDO.skuId,
                // 产品名称 crm_product_spu.spu_name
                qSaleTargetDO.skuName,
                // 客户主键 crm_customer.id
                qSaleTargetDO.customerId,
                // 客户名称  crm_custome.customer_name
                qSaleTargetDO.customerName,
                // 目标类型主键
                qSaleTargetDO.objId,
                // 目标类型名称
                qSaleTargetDO.objName,
                // 拓展字段1
                qSaleTargetDO.ext1,
                // 拓展字段2
                qSaleTargetDO.ext2,
                // 拓展字段3
                qSaleTargetDO.ext3,
                // 拓展字段4
                qSaleTargetDO.ext4,
                // 拓展字段5
                qSaleTargetDO.ext5
            ))
            .from(qSaleTargetDO)
            .leftJoin(qdoRef).on(qdoRef.userId.eq(qSaleTargetDO.dutyId))
                .leftJoin(qdoOrg).on(qdoOrg.id.eq(qdoRef.orgId))
                .leftJoin(qCrmCustomerDO).on(qSaleTargetDO.customerId.eq(qCrmCustomerDO.id))
                .leftJoin(qdoAb).on(qdoAb.id.eq(qCrmCustomerDO.bookId))
                .leftJoin(qdoCompany).on(qdoAb.id.eq(qdoCompany.bookId))
                .where(predicate);
        final List<SaleTargetVO> fetch = jpaQuery.fetch();
        return fetch;
    }

    /**
     * 线索数据统计实际完成值
     *
     * @param query 查询
     * @return {@link List}<{@link SaleTargetDualVO}>
     */
    public List<SaleTargetDualVO> countLeadsByExamInformation(SaleTargetStatisticalQuery query) {
        List<Predicate> list = new ArrayList<>();

        // 根据考核范围 动态拼装条件
        final List<ExamInformationVO> examInformationVOList = query.getExamInformationVOList();
        leadsExamWhere(query.getUserIds(), query.getUserId(), list, examInformationVOList);

        // 人员维度 动态条件
        if (null != query.getOrgId()) {
            list.add(qdoOrg.id.eq(query.getOrgId()));
        }
        if (null != query.getUserId()) {
            list.add(qdoLeads.sourceUserId.eq(query.getUserId()));
        }
        if (null != query.getStartTime()) {
            list.add(qdoLeads.modifyTime.goe(query.getStartTime()));
        }
        if (null != query.getEndTime()) {
            list.add(qdoLeads.modifyTime.loe(query.getEndTime()));
        }

        // 固定条件
        list.add(qdoRef.deleteFlag.eq(0));
        list.add(qdoRef.isCopy.eq(0));
        list.add(qdoRef.isDefault.eq(0));
        list.add(qdoOrg.deleteFlag.eq(0));

        Predicate predicate = ExpressionUtils.allOf(list);
        StringTemplate searchTimePro = Expressions.stringTemplate("DATE_FORMAT({0},'%y年%m月')", qdoLeads.modifyTime);;
        StringTemplate searchTime = Expressions.stringTemplate("DATE_FORMAT({0},'%m月')", qdoLeads.modifyTime);;
        if (query.getSearchType().equals(SaleTargetStatisticalEnum.MONTH.getCode())) {
            searchTimePro = Expressions.stringTemplate("DATE_FORMAT({0},'%y年%m月')", qdoLeads.modifyTime);
            searchTime = Expressions.stringTemplate("DATE_FORMAT({0},'%m月')", qdoLeads.modifyTime);
        } else if (query.getSearchType().equals(SaleTargetStatisticalEnum.QUARTER.getCode())) {
            searchTime = Expressions.stringTemplate("CONCAT((FLOOR((DATE_FORMAT({0}, '%m') - 1) / 3) + 1),'')", qdoLeads.modifyTime);
            searchTimePro = searchTime;
        }
        JPAQuery<SaleTargetDualVO> jpaQuery = jpaQueryFactory
            .select(Projections.bean(SaleTargetDualVO.class,
                searchTime.as("time"),
                searchTimePro.as("timePro"),
                //"actual".as("type"),
                qdoLeads.count().as("valueLong")
            ))
            .from(qdoLeads)
            .leftJoin(qdoRef).on(qdoRef.userId.eq(qdoLeads.sourceUserId))
            .leftJoin(qdoOrg).on(qdoOrg.id.eq(qdoRef.orgId))
            .leftJoin(qCrmCustomerDO).on(qdoLeads.customer.id.eq(qCrmCustomerDO.id))
            .leftJoin(qdoAb).on(qdoAb.id.eq(qCrmCustomerDO.bookId))
            .leftJoin(qdoCompany).on(qdoAb.id.eq(qdoCompany.bookId))
            .where(predicate)
            .groupBy(searchTime);
        List<SaleTargetDualVO> resultList = jpaQuery.fetch();
        return resultList;
    }

    /**
     * 线索 实际完成额
     *
     * @param userIds            用户id
     * @param examInformationVOS 考试信息vos
     * @param startTime          开始时间
     * @param endTime            结束时间
     * @return long
     */
    public long countLeadsByExamInformationForPaging(Set<Long> userIds, List<ExamInformationVO> examInformationVOS, LocalDateTime startTime, LocalDateTime endTime) {
        List<Predicate> list = new ArrayList<>();
        // 根据考核范围 动态拼装条件
        leadsExamWhere(userIds, null, list, examInformationVOS);
        // 固定条件
        list.add(qdoRef.deleteFlag.eq(0));
        list.add(qdoRef.isCopy.eq(0));
        list.add(qdoRef.isDefault.eq(0));
        list.add(qdoOrg.deleteFlag.eq(0));
        if (null != startTime) {
            list.add(qdoLeads.modifyTime.goe(startTime));
        }
        if (null != endTime) {
            list.add(qdoLeads.modifyTime.loe(endTime));
        }
        Predicate predicate = ExpressionUtils.allOf(list);
        final Long count = jpaQueryFactory
            .select(qdoLeads.count())
            .from(qdoLeads)
            .leftJoin(qdoRef).on(qdoRef.userId.eq(qdoLeads.sourceUserId))
            .leftJoin(qdoOrg).on(qdoOrg.id.eq(qdoRef.orgId))
            .leftJoin(qCrmCustomerDO).on(qdoLeads.customer.id.eq(qCrmCustomerDO.id))
            .leftJoin(qdoAb).on(qdoAb.id.eq(qCrmCustomerDO.bookId))
            .leftJoin(qdoCompany).on(qdoAb.id.eq(qdoCompany.bookId))
            .where(predicate)
            .fetchOne();
        return count;

    }

    /**
     * 线索
     *
     * @param userIds               用户id
     * @param userId                用户id
     * @param list                  列表
     * @param examInformationVOList 考试信息volist
     */
    private void leadsExamWhere(Collection<Long> userIds,Long userId, List<Predicate> list, List<ExamInformationVO> examInformationVOList) {
        examInformationVOList.forEach(examInformationVO -> {
            final String fieldKey = examInformationVO.getFieldKey();
            final String searchScope = examInformationVO.getSearchScope();
            // 值
            final String searchCondition = examInformationVO.getSearchCondition();
            if (!ObjectUtils.isEmpty(fieldKey)
                && !ObjectUtils.isEmpty(searchCondition)) {
                List<String> searchConditionList = Arrays.asList(searchCondition.split(","));
                //目标负责人
                if (fieldKey.equals(SaleTargetUserLeadsFieldEnum.SOURCE_USER_ID.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        if (!CollectionUtils.isEmpty(userIds)) {
                            if (null != userId) {
                                list.add(qdoLeads.sourceUserId.eq(userId));
                            } else {
                                list.add(qdoLeads.sourceUserId.in(userIds));
                            }
                        }
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qdoLeads.sourceUserId.eq(userId));
                    }
                }
                // 线索状态
                if (fieldKey.equals(SaleTargetUserLeadsFieldEnum.LEADS_STATUS.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qdoLeads.leadsStatus.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qdoLeads.leadsStatus.eq(searchCondition));
                    }
                }
                // 线索阶段
                if (fieldKey.equals(SaleTargetUserLeadsFieldEnum.LEADS_STAGE.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qdoLeads.leadsStage.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qdoLeads.leadsStage.eq(searchCondition));
                    }
                }
                // 跟进级别
                if (fieldKey.equals(SaleTargetUserLeadsFieldEnum.CUSTOMER_GRADE.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qCrmCustomerDO.customerGrade.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qCrmCustomerDO.customerGrade.eq(searchCondition));
                    }
                }
                //客户行业
                if (fieldKey.equals(SaleTargetUserLeadsFieldEnum.CUSTOMER_INDUSTRY.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qdoCompany.companyIndustry.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qdoCompany.companyIndustry.eq(searchCondition));
                    }
                }
            }

        });
    }

    /**
     * 商机统计
     *
     * @param userIds            用户id
     * @param examInformationVOS 考试信息vos
     * @param startTime          开始时间
     * @param endTime            结束时间
     * @return {@link BigDecimal}
     */
    public BigDecimal countOppoByExamInformationForPaging(Set<Long> userIds, List<ExamInformationVO> examInformationVOS, LocalDateTime startTime, LocalDateTime endTime) {
        List<Predicate> list = new ArrayList<>();
        oppoExamWhere(list, examInformationVOS, null, userIds);
        // 固定条件
        list.add(qdoRef.deleteFlag.eq(0));
        list.add(qPrjProjectDO.deleteFlag.eq(0));
        list.add(qdoRef.isCopy.eq(0));
        list.add(qdoRef.isDefault.eq(0));
        list.add(qdoOrg.deleteFlag.eq(0));
        if (null != startTime) {
            list.add(qCrmOpportunityDO.modifyTime.goe(startTime));
        }
        if (null != endTime) {
            list.add(qCrmOpportunityDO.modifyTime.loe(endTime));
        }
        Predicate predicate = ExpressionUtils.allOf(list);
        return jpaQueryFactory
            .select(
                qCrmOpportunityDO.forecastAmount.sum()
            )
            .from(qCrmOpportunityDO)
            .leftJoin(qPrjProjectDO).on(qPrjProjectDO.id.eq(qCrmOpportunityDO.projectId))
            .leftJoin(qdoRef).on(qdoRef.userId.eq(qPrjProjectDO.manageUserId))
            .leftJoin(qdoOrg).on(qdoOrg.id.eq(qdoRef.orgId))
            .where(predicate)
            .fetchOne();
    }

    /**
     * 商机金额 统计实际完成值
     *
     * @param query 查询
     * @return {@link List}<{@link SaleTargetDualVO}>
     */
    public List<SaleTargetDualVO> countOppoByExamInformation(SaleTargetStatisticalQuery query) {
        List<Predicate> list = new ArrayList<>();
        // 根据考核范围 动态拼装条件
        final List<ExamInformationVO> examInformationVOList = query.getExamInformationVOList();
        final Long userId = query.getUserId();
        final Collection<Long> userIds = query.getUserIds();
        oppoExamWhere(list, examInformationVOList, userId, userIds);

        // 人员维度 动态条件
        if (null != query.getOrgId()) {
            list.add(qdoOrg.id.eq(query.getOrgId()));
        }
        if (null != userId) {
            list.add(qPrjProjectDO.manageUserId.eq(userId));
        }
        if (null != query.getStartTime()) {
            list.add(qCrmOpportunityDO.modifyTime.goe(query.getStartTime()));
        }
        if (null != query.getEndTime()) {
            list.add(qCrmOpportunityDO.modifyTime.loe(query.getEndTime()));
        }

        // 固定条件
        list.add(qdoRef.deleteFlag.eq(0));
        list.add(qPrjProjectDO.deleteFlag.eq(0));
        list.add(qdoRef.isCopy.eq(0));
        list.add(qdoRef.isDefault.eq(0));
        list.add(qdoOrg.deleteFlag.eq(0));

        Predicate predicate = ExpressionUtils.allOf(list);

        StringTemplate searchTimePro = Expressions.stringTemplate("DATE_FORMAT({0},'%y年%m月')", qCrmOpportunityDO.modifyTime);;
        StringTemplate searchTime = Expressions.stringTemplate("DATE_FORMAT({0},'%m月')", qCrmOpportunityDO.modifyTime);;
        if (query.getSearchType().equals(SaleTargetStatisticalEnum.MONTH.getCode())) {
            searchTimePro = Expressions.stringTemplate("DATE_FORMAT({0},'%y年%m月')", qCrmOpportunityDO.modifyTime);
            searchTime = Expressions.stringTemplate("DATE_FORMAT({0},'%m月')", qCrmOpportunityDO.modifyTime);
        } else if (query.getSearchType().equals(SaleTargetStatisticalEnum.QUARTER.getCode())) {
            searchTime = Expressions.stringTemplate("CONCAT((FLOOR((DATE_FORMAT({0}, '%m') - 1) / 3) + 1),'')", qCrmOpportunityDO.modifyTime);
            searchTimePro = searchTime;
        }
        JPAQuery<SaleTargetDualVO> jpaQuery = jpaQueryFactory
            .select(Projections.bean(SaleTargetDualVO.class,
                searchTime.as("time"),
                searchTimePro.as("timePro"),
                //"actual".as("type"),
                qCrmOpportunityDO.forecastAmount.sum().as("value")
            ))
            .from(qCrmOpportunityDO)
            .leftJoin(qPrjProjectDO).on(qPrjProjectDO.id.eq(qCrmOpportunityDO.projectId))
            .leftJoin(qdoRef).on(qdoRef.userId.eq(qPrjProjectDO.manageUserId))
            .leftJoin(qdoOrg).on(qdoOrg.id.eq(qdoRef.orgId))
            .where(predicate)
            .groupBy(searchTime);
        List<SaleTargetDualVO> resultList = jpaQuery.fetch();
        return resultList;
    }

    /**
     * 商机条件封装
     *
     * @param list                  列表
     * @param examInformationVOList 考试信息volist
     * @param userId                用户id
     * @param userIds               用户id
     */
    private void oppoExamWhere(List<Predicate> list, List<ExamInformationVO> examInformationVOList, Long userId, Collection<Long> userIds) {
        examInformationVOList.forEach(examInformationVO -> {
            final String fieldKey = examInformationVO.getFieldKey();
            final String searchScope = examInformationVO.getSearchScope();
            // 值
            final String searchCondition = examInformationVO.getSearchCondition();
            if (!ObjectUtils.isEmpty(fieldKey)
                && !ObjectUtils.isEmpty(searchCondition)) {
                List<String> searchConditionList = Arrays.asList(searchCondition.split(","));
                // 签单负责人
                if (fieldKey.equals(SaleTargetUserOppoFieldEnum.MANAGE_USER_ID.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        if (!CollectionUtils.isEmpty(userIds)) {
                            if (null != userId) {
                                list.add(qPrjProjectDO.manageUserId.eq(userId));
                            } else {
                                list.add(qPrjProjectDO.manageUserId.in(userIds));
                            }
                        }
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qPrjProjectDO.manageUserId.eq(userId));
                    }
                }
                // 商机状态
                if (fieldKey.equals(SaleTargetUserOppoFieldEnum.PROJECT_STATUS.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qPrjProjectDO.projectStatus.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qPrjProjectDO.projectStatus.eq(searchCondition));
                    }
                }
                // 商机级别
                if (fieldKey.equals(SaleTargetUserOppoFieldEnum.OPPO_LEVEL.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qCrmOpportunityDO.oppoLevel.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qCrmOpportunityDO.oppoLevel.eq(searchCondition));
                    }
                }
                // 销售阶段
                if (fieldKey.equals(SaleTargetUserOppoFieldEnum.SALE_PHASE.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qCrmOpportunityDO.salePhase.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qCrmOpportunityDO.salePhase.eq(searchCondition));
                    }
                }
                // 成单概率
                if (fieldKey.equals(SaleTargetUserOppoFieldEnum.PROBABILITY.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qCrmOpportunityDO.probability.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qCrmOpportunityDO.probability.eq(searchCondition));
                    }
                }
            }

        });
    }

    /**
     * 客户数量统计 实际完成值
     *
     * @param query 查询
     * @return {@link List}<{@link SaleTargetDualVO}>
     */
    public List<SaleTargetDualVO> countCustomerByExamInformation(SaleTargetStatisticalQuery query) {
        List<Predicate> list = new ArrayList<>();
        final Collection<Long> userIds = query.getUserIds();
        final Long userId = query.getUserId();
        final List<ExamInformationVO> examInformationVOList = query.getExamInformationVOList();
        // 根据考核范围 动态拼装条件
        customerExamWhere(list, userIds, userId, examInformationVOList);

        // 人员维度 动态条件
        if (null != query.getOrgId()) {
            list.add(qdoOrg.id.eq(query.getOrgId()));
        }
        if (null != userId) {
            list.add(qCrmCustomerDO.businessUserId.eq(userId));
        }
        if (null != query.getStartTime()) {
            list.add(qCrmCustomerDO.modifyTime.goe(query.getStartTime()));
        }
        if (null != query.getEndTime()) {
            list.add(qCrmCustomerDO.modifyTime.loe(query.getEndTime()));
        }

        // 固定条件
        list.add(qdoRef.deleteFlag.eq(0));
        list.add(qdoRef.isCopy.eq(0));
        list.add(qdoRef.isDefault.eq(0));
        list.add(qdoOrg.deleteFlag.eq(0));
        list.add(qdoAb.deleteFlag.eq(0));
        list.add(qdoCompany.deleteFlag.eq(0));
        // 商务负责人不能为空
        list.add(qCrmCustomerDO.businessUserId.isNotNull());

        Predicate predicate = ExpressionUtils.allOf(list);
        StringTemplate searchTimePro = Expressions.stringTemplate("DATE_FORMAT({0},'%y年%m月')", qCrmCustomerDO.modifyTime);;
        StringTemplate searchTime = Expressions.stringTemplate("DATE_FORMAT({0},'%m月')", qCrmCustomerDO.modifyTime);;
        if (query.getSearchType().equals(SaleTargetStatisticalEnum.MONTH.getCode())) {
            searchTimePro = Expressions.stringTemplate("DATE_FORMAT({0},'%y年%m月')", qCrmCustomerDO.modifyTime);
            searchTime = Expressions.stringTemplate("DATE_FORMAT({0},'%m月')", qCrmCustomerDO.modifyTime);
        } else if (query.getSearchType().equals(SaleTargetStatisticalEnum.QUARTER.getCode())) {
            searchTime = Expressions.stringTemplate("CONCAT((FLOOR((DATE_FORMAT({0}, '%m') - 1) / 3) + 1),'')", qCrmCustomerDO.modifyTime);
            searchTimePro = searchTime;
        }
        JPAQuery<SaleTargetDualVO> jpaQuery = jpaQueryFactory
            .select(Projections.bean(SaleTargetDualVO.class,
                searchTime.as("time"),
                searchTimePro.as("timePro"),
                //"actual".as("type"),
                qCrmCustomerDO.count().as("valueLong")
            ))
            .from(qCrmCustomerDO)
            .leftJoin(qdoRef).on(qdoRef.userId.eq(qCrmCustomerDO.businessUserId))
            .leftJoin(qdoOrg).on(qdoOrg.id.eq(qdoRef.orgId))
            .leftJoin(qdoAb).on(qdoAb.id.eq(qCrmCustomerDO.bookId))
            .leftJoin(qdoCompany).on(qdoAb.id.eq(qdoCompany.bookId))
            .where(predicate)
            .groupBy(searchTime);
        List<SaleTargetDualVO> resultList = jpaQuery.fetch();
        return resultList;
    }

    /**
     * 客户条件封装
     *
     * @param list                  列表
     * @param userIds               用户id
     * @param userId                用户id
     * @param examInformationVOList 考试信息volist
     */
    private void customerExamWhere(List<Predicate> list, Collection<Long> userIds, Long userId, List<ExamInformationVO> examInformationVOList) {
        examInformationVOList.forEach(examInformationVO -> {
            final String fieldKey = examInformationVO.getFieldKey();
            final String searchScope = examInformationVO.getSearchScope();
            // 值
            final String searchCondition = examInformationVO.getSearchCondition();
            if (!ObjectUtils.isEmpty(fieldKey)
                && !ObjectUtils.isEmpty(searchCondition)) {
                List<String> searchConditionList = Arrays.asList(searchCondition.split(","));
                // 商务负责人
                if (fieldKey.equals(SaleTargetUserOppoFieldEnum.MANAGE_USER_ID.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        if (!CollectionUtils.isEmpty(userIds)) {
                            if (null != userId) {
                                list.add(qCrmCustomerDO.businessUserId.eq(userId));
                            } else {
                                list.add(qCrmCustomerDO.businessUserId.in(userIds));
                            }
                        }
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qCrmCustomerDO.businessUserId.eq(userId));
                    }
                }
                // 客户状态
                if (fieldKey.equals(SaleTargetUserCustomerFieldEnum.CUSTOMER_STATUS.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qCrmCustomerDO.customerStatus.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qCrmCustomerDO.customerStatus.eq(searchCondition));
                    }
                }
                //客户区域
                if (fieldKey.equals(SaleTargetUserCustomerFieldEnum.AREA.getCode())) {

                }
                //客户级别
                if (fieldKey.equals(SaleTargetUserCustomerFieldEnum.LEVEL.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qCrmCustomerDO.customerGrade.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qCrmCustomerDO.customerGrade.eq(searchCondition));
                    }
                }
                //客户行业
                if (fieldKey.equals(SaleTargetUserCustomerFieldEnum.INDUSTRY.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qdoCompany.companyIndustry.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qdoCompany.companyIndustry.eq(searchCondition));
                    }
                }
            }

        });
    }

    /**
     * 客户人数统计
     *
     * @param userIds            用户id
     * @param examInformationVOS 规格
     * @param startTime          开始时间
     * @param endTime            结束时间
     * @return long
     */
    public long countCustomerByExamInformationForPaging(Set<Long> userIds, List<ExamInformationVO> examInformationVOS, LocalDateTime startTime, LocalDateTime endTime) {
        List<Predicate> list = new ArrayList<>();
        // 根据考核范围 动态拼装条件
        customerExamWhere(list, userIds, null, examInformationVOS);
        if (null != startTime) {
            list.add(qCrmCustomerDO.modifyTime.goe(startTime));
        }
        if (null != endTime) {
            list.add(qCrmCustomerDO.modifyTime.loe(endTime));
        }
        // 固定条件
        list.add(qdoRef.deleteFlag.eq(0));
        list.add(qdoRef.isCopy.eq(0));
        list.add(qdoRef.isDefault.eq(0));
        list.add(qdoOrg.deleteFlag.eq(0));
        list.add(qdoAb.deleteFlag.eq(0));
        list.add(qdoCompany.deleteFlag.eq(0));
        // 商务负责人不能为空
        list.add(qCrmCustomerDO.businessUserId.isNotNull());
        Predicate predicate = ExpressionUtils.allOf(list);
        return jpaQueryFactory
            .select(qCrmCustomerDO.count())
            .from(qCrmCustomerDO)
            .leftJoin(qdoRef).on(qdoRef.userId.eq(qCrmCustomerDO.businessUserId))
            .leftJoin(qdoOrg).on(qdoOrg.id.eq(qdoRef.orgId))
            .leftJoin(qdoAb).on(qdoAb.id.eq(qCrmCustomerDO.bookId))
            .leftJoin(qdoCompany).on(qdoAb.id.eq(qdoCompany.bookId))
            .where(predicate)
            .fetchOne();
    }
}

