package com.elitesland.tw.tw5crm.server.sale.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.ab.entity.QPrdAbDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmCustomerDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmLeadsDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmOpportunityDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgCompanyDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeRefDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.prj.entity.QPrjProjectDO;
import com.elitesland.tw.tw5crm.api.sale.payload.SaleTargetPayload;
import com.elitesland.tw.tw5crm.api.sale.query.SaleTargetCustomerQuery;
import com.elitesland.tw.tw5crm.api.sale.query.SaleTargetQuery;
import com.elitesland.tw.tw5crm.api.sale.query.SaleTargetStatisticalQuery;
import com.elitesland.tw.tw5crm.api.sale.vo.ExamInformationVO;
import com.elitesland.tw.tw5crm.api.sale.vo.SaleTargetCountResultVO;
import com.elitesland.tw.tw5crm.api.sale.vo.SaleTargetCountVO;
import com.elitesland.tw.tw5crm.api.sale.vo.SaleTargetVO;
import com.elitesland.tw.tw5crm.server.common.constants.*;
import com.elitesland.tw.tw5crm.server.sale.entity.QSaleGoalDO;
import com.elitesland.tw.tw5crm.server.sale.entity.QSaleTargetDO;
import com.elitesland.tw.tw5crm.server.sale.entity.SaleTargetDO;
import com.elitesland.tw.tw5crm.server.sale.repo.SaleTargetRepo;
import com.elitesland.tw.tw5crm.server.visit.entity.QVisitTaskDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

/**
 * sale
 *
 * @author kola
 * @date 2023-04-03
 */
@Repository
@RequiredArgsConstructor
public class SaleTargetDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final SaleTargetRepo repo;
    private final QSaleTargetDO qdo = QSaleTargetDO.saleTargetDO;
    private final QSaleTargetDO qSaleTargetDO=new QSaleTargetDO("qSaleTargetDO");
    private final QSaleGoalDO qSaleGoalDO=QSaleGoalDO.saleGoalDO;
    private final QVisitTaskDO qVisitTaskDO = QVisitTaskDO.visitTaskDO;
    private final QCrmCustomerDO qCrmCustomerDO = QCrmCustomerDO.crmCustomerDO;
    private final QPrdAbDO qdoAb = QPrdAbDO.prdAbDO;
    private final QPrdOrgCompanyDO qdoCompany = QPrdOrgCompanyDO.prdOrgCompanyDO;
    private final QPrdOrgEmployeeRefDO qPrdOrgEmployeeRefDO=QPrdOrgEmployeeRefDO.prdOrgEmployeeRefDO;

    private final QPrdOrgOrganizationDO qPrdOrgOrganizationDO=QPrdOrgOrganizationDO.prdOrgOrganizationDO;
    //线索
    private final QCrmLeadsDO qCrmLeadsDO=QCrmLeadsDO.crmLeadsDO;
    private final QPrdOrgEmployeeDO qPrdOrgEmployeeDO=QPrdOrgEmployeeDO.prdOrgEmployeeDO;
    private final QPrjProjectDO qPrjProjectDO = QPrjProjectDO.prjProjectDO;
    private final QCrmOpportunityDO qCrmOpportunityDO = QCrmOpportunityDO.crmOpportunityDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<SaleTargetVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(SaleTargetVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                //主目标ID
                qSaleGoalDO.id,
                //主目标名称
                qSaleGoalDO.goalName,
                //主目标类型
                qSaleGoalDO.goalType,
                // 主表主键 crm_sale_goal.goal_id
                qdo.goalId,
                // 上级目标ID
                qdo.parentId,
                // 目标名称
                qdo.goalName,
                // 统计财年 crm_sale_goal.fiscal_year(冗余)
                qdo.fiscalYear,
                // 第一季度目标值
                qdo.firstQuarter,
                // 第二季度目标值
                qdo.secondQuarter,
                // 第三季度目标值
                qdo.thirdQuarter,
                // 第四季度目标值
                qdo.forthQuarter,
                // 一月目标值
                qdo.january,
                // 二月目标值
                qdo.february,
                // 三月目标值
                qdo.march,
                // 四月目标值
                qdo.april,
                // 五月目标值
                qdo.may,
                // 六月目标值
                qdo.june,
                // 七月目标值
                qdo.july,
                // 八月目标值
                qdo.august,
                // 九月目标值
                qdo.september,
                // 十月目标值
                qdo.october,
                // 十一月目标值
                qdo.november,
                // 十二月目标值
                qdo.december,
                // 目标总值
                qdo.targetCount,
                // udc[crm:goal_type](人员目标、客户目标、产品目标)
                qdo.goalType,
                // 目标负责人主键 prd_org_employee.user_id
                qdo.dutyId,
                // 目标负责人姓名  prd_org_employee.employee_name
                qdo.dutyName,
                // 产品主键 crm_product_spu.id
                qdo.skuId,
                // 产品名称 crm_product_spu.spu_name
                qdo.skuName,
                //spuID
                qdo.spuId,
                //spu名称
                qdo.spuName,
                // 客户主键 crm_customer.id
                qdo.customerId,
                // 客户名称  crm_custome.customer_name
                qdo.customerName,
                // 目标类型主键
                qdo.objId,
                // 目标类型名称
                qdo.objName,
                // 拓展字段1
                qdo.ext1,
                // 拓展字段2
                qdo.ext2,
                // 拓展字段3
                qdo.ext3,
                // 拓展字段4
                qdo.ext4,
                // 拓展字段5
                qdo.ext5
        )).from(qdo).leftJoin(qSaleTargetDO)
                .on(qdo.parentId.eq(qSaleTargetDO.parentId))
                .leftJoin(qSaleGoalDO)
                .on(qdo.goalId.eq(qSaleGoalDO.id));
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<SaleTargetVO> getJpaQueryWhere(SaleTargetQuery query) {
        JPAQuery<SaleTargetVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
            }



    public List<SaleTargetVO> queryByTargetIds(List<Long> targetIds) {
        JPAQuery<SaleTargetVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.in(targetIds));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(SaleTargetQuery query) {
        long total = jpaQueryFactory
            .select(qdo.count())
            .from(qdo)
            .where(where(query))
            .fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(SaleTargetQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 主表主键 crm_sale_goal.goal_id 精确 */
        if (!ObjectUtils.isEmpty(query.getGoalId())) {
            list.add(qdo.goalId.eq(query.getGoalId()));
        }
        /** 上级目标ID 精确 */
        if (!ObjectUtils.isEmpty(query.getParentId())) {
            list.add(qdo.parentId.eq(query.getParentId()));
        }
        /** 目标名称 模糊 */
        if (!ObjectUtils.isEmpty(query.getGoalName())) {
             list.add(qdo.goalName.like(SqlUtil.toSqlLikeString(query.getGoalName())));
        }
        /** 统计财年 crm_sale_goal.fiscal_year(冗余) 精确 */
        if (!ObjectUtils.isEmpty(query.getFiscalYear())) {
            list.add(qdo.fiscalYear.eq(query.getFiscalYear()));
        }
        /** 第一季度目标值 精确 */
        if (!ObjectUtils.isEmpty(query.getFirstQuarter())) {
            list.add(qdo.firstQuarter.eq(query.getFirstQuarter()));
        }
        /** 第二季度目标值 精确 */
        if (!ObjectUtils.isEmpty(query.getSecondQuarter())) {
            list.add(qdo.secondQuarter.eq(query.getSecondQuarter()));
        }
        /** 第三季度目标值 精确 */
        if (!ObjectUtils.isEmpty(query.getThirdQuarter())) {
            list.add(qdo.thirdQuarter.eq(query.getThirdQuarter()));
        }
        /** 第四季度目标值 精确 */
        if (!ObjectUtils.isEmpty(query.getForthQuarter())) {
            list.add(qdo.forthQuarter.eq(query.getForthQuarter()));
        }
        /** 一月目标值 精确 */
        if (!ObjectUtils.isEmpty(query.getJanuary())) {
            list.add(qdo.january.eq(query.getJanuary()));
        }
        /** 二月目标值 精确 */
        if (!ObjectUtils.isEmpty(query.getFebruary())) {
            list.add(qdo.february.eq(query.getFebruary()));
        }
        /** 三月目标值 精确 */
        if (!ObjectUtils.isEmpty(query.getMarch())) {
            list.add(qdo.march.eq(query.getMarch()));
        }
        /** 四月目标值 精确 */
        if (!ObjectUtils.isEmpty(query.getApril())) {
            list.add(qdo.april.eq(query.getApril()));
        }
        /** 五月目标值 精确 */
        if (!ObjectUtils.isEmpty(query.getMay())) {
            list.add(qdo.may.eq(query.getMay()));
        }
        /** 六月目标值 精确 */
        if (!ObjectUtils.isEmpty(query.getJune())) {
            list.add(qdo.june.eq(query.getJune()));
        }
        /** 七月目标值 精确 */
        if (!ObjectUtils.isEmpty(query.getJuly())) {
            list.add(qdo.july.eq(query.getJuly()));
        }
        /** 八月目标值 精确 */
        if (!ObjectUtils.isEmpty(query.getAugust())) {
            list.add(qdo.august.eq(query.getAugust()));
        }
        /** 九月目标值 精确 */
        if (!ObjectUtils.isEmpty(query.getSeptember())) {
            list.add(qdo.september.eq(query.getSeptember()));
        }
        /** 十月目标值 精确 */
        if (!ObjectUtils.isEmpty(query.getOctober())) {
            list.add(qdo.october.eq(query.getOctober()));
        }
        /** 十一月目标值 精确 */
        if (!ObjectUtils.isEmpty(query.getNovember())) {
            list.add(qdo.november.eq(query.getNovember()));
        }
        /** 十二月目标值 精确 */
        if (!ObjectUtils.isEmpty(query.getDecember())) {
            list.add(qdo.december.eq(query.getDecember()));
        }
        /** 目标总值 精确 */
        if (!ObjectUtils.isEmpty(query.getTargetCount())) {
            list.add(qdo.targetCount.eq(query.getTargetCount()));
        }
        /** udc[crm:goal_type](人员目标、客户目标、产品目标) 精确 */
        if (!ObjectUtils.isEmpty(query.getGoalType())) {
            list.add(qdo.goalType.eq(query.getGoalType()));
        }
        /** 目标负责人主键 prd_org_employee.user_id 精确 */
        if (!ObjectUtils.isEmpty(query.getDutyId())) {
            list.add(qdo.dutyId.eq(query.getDutyId()));
        }
        /** 目标负责人姓名  prd_org_employee.employee_name 精确 */
        if (!ObjectUtils.isEmpty(query.getDutyName())) {
            list.add(qdo.dutyName.eq(query.getDutyName()));
        }
        /** 产品主键 crm_product_spu.id 精确 */
        if (!ObjectUtils.isEmpty(query.getSkuId())) {
            list.add(qdo.skuId.eq(query.getSkuId()));
        }
        /** 产品名称 crm_product_spu.spu_name 精确 */
        if (!ObjectUtils.isEmpty(query.getSkuName())) {
            list.add(qdo.skuName.eq(query.getSkuName()));
        }
        /** 客户主键 crm_customer.id 精确 */
        if (!ObjectUtils.isEmpty(query.getCustomerId())) {
            list.add(qdo.customerId.eq(query.getCustomerId()));
        }
        /** 客户名称  crm_custome.customer_name 精确 */
        if (!ObjectUtils.isEmpty(query.getCustomerName())) {
            list.add(qdo.customerName.eq(query.getCustomerName()));
        }

        /** 目标类型主键 精确 */
        if (!ObjectUtils.isEmpty(query.getObjId())) {
            list.add(qdo.objId.eq(query.getObjId()));
        }
        /** 目标类型名称 精确 */
        if (!ObjectUtils.isEmpty(query.getObjName())) {
            list.add(qdo.objName.eq(query.getObjName()));
        }
        /** 拓展字段1 精确 */
        if (!ObjectUtils.isEmpty(query.getExt1())) {
            list.add(qdo.ext1.eq(query.getExt1()));
        }
        /** 拓展字段2 精确 */
        if (!ObjectUtils.isEmpty(query.getExt2())) {
            list.add(qdo.ext2.eq(query.getExt2()));
        }
        /** 拓展字段3 精确 */
        if (!ObjectUtils.isEmpty(query.getExt3())) {
            list.add(qdo.ext3.eq(query.getExt3()));
        }
        /** 拓展字段4 精确 */
        if (!ObjectUtils.isEmpty(query.getExt4())) {
            list.add(qdo.ext4.eq(query.getExt4()));
        }
        /** 拓展字段5 精确 */
        if (!ObjectUtils.isEmpty(query.getExt5())) {
            list.add(qdo.ext5.eq(query.getExt5()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public SaleTargetVO queryByKey(Long id) {
        JPAQuery<SaleTargetVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<SaleTargetVO> queryListDynamic(SaleTargetQuery query) {
        JPAQuery<SaleTargetVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<SaleTargetVO> queryPaging(SaleTargetQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<SaleTargetVO> jpaQuery = getJpaQueryWhere(query);
        List<SaleTargetVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<SaleTargetVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public SaleTargetDO save(SaleTargetDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<SaleTargetDO> saveAll(List<SaleTargetDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(SaleTargetPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 主表主键 crm_sale_goal.goal_id
        if (payload.getGoalId() != null) {
            update.set(qdo.goalId, payload.getGoalId());
        }
        // 上级目标ID
        if (payload.getParentId() != null) {
            update.set(qdo.parentId, payload.getParentId());
        }
        // 目标名称
        if (payload.getGoalName() != null) {
            update.set(qdo.goalName, payload.getGoalName());
        }
        // 统计财年 crm_sale_goal.fiscal_year(冗余)
        if (payload.getFiscalYear() != null) {
            update.set(qdo.fiscalYear, payload.getFiscalYear());
        }
        // 第一季度目标值
        if (payload.getFirstQuarter() != null) {
            update.set(qdo.firstQuarter, payload.getFirstQuarter());
        }
        // 第二季度目标值
        if (payload.getSecondQuarter() != null) {
            update.set(qdo.secondQuarter, payload.getSecondQuarter());
        }
        // 第三季度目标值
        if (payload.getThirdQuarter() != null) {
            update.set(qdo.thirdQuarter, payload.getThirdQuarter());
        }
        // 第四季度目标值
        if (payload.getForthQuarter() != null) {
            update.set(qdo.forthQuarter, payload.getForthQuarter());
        }
        // 一月目标值
        if (payload.getJanuary() != null) {
            update.set(qdo.january, payload.getJanuary());
        }
        // 二月目标值
        if (payload.getFebruary() != null) {
            update.set(qdo.february, payload.getFebruary());
        }
        // 三月目标值
        if (payload.getMarch() != null) {
            update.set(qdo.march, payload.getMarch());
        }
        // 四月目标值
        if (payload.getApril() != null) {
            update.set(qdo.april, payload.getApril());
        }
        // 五月目标值
        if (payload.getMay() != null) {
            update.set(qdo.may, payload.getMay());
        }
        // 六月目标值
        if (payload.getJune() != null) {
            update.set(qdo.june, payload.getJune());
        }
        // 七月目标值
        if (payload.getJuly() != null) {
            update.set(qdo.july, payload.getJuly());
        }
        // 八月目标值
        if (payload.getAugust() != null) {
            update.set(qdo.august, payload.getAugust());
        }
        // 九月目标值
        if (payload.getSeptember() != null) {
            update.set(qdo.september, payload.getSeptember());
        }
        // 十月目标值
        if (payload.getOctober() != null) {
            update.set(qdo.october, payload.getOctober());
        }
        // 十一月目标值
        if (payload.getNovember() != null) {
            update.set(qdo.november, payload.getNovember());
        }
        // 十二月目标值
        if (payload.getDecember() != null) {
            update.set(qdo.december, payload.getDecember());
        }
        // 目标总值
        if (payload.getTargetCount() != null) {
            update.set(qdo.targetCount, payload.getTargetCount());
        }
        // udc[crm:goal_type](人员目标、客户目标、产品目标)
        if (payload.getGoalType() != null) {
            update.set(qdo.goalType, payload.getGoalType());
        }
        // 目标负责人主键 prd_org_employee.user_id
        if (payload.getDutyId() != null) {
            update.set(qdo.dutyId, payload.getDutyId());
        }
        // 目标负责人姓名  prd_org_employee.employee_name
        if (payload.getDutyName() != null) {
            update.set(qdo.dutyName, payload.getDutyName());
        }
        // 产品主键 crm_product_spu.id
        if (payload.getSkuId() != null) {
            update.set(qdo.skuId, payload.getSkuId());
        }
        // 产品名称 crm_product_spu.spu_name
        if (payload.getSkuName() != null) {
            update.set(qdo.skuName, payload.getSkuName());
        }
        // 客户主键 crm_customer.id
        if (payload.getCustomerId() != null) {
            update.set(qdo.customerId, payload.getCustomerId());
        }
        // 客户名称  crm_custome.customer_name
        if (payload.getCustomerName() != null) {
            update.set(qdo.customerName, payload.getCustomerName());
        }
        // 目标类型主键
        if (payload.getObjId() != null) {
            update.set(qdo.objId, payload.getObjId());
        }
        // 目标类型名称
        if (payload.getObjName() != null) {
            update.set(qdo.objName, payload.getObjName());
        }
        // 拓展字段1
        if (payload.getExt1() != null) {
            update.set(qdo.ext1, payload.getExt1());
        }
        // 拓展字段2
        if (payload.getExt2() != null) {
            update.set(qdo.ext2, payload.getExt2());
        }
        // 拓展字段3
        if (payload.getExt3() != null) {
            update.set(qdo.ext3, payload.getExt3());
        }
        // 拓展字段4
        if (payload.getExt4() != null) {
            update.set(qdo.ext4, payload.getExt4());
        }
        // 拓展字段5
        if (payload.getExt5() != null) {
            update.set(qdo.ext5, payload.getExt5());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 主表主键 crm_sale_goal.goal_id
            if (nullFields.contains("goalId")) {
                update.setNull(qdo.goalId);
            }
            // 上级目标ID
            if (nullFields.contains("parentId")) {
                update.setNull(qdo.parentId);
            }
            // 目标名称
            if (nullFields.contains("targetName")) {
                update.setNull(qdo.goalName);
            }
            // 统计财年 crm_sale_goal.fiscal_year(冗余)
            if (nullFields.contains("fiscalYear")) {
                update.setNull(qdo.fiscalYear);
            }
            // 第一季度目标值
            if (nullFields.contains("firstQuarter")) {
                update.setNull(qdo.firstQuarter);
            }
            // 第二季度目标值
            if (nullFields.contains("secondQuarter")) {
                update.setNull(qdo.secondQuarter);
            }
            // 第三季度目标值
            if (nullFields.contains("thirdQuarter")) {
                update.setNull(qdo.thirdQuarter);
            }
            // 第四季度目标值
            if (nullFields.contains("forthQuarter")) {
                update.setNull(qdo.forthQuarter);
            }
            // 一月目标值
            if (nullFields.contains("january")) {
                update.setNull(qdo.january);
            }
            // 二月目标值
            if (nullFields.contains("february")) {
                update.setNull(qdo.february);
            }
            // 三月目标值
            if (nullFields.contains("march")) {
                update.setNull(qdo.march);
            }
            // 四月目标值
            if (nullFields.contains("april")) {
                update.setNull(qdo.april);
            }
            // 五月目标值
            if (nullFields.contains("may")) {
                update.setNull(qdo.may);
            }
            // 六月目标值
            if (nullFields.contains("june")) {
                update.setNull(qdo.june);
            }
            // 七月目标值
            if (nullFields.contains("july")) {
                update.setNull(qdo.july);
            }
            // 八月目标值
            if (nullFields.contains("august")) {
                update.setNull(qdo.august);
            }
            // 九月目标值
            if (nullFields.contains("september")) {
                update.setNull(qdo.september);
            }
            // 十月目标值
            if (nullFields.contains("october")) {
                update.setNull(qdo.october);
            }
            // 十一月目标值
            if (nullFields.contains("november")) {
                update.setNull(qdo.november);
            }
            // 十二月目标值
            if (nullFields.contains("december")) {
                update.setNull(qdo.december);
            }
            // 目标总值
            if (nullFields.contains("targetCount")) {
                update.setNull(qdo.targetCount);
            }
            // udc[crm:goal_type](人员目标、客户目标、产品目标)
            if (nullFields.contains("goalType")) {
                update.setNull(qdo.goalType);
            }
            // 目标负责人主键 prd_org_employee.user_id
            if (nullFields.contains("dutyId")) {
                update.setNull(qdo.dutyId);
            }
            // 目标负责人姓名  prd_org_employee.employee_name
            if (nullFields.contains("dutyName")) {
                update.setNull(qdo.dutyName);
            }
            // 产品主键 crm_product_spu.id
            if (nullFields.contains("spuId")) {
                update.setNull(qdo.skuId);
            }
            // 产品名称 crm_product_spu.spu_name
            if (nullFields.contains("skuName")) {
                update.setNull(qdo.skuName);
            }
            // 客户主键 crm_customer.id
            if (nullFields.contains("customerId")) {
                update.setNull(qdo.customerId);
            }
            // 客户名称  crm_custome.customer_name
            if (nullFields.contains("customerName")) {
                update.setNull(qdo.customerName);
            }
            // 目标类型主键
            if (nullFields.contains("objId")) {
                update.setNull(qdo.objId);
            }
            // 目标类型名称
            if (nullFields.contains("objName")) {
                update.setNull(qdo.objName);
            }
            // 拓展字段1
            if (nullFields.contains("ext1")) {
                update.setNull(qdo.ext1);
            }
            // 拓展字段2
            if (nullFields.contains("ext2")) {
                update.setNull(qdo.ext2);
            }
            // 拓展字段3
            if (nullFields.contains("ext3")) {
                update.setNull(qdo.ext3);
            }
            // 拓展字段4
            if (nullFields.contains("ext4")) {
                update.setNull(qdo.ext4);
            }
            // 拓展字段5
            if (nullFields.contains("ext5")) {
                update.setNull(qdo.ext5);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    public long deleteSoftByGoalId(Long goalId) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.goalId.eq(goalId));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }




    /**
     * 查询客户目标实际完成值
     * @param query
     * @return
     */
    public List<SaleTargetCountResultVO> countCustomerVisitActual(SaleTargetStatisticalQuery query) {
        List<Predicate> list = new ArrayList<>();
        // 动态条件
        if (null != query.getCustomerId()) {
            list.add(qVisitTaskDO.customerId.in(query.getCustomerIds()));
        }
        if (null != query.getStartTime()) {
            list.add(qVisitTaskDO.modifyTime.goe(query.getStartTime()));
        }
        if (null != query.getEndTime()) {
            list.add(qVisitTaskDO.modifyTime.loe(query.getEndTime()));
        }
        // 根据考核范围 动态拼装条件
        query.getExamInformationVOList().forEach(examInformationVO -> {
            final String fieldKey = examInformationVO.getFieldKey();
            final String searchScope = examInformationVO.getSearchScope();
            // 值
            final String searchCondition = examInformationVO.getSearchCondition();
            if (!ObjectUtils.isEmpty(fieldKey)
                    && !ObjectUtils.isEmpty(searchCondition)) {
                List<String> searchConditionList = Arrays.asList(searchCondition.split(","));
                //目标负责人
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.DUTY.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        if (!CollectionUtils.isEmpty(query.getUserIds())) {
                            list.add(qVisitTaskDO.visitMemberId.in(query.getUserIds()));
                        }
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        //list.add(qVisitTaskDO.visitMemberId.eq(searchCondition));
                    }
                }
                //任务状态
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.STATUS.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qVisitTaskDO.status.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qVisitTaskDO.status.eq(searchCondition));
                    }
                }
                //客户区域
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.AREA.getCode())) {

                }
                //客户级别
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.LEVEL.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qCrmCustomerDO.customerGrade.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qCrmCustomerDO.customerGrade.eq(searchCondition));
                    }
                }
                //客户行业
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.INDUSTRY.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qdoCompany.companyIndustry.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qdoCompany.companyIndustry.eq(searchCondition));
                    }
                }
            }

        });

        Predicate predicate = ExpressionUtils.allOf(list);
        JPAQuery<SaleTargetCountResultVO> jpaQuery = jpaQueryFactory
                .select(Projections.bean(SaleTargetCountResultVO.class,
                        qVisitTaskDO.customerId,
                        qVisitTaskDO.customerName,
                        qVisitTaskDO.count().as("actualCountLong")
                ))
                .from(qVisitTaskDO)
                .leftJoin(qCrmCustomerDO).on(qVisitTaskDO.customerId.eq(qCrmCustomerDO.id))
                .leftJoin(qdoAb).on(qdoAb.id.eq(qCrmCustomerDO.bookId))
                .leftJoin(qdoCompany).on(qdoAb.id.eq(qdoCompany.bookId))
                .where(predicate)
                .groupBy(qVisitTaskDO.customerId);
        List<SaleTargetCountResultVO> resultList = jpaQuery.fetch();
        return resultList;
    }



    /**
     * 考核指标：拜访数
     * 拉取人员目标实际完成值
     * @param
     * @return
     */

    public List<SaleTargetCountResultVO> countUserVisitActual(SaleTargetStatisticalQuery query) {
        List<Predicate> list = new ArrayList<>();
        // 动态条件
        if (null != query.getStartTime()) {
            list.add(qVisitTaskDO.modifyTime.goe(query.getStartTime()));
        }
        if (null != query.getEndTime()) {
            list.add(qVisitTaskDO.modifyTime.loe(query.getEndTime()));
        }
        // 根据考核范围 动态拼装条件
        query.getExamInformationVOList().forEach(examInformationVO -> {
            final String fieldKey = examInformationVO.getFieldKey();
            final String searchScope = examInformationVO.getSearchScope();
            // 值
            final String searchCondition = examInformationVO.getSearchCondition();
            if (!ObjectUtils.isEmpty(fieldKey)
                    && !ObjectUtils.isEmpty(searchCondition)) {
                List<String> searchConditionList = Arrays.asList(searchCondition.split(","));
                //目标负责人
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.DUTY.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        if (!CollectionUtils.isEmpty(query.getUserIds())) {
                            list.add(qVisitTaskDO.visitMemberId.in(query.getUserIds()));
                        }
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        //list.add(qVisitTaskDO.visitMemberId.eq(searchCondition));
                    }
                }
                //任务状态
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.STATUS.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qVisitTaskDO.status.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qVisitTaskDO.status.eq(searchCondition));
                    }
                }
                //客户区域
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.AREA.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qVisitTaskDO.status.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qVisitTaskDO.customerName.eq(searchCondition));
                    }
                }
                //客户级别
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.LEVEL.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qCrmCustomerDO.customerGrade.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qCrmCustomerDO.customerGrade.eq(searchCondition));
                    }
                }
                //客户行业
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.INDUSTRY.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qdoCompany.companyIndustry.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qdoCompany.companyIndustry.eq(searchCondition));
                    }
                }
            }

        });

        Predicate predicate = ExpressionUtils.allOf(list);
        JPAQuery<SaleTargetCountResultVO> jpaQuery = jpaQueryFactory
                .select(Projections.bean(SaleTargetCountResultVO.class,
                        qVisitTaskDO.visitMemberId.as("userId"),
                        qVisitTaskDO.count().as("actualCountLong")
                ))
                .from(qVisitTaskDO)
                .leftJoin(qCrmCustomerDO).on(qVisitTaskDO.customerId.eq(qCrmCustomerDO.id))
                .leftJoin(qdoAb).on(qdoAb.id.eq(qCrmCustomerDO.bookId))
                .leftJoin(qdoCompany).on(qdoAb.id.eq(qdoCompany.bookId))
                .where(predicate)
                .groupBy(qVisitTaskDO.visitMemberId);
        List<SaleTargetCountResultVO> resultList = jpaQuery.fetch();
        return resultList;
    }
    /**
     * 人员排行榜
     * 根据指标条件查询实际完成值
     * 考核指标:线索数
     * @param query
     * @return
     */
    public List<SaleTargetCountResultVO> countClueByExamInformation(SaleTargetStatisticalQuery query) {
        List<Predicate> list = new ArrayList<>();
        // 动态条件
        if (null != query.getUserId()) {
            list.add(qCrmLeadsDO.sourceUserId.eq(query.getUserId()));
        }
        if (null != query.getStartTime()) {
            list.add(qCrmLeadsDO.modifyTime.goe(query.getStartTime()));
        }
        if (null != query.getEndTime()) {
            list.add(qCrmLeadsDO.modifyTime.loe(query.getEndTime()));
        }
        // 固定条件
        list.add(qPrdOrgEmployeeRefDO.deleteFlag.eq(0));
        list.add(qPrdOrgEmployeeRefDO.isCopy.eq(0));
        list.add(qPrdOrgEmployeeRefDO.isDefault.eq(0));
        list.add(qPrdOrgOrganizationDO.deleteFlag.eq(0));
        // 根据考核范围 动态拼装条件
        query.getExamInformationVOList().forEach(examInformationVO -> {
            final String fieldKey = examInformationVO.getFieldKey();
            final String searchScope = examInformationVO.getSearchScope();
            // 值
            final String searchCondition = examInformationVO.getSearchCondition();
            if (!ObjectUtils.isEmpty(fieldKey)
                    && !ObjectUtils.isEmpty(searchCondition)) {
                List<String> searchConditionList = Arrays.asList(searchCondition.split(","));
                //目标负责人
                if (fieldKey.equals(SaleTargetUserLeadsFieldEnum.SOURCE_USER_ID.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        if (!CollectionUtils.isEmpty(query.getUserIds())) {
                            list.add(qCrmLeadsDO.sourceUserId.in(query.getUserIds()));
                        }
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qCrmLeadsDO.sourceUserId.eq(query.getUserId()));
                    }
                }
                //线索状态
                if (fieldKey.equals(SaleTargetUserLeadsFieldEnum.LEADS_STAGE.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qCrmLeadsDO.leadsStatus.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qCrmLeadsDO.leadsStatus.eq(searchCondition));
                    }
                }
                //线索阶段
                if (fieldKey.equals(SaleTargetUserLeadsFieldEnum.LEADS_STAGE.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qCrmLeadsDO.leadsStage.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qCrmLeadsDO.leadsStage.eq(searchCondition));
                    }
                }
                //跟进级别
                if (fieldKey.equals(SaleTargetUserLeadsFieldEnum.CUSTOMER_GRADE.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qCrmCustomerDO.customerGrade.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qCrmCustomerDO.customerGrade.eq(searchCondition));
                    }
                }
                //客户行业
                if (fieldKey.equals(SaleTargetUserLeadsFieldEnum.CUSTOMER_INDUSTRY.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qdoCompany.companyIndustry.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qdoCompany.companyIndustry.eq(searchCondition));
                    }
                }
            }

        });

        Predicate predicate = ExpressionUtils.allOf(list);
        JPAQuery<SaleTargetCountResultVO> jpaQuery = jpaQueryFactory
                .select(Projections.bean(SaleTargetCountResultVO.class,
                        qCrmLeadsDO.sourceUserId.as("userId"),
                        qCrmLeadsDO.count().as("actualCountLong")
                ))
                .from(qCrmLeadsDO)
                .leftJoin(qPrdOrgEmployeeRefDO).on(qPrdOrgEmployeeRefDO.userId.eq(qCrmLeadsDO.sourceUserId))
                .leftJoin(qPrdOrgOrganizationDO).on(qPrdOrgOrganizationDO.id.eq(qPrdOrgEmployeeRefDO.orgId))
                .leftJoin(qCrmCustomerDO).on(qCrmLeadsDO.customer.id.eq(qCrmCustomerDO.id))
                .leftJoin(qdoAb).on(qdoAb.id.eq(qCrmCustomerDO.bookId))
                .leftJoin(qdoCompany).on(qdoAb.id.eq(qdoCompany.bookId))
                .where(predicate)
                .groupBy(qCrmLeadsDO.sourceUserId);
        List<SaleTargetCountResultVO> resultList = jpaQuery.fetch();
        return resultList;
    }


    /**
     * 人员排行榜
     * 根据指标条件查询实际完成值
     * 考核指标:商机金额
     * @param query
     * @return
     */
    public List<SaleTargetCountResultVO> countOppoByExamInformation(SaleTargetStatisticalQuery query) {
        List<Predicate> list = new ArrayList<>();
        // 动态条件
        if (null != query.getOrgId()) {
            list.add(qPrdOrgOrganizationDO.id.eq(query.getOrgId()));
        }
        if (null != query.getUserId()) {
            list.add(qPrjProjectDO.manageUserId.eq(query.getUserId()));
        }
        if (null != query.getStartTime()) {
            list.add(qCrmOpportunityDO.modifyTime.goe(query.getStartTime()));
        }
        if (null != query.getEndTime()) {
            list.add(qCrmOpportunityDO.modifyTime.loe(query.getEndTime()));
        }
        // 固定条件
        list.add(qPrdOrgEmployeeRefDO.deleteFlag.eq(0));
        list.add(qPrjProjectDO.deleteFlag.eq(0));
        list.add(qPrdOrgEmployeeRefDO.isCopy.eq(0));
        list.add(qPrdOrgEmployeeRefDO.isDefault.eq(0));
        list.add(qPrdOrgOrganizationDO.deleteFlag.eq(0));
        // 根据考核范围 动态拼装条件
        query.getExamInformationVOList().forEach(examInformationVO -> {
            final String fieldKey = examInformationVO.getFieldKey();
            final String searchScope = examInformationVO.getSearchScope();
            // 值
            final String searchCondition = examInformationVO.getSearchCondition();
            if (!ObjectUtils.isEmpty(fieldKey)
                    && !ObjectUtils.isEmpty(searchCondition)) {
                List<String> searchConditionList = Arrays.asList(searchCondition.split(","));
                //目标负责人
                if (fieldKey.equals(SaleTargetUserOppoFieldEnum.MANAGE_USER_ID.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        if (!CollectionUtils.isEmpty(query.getUserIds())) {
                            list.add(qPrjProjectDO.manageUserId.in(query.getUserIds()));
                        }
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qPrjProjectDO.manageUserId.eq(query.getUserId()));
                    }
                }
                //商机状态
                if (fieldKey.equals(SaleTargetUserOppoFieldEnum.PROJECT_STATUS.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qPrjProjectDO.projectStatus.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qPrjProjectDO.projectStatus.eq(searchCondition));
                    }
                }
                //商机级别
                if (fieldKey.equals(SaleTargetUserOppoFieldEnum.OPPO_LEVEL.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qCrmOpportunityDO.oppoLevel.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qCrmOpportunityDO.oppoLevel.eq(searchCondition));
                    }
                }
                //销售阶段
                if (fieldKey.equals(SaleTargetUserOppoFieldEnum.SALE_PHASE.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qCrmOpportunityDO.salePhase.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qCrmOpportunityDO.salePhase.eq(searchCondition));
                    }
                }
                //成单概率
                if (fieldKey.equals(SaleTargetUserOppoFieldEnum.PROBABILITY.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qCrmOpportunityDO.probability.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qCrmOpportunityDO.probability.eq(searchCondition));
                    }
                }
            }

        });

        Predicate predicate = ExpressionUtils.allOf(list);
        JPAQuery<SaleTargetCountResultVO> jpaQuery = jpaQueryFactory
                .select(Projections.bean(SaleTargetCountResultVO.class,
                        qPrjProjectDO.manageUserId.as("userId"),
                        qCrmOpportunityDO.count().as("actualCountLong")
                ))
                .from(qCrmOpportunityDO)
                .leftJoin(qPrjProjectDO).on(qPrjProjectDO.id.eq(qCrmOpportunityDO.projectId))
                .leftJoin(qPrdOrgEmployeeRefDO).on(qPrdOrgEmployeeRefDO.userId.eq(qPrjProjectDO.manageUserId))
                .leftJoin(qPrdOrgOrganizationDO).on(qPrdOrgOrganizationDO.id.eq(qPrdOrgEmployeeRefDO.orgId))
                .where(predicate)
                .groupBy(qPrjProjectDO.manageUserId);
        List<SaleTargetCountResultVO> resultList = jpaQuery.fetch();
        return resultList;
    }
    /**
     * 人员排行榜
     * 根据指标条件查询实际完成值
     * 考核指标:客户数
     * @param query
     * @return
     */
    public List<SaleTargetCountResultVO> countCustomerByExam(SaleTargetStatisticalQuery query) {
        List<Predicate> list = new ArrayList<>();
        // 动态条件
        if (null != query.getOrgId()) {
            list.add(qPrdOrgOrganizationDO.id.eq(query.getOrgId()));
        }
        if (null != query.getUserId()) {
            list.add(qCrmCustomerDO.businessUserId.eq(query.getUserId()));
        }
        if (null != query.getStartTime()) {
            list.add(qCrmCustomerDO.modifyTime.goe(query.getStartTime()));
        }
        if (null != query.getEndTime()) {
            list.add(qCrmCustomerDO.modifyTime.loe(query.getEndTime()));
        }
        // 固定条件
        list.add(qPrdOrgEmployeeRefDO.deleteFlag.eq(0));
        list.add(qPrdOrgEmployeeRefDO.isCopy.eq(0));
        list.add(qPrdOrgEmployeeRefDO.isDefault.eq(0));
        list.add(qPrdOrgOrganizationDO.deleteFlag.eq(0));
        list.add(qdoAb.deleteFlag.eq(0));
        list.add(qdoCompany.deleteFlag.eq(0));
        // 商务负责人不能为空
        list.add(qCrmCustomerDO.businessUserId.isNotNull());
        // 根据考核范围 动态拼装条件
        query.getExamInformationVOList().forEach(examInformationVO -> {
            final String fieldKey = examInformationVO.getFieldKey();
            final String searchScope = examInformationVO.getSearchScope();
            // 值
            final String searchCondition = examInformationVO.getSearchCondition();
            if (!ObjectUtils.isEmpty(fieldKey)
                    && !ObjectUtils.isEmpty(searchCondition)) {
                List<String> searchConditionList = Arrays.asList(searchCondition.split(","));
                //// 商务负责人
                if (fieldKey.equals(SaleTargetUserOppoFieldEnum.MANAGE_USER_ID.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        if (!CollectionUtils.isEmpty(query.getUserIds())) {
                            list.add(qCrmCustomerDO.businessUserId.in(query.getUserIds()));
                        }
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qCrmCustomerDO.businessUserId.eq(query.getUserId()));
                    }
                }
                // 客户状态
                if (fieldKey.equals(SaleTargetUserCustomerFieldEnum.CUSTOMER_STATUS.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qCrmCustomerDO.customerStatus.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qCrmCustomerDO.customerStatus.eq(searchCondition));
                    }
                }
                //客户区域
                if (fieldKey.equals(SaleTargetUserCustomerFieldEnum.AREA.getCode())) {

                }

                //客户级别
                if (fieldKey.equals(SaleTargetUserCustomerFieldEnum.LEVEL.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qCrmCustomerDO.customerGrade.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qCrmCustomerDO.customerGrade.eq(searchCondition));
                    }
                }
                //客户行业
                if (fieldKey.equals(SaleTargetUserCustomerFieldEnum.INDUSTRY.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qdoCompany.companyIndustry.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qdoCompany.companyIndustry.eq(searchCondition));
                    }
                }
            }

        });

        Predicate predicate = ExpressionUtils.allOf(list);
        JPAQuery<SaleTargetCountResultVO> jpaQuery = jpaQueryFactory
                .select(Projections.bean(SaleTargetCountResultVO.class,
                        qCrmCustomerDO.businessUserId.as("userId"),
                        qCrmCustomerDO.count().as("actualCountLong")
                ))
                .from(qCrmCustomerDO)
                .leftJoin(qPrdOrgEmployeeRefDO).on(qPrdOrgEmployeeRefDO.userId.eq(qCrmCustomerDO.businessUserId))
                .leftJoin(qPrdOrgOrganizationDO).on(qPrdOrgOrganizationDO.id.eq(qPrdOrgEmployeeRefDO.orgId))
                .leftJoin(qdoAb).on(qdoAb.id.eq(qCrmCustomerDO.bookId))
                .leftJoin(qdoCompany).on(qdoAb.id.eq(qdoCompany.bookId))
                .where(predicate)
                .groupBy(qCrmCustomerDO.businessUserId);
        List<SaleTargetCountResultVO> resultList = jpaQuery.fetch();
        return resultList;
    }





    /**
     * 人员目标统计
     * 考核指标:拜访数
     * @param examInformationVOS
     * @return
     */
    public List<SaleTargetCountVO> countOrgVisitByExamInformation(Long goalId, List<ExamInformationVO> examInformationVOS, Long orgId, Long userId, Set<Long> userIds) {

        List<Predicate> list = new ArrayList<>();
        if (null != orgId) {
            list.add(qPrdOrgOrganizationDO.id.eq(orgId));
        }
        if (null != userId) {
            list.add(qVisitTaskDO.visitMemberId.eq(userId));
        }

        //固定条件
        list.add(qPrdOrgEmployeeRefDO.deleteFlag.eq(0));
        list.add(qPrdOrgEmployeeRefDO.isCopy.eq(0));
        list.add(qPrdOrgEmployeeRefDO.isDefault.eq(0));
        list.add(qPrdOrgOrganizationDO.deleteFlag.eq(0));
        list.add(qPrdOrgOrganizationDO.isCopy.eq(0));
        examInformationVOS.forEach(examInformationVO -> {
            final String fieldKey = examInformationVO.getFieldKey();
            final String searchScope = examInformationVO.getSearchScope();
            final String searchCondition = examInformationVO.getSearchCondition();
            if (!ObjectUtils.isEmpty(fieldKey)
                    && !ObjectUtils.isEmpty(searchCondition)) {
                List<String> searchConditionList = Arrays.asList(searchCondition.split(","));
                //目标负责人
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.DUTY.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        if(!CollectionUtils.isEmpty(userIds)){
                            list.add(qVisitTaskDO.visitMemberId.in(userIds));
                        }
                    }
                }
                //任务状态
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.STATUS.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qVisitTaskDO.status.in(searchConditionList));
                    } else if(searchScope.equals(SearchScopeEnum.EQ.getCode())){
                        list.add(qVisitTaskDO.status.eq(searchCondition));
                    }
                }
                //客户区域
//                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.AREA.getCode())) {
//                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
//                        list.add(qVisitTaskDO.status.in(searchConditionList));
//                    } else if(searchScope.equals(SearchScopeEnum.EQ.getCode())){
//                        list.add(qVisitTaskDO.customerName.eq(searchCondition));
//                    }
//                }
                //客户级别
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.LEVEL.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qCrmCustomerDO.customerGrade.in(searchConditionList));
                    } else if(searchScope.equals(SearchScopeEnum.EQ.getCode())){
                        list.add(qCrmCustomerDO.customerGrade.eq(searchCondition));
                    }
                }
                //客户行业
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.INDUSTRY.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qdoCompany.companyIndustry.in(searchConditionList));
                    } else if(searchScope.equals(SearchScopeEnum.EQ.getCode())){
                        list.add(qdoCompany.companyIndustry.eq(searchCondition));
                    }
                }
            }

        });

        Predicate predicate = ExpressionUtils.allOf(list);
        JPAQuery<SaleTargetCountVO> jpaQuery=jpaQueryFactory
                .select(Projections.bean(SaleTargetCountVO.class,
                        //qSaleTargetDO.targetCount.sum(),
                        qVisitTaskDO.count().as("sumCountLong")
                ))
                .from(qVisitTaskDO)
                .leftJoin(qPrdOrgEmployeeRefDO).on(qPrdOrgEmployeeRefDO.userId.eq(qVisitTaskDO.visitMemberId))
                .leftJoin(qPrdOrgOrganizationDO).on(qPrdOrgEmployeeRefDO.orgId.eq(qPrdOrgOrganizationDO.id))
                .leftJoin(qCrmCustomerDO).on(qVisitTaskDO.customerId.eq(qCrmCustomerDO.id))
                .leftJoin(qdoAb).on(qdoAb.id.eq(qCrmCustomerDO.bookId))
                .leftJoin(qdoCompany).on(qdoAb.id.eq(qdoCompany.bookId))
                .where(predicate);
        List<SaleTargetCountVO> resultList = jpaQuery.fetch();
        return resultList;
    }
    /**
     * 人员目标统计
     * 考核指标:线索数
     * @param examInformationVOS
     * @return
     */
    public List<SaleTargetCountVO> countOrgClueByExamInformation(Long goalId, List<ExamInformationVO> examInformationVOS, Long orgId, Long userId, Set<Long> userIds) {

        List<Predicate> list = new ArrayList<>();
        if (null != orgId) {
            list.add(qPrdOrgOrganizationDO.id.eq(orgId));
        }
        if (null != userId) {
            list.add(qCrmLeadsDO.sourceUserId.eq(userId));
        }
        // 固定条件
        list.add(qPrdOrgEmployeeRefDO.deleteFlag.eq(0));
        list.add(qPrdOrgEmployeeRefDO.isCopy.eq(0));
        list.add(qPrdOrgEmployeeRefDO.isDefault.eq(0));
        list.add(qPrdOrgOrganizationDO.deleteFlag.eq(0));
        examInformationVOS.forEach(examInformationVO -> {
            final String fieldKey = examInformationVO.getFieldKey();
            final String searchScope = examInformationVO.getSearchScope();
            final String searchCondition = examInformationVO.getSearchCondition();
            if (!ObjectUtils.isEmpty(fieldKey)
                    && !ObjectUtils.isEmpty(searchCondition)) {
                List<String> searchConditionList = Arrays.asList(searchCondition.split(","));
                //目标负责人
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.DUTY.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        if (!CollectionUtils.isEmpty(userIds)) {
                            list.add(qCrmLeadsDO.sourceUserId.in(userIds));
                        }
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qCrmLeadsDO.sourceUserId.eq(userId));
                    }
                }
                //线索状态
                if (fieldKey.equals(SaleTargetUserLeadsFieldEnum.LEADS_STAGE.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qCrmLeadsDO.leadsStatus.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qCrmLeadsDO.leadsStatus.eq(searchCondition));
                    }
                }
                //线索阶段
                if (fieldKey.equals(SaleTargetUserLeadsFieldEnum.LEADS_STAGE.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qCrmLeadsDO.leadsStage.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qCrmLeadsDO.leadsStage.eq(searchCondition));
                    }
                }
                //跟进级别
                if (fieldKey.equals(SaleTargetUserLeadsFieldEnum.CUSTOMER_GRADE.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qCrmCustomerDO.customerGrade.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qCrmCustomerDO.customerGrade.eq(searchCondition));
                    }
                }
                //客户行业
                if (fieldKey.equals(SaleTargetUserLeadsFieldEnum.CUSTOMER_INDUSTRY.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qdoCompany.companyIndustry.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qdoCompany.companyIndustry.eq(searchCondition));
                    }
                }
            }
        });

        Predicate predicate = ExpressionUtils.allOf(list);
        JPAQuery<SaleTargetCountVO> jpaQuery=jpaQueryFactory
                .select(Projections.bean(SaleTargetCountVO.class,
                        qCrmLeadsDO.count().as("sumCountLong")
                ))
                .from(qCrmLeadsDO)
                .leftJoin(qPrdOrgEmployeeRefDO).on(qPrdOrgEmployeeRefDO.userId.eq(qCrmLeadsDO.sourceUserId))
                .leftJoin(qPrdOrgOrganizationDO).on(qPrdOrgOrganizationDO.id.eq(qPrdOrgEmployeeRefDO.orgId))
                .leftJoin(qCrmCustomerDO).on(qCrmLeadsDO.customer.id.eq(qCrmCustomerDO.id))
                .leftJoin(qdoAb).on(qdoAb.id.eq(qCrmCustomerDO.bookId))
                .leftJoin(qdoCompany).on(qdoAb.id.eq(qdoCompany.bookId))
                .where(predicate);
        List<SaleTargetCountVO> resultList = jpaQuery.fetch();
        return resultList;
    }



    /**
     * 人员目标统计
     * 考核指标:商机金额
     * @param examInformationVOS
     * @return
     */
    public List<SaleTargetCountVO> countOrgOppoByExamInformation(Long goalId, List<ExamInformationVO> examInformationVOS, Long orgId, Long userId, Set<Long> userIds) {

        List<Predicate> list = new ArrayList<>();
        if (null != orgId) {
            list.add(qPrdOrgOrganizationDO.id.eq(orgId));
        }
        if (null != userId) {
            list.add(qPrjProjectDO.manageUserId.eq(userId));
        }
        // 固定条件
        list.add(qPrdOrgEmployeeRefDO.deleteFlag.eq(0));
        list.add(qPrjProjectDO.deleteFlag.eq(0));
        list.add(qPrdOrgEmployeeRefDO.isCopy.eq(0));
        list.add(qPrdOrgEmployeeRefDO.isDefault.eq(0));
        list.add(qPrdOrgOrganizationDO.deleteFlag.eq(0));
        examInformationVOS.forEach(examInformationVO -> {
            final String fieldKey = examInformationVO.getFieldKey();
            final String searchScope = examInformationVO.getSearchScope();
            // 值
            final String searchCondition = examInformationVO.getSearchCondition();
            if (!ObjectUtils.isEmpty(fieldKey)
                    && !ObjectUtils.isEmpty(searchCondition)) {
                List<String> searchConditionList = Arrays.asList(searchCondition.split(","));
                //目标负责人
                if (fieldKey.equals(SaleTargetUserOppoFieldEnum.MANAGE_USER_ID.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                            if (!CollectionUtils.isEmpty(userIds)) {
                                list.add(qPrjProjectDO.manageUserId.in(userIds));
                            }
                         else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                            list.add(qPrjProjectDO.manageUserId.eq(userId));
                        }
                    }
                }
                //商机状态
                if (fieldKey.equals(SaleTargetUserOppoFieldEnum.PROJECT_STATUS.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qPrjProjectDO.projectStatus.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qPrjProjectDO.projectStatus.eq(searchCondition));
                    }
                }
                //商机级别
                if (fieldKey.equals(SaleTargetUserOppoFieldEnum.OPPO_LEVEL.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qCrmOpportunityDO.oppoLevel.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qCrmOpportunityDO.oppoLevel.eq(searchCondition));
                    }
                }
                //销售阶段
                if (fieldKey.equals(SaleTargetUserOppoFieldEnum.SALE_PHASE.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qCrmOpportunityDO.salePhase.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qCrmOpportunityDO.salePhase.eq(searchCondition));
                    }
                }
                //成单概率
                if (fieldKey.equals(SaleTargetUserOppoFieldEnum.PROBABILITY.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qCrmOpportunityDO.probability.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qCrmOpportunityDO.probability.eq(searchCondition));
                    }
                }
            }

        });
        Predicate predicate = ExpressionUtils.allOf(list);
        JPAQuery<SaleTargetCountVO> jpaQuery=jpaQueryFactory
                .select(Projections.bean(SaleTargetCountVO.class,
                        qCrmOpportunityDO.count().as("sumCountLong")
                ))
                .from(qCrmOpportunityDO)
                .leftJoin(qPrjProjectDO).on(qPrjProjectDO.id.eq(qCrmOpportunityDO.projectId))
                .leftJoin(qPrdOrgEmployeeRefDO).on(qPrdOrgEmployeeRefDO.userId.eq(qPrjProjectDO.manageUserId))
                .leftJoin(qPrdOrgOrganizationDO).on(qPrdOrgOrganizationDO.id.eq(qPrdOrgEmployeeRefDO.orgId))
                .where(predicate);
        List<SaleTargetCountVO> resultList = jpaQuery.fetch();
        return resultList;
    }

    /**
     * 人员目标统计
     * 考核指标:客户数
     * @param examInformationVOS
     * @return
     */
    public List<SaleTargetCountVO> countOrgCustomerByExamInformation(Long goalId, List<ExamInformationVO> examInformationVOS, Long orgId, Long userId, Set<Long> userIds) {
        List<Predicate> list = new ArrayList<>();
        if (null != orgId) {
            list.add(qPrdOrgOrganizationDO.id.eq(orgId));
        }
        if (null != userId) {
            list.add(qCrmCustomerDO.businessUserId.eq(userId));
        }
        // 固定条件
        list.add(qPrdOrgEmployeeRefDO.deleteFlag.eq(0));
        list.add(qPrdOrgEmployeeRefDO.isCopy.eq(0));
        list.add(qPrdOrgEmployeeRefDO.isDefault.eq(0));
        list.add(qPrdOrgOrganizationDO.deleteFlag.eq(0));
        list.add(qdoAb.deleteFlag.eq(0));
        list.add(qdoCompany.deleteFlag.eq(0));
        // 商务负责人不能为空
        list.add(qCrmCustomerDO.businessUserId.isNotNull());
        examInformationVOS.forEach(examInformationVO -> {
            final String fieldKey = examInformationVO.getFieldKey();
            final String searchScope = examInformationVO.getSearchScope();
            // 值
            final String searchCondition = examInformationVO.getSearchCondition();
            if (!ObjectUtils.isEmpty(fieldKey)
                    && !ObjectUtils.isEmpty(searchCondition)) {
                List<String> searchConditionList = Arrays.asList(searchCondition.split(","));
                //// 商务负责人
                if (fieldKey.equals(SaleTargetUserOppoFieldEnum.MANAGE_USER_ID.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        if (!CollectionUtils.isEmpty(userIds)) {
                            list.add(qCrmCustomerDO.businessUserId.in(userIds));
                        }
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qCrmCustomerDO.businessUserId.eq(userId));
                    }
                }
                // 客户状态
                if (fieldKey.equals(SaleTargetUserCustomerFieldEnum.CUSTOMER_STATUS.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qCrmCustomerDO.customerStatus.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qCrmCustomerDO.customerStatus.eq(searchCondition));
                    }
                }
                //客户区域
                if (fieldKey.equals(SaleTargetUserCustomerFieldEnum.AREA.getCode())) {

                }

                //客户级别
                if (fieldKey.equals(SaleTargetUserCustomerFieldEnum.LEVEL.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qCrmCustomerDO.customerGrade.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qCrmCustomerDO.customerGrade.eq(searchCondition));
                    }
                }
                //客户行业
                if (fieldKey.equals(SaleTargetUserCustomerFieldEnum.INDUSTRY.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qdoCompany.companyIndustry.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qdoCompany.companyIndustry.eq(searchCondition));
                    }
                }
            }
        });
        Predicate predicate = ExpressionUtils.allOf(list);
        JPAQuery<SaleTargetCountVO> jpaQuery=jpaQueryFactory
                .select(Projections.bean(SaleTargetCountVO.class,
                        qCrmCustomerDO.count().as("sumCountLong")
                ))
                .from(qCrmCustomerDO)
                .leftJoin(qPrdOrgEmployeeRefDO).on(qPrdOrgEmployeeRefDO.userId.eq(qCrmCustomerDO.businessUserId))
                .leftJoin(qPrdOrgOrganizationDO).on(qPrdOrgOrganizationDO.id.eq(qPrdOrgEmployeeRefDO.orgId))
                .leftJoin(qdoAb).on(qdoAb.id.eq(qCrmCustomerDO.bookId))
                .leftJoin(qdoCompany).on(qdoAb.id.eq(qdoCompany.bookId))
                .where(predicate);
        List<SaleTargetCountVO> resultList = jpaQuery.fetch();
        return resultList;
    }



    /**
     * 指标条件：拜访数
     * 客户目标统计实际完成值
     * @param examInformationVOS
     * @param query
     * @return
     */
    public List<SaleTargetCountVO> countCustomerByExamInformation(List<ExamInformationVO> examInformationVOS, SaleTargetCustomerQuery query) {
        List<Predicate> list = new ArrayList<>();
        //动态条件
        if (!ObjectUtils.isEmpty(query.getCustomerGrade())){
            list.add(qCrmCustomerDO.customerGrade.eq(query.getCustomerGrade()));
        }
        if (!ObjectUtils.isEmpty(query.getCustomerIndustry())){
            list.add(qdoCompany.companyIndustry.eq(query.getCustomerIndustry()));
        }
        if (null != query.getCustomerId()) {
            list.add(qVisitTaskDO.customerId.in(query.getCustomerIds()));
        }
//        if (!ObjectUtils.isEmpty(query.getCustRegion())){
//            list.add(qCrmCustomerDO.eq(query.getCustRegion()));
//        }

        // 固定条件
        list.add(qCrmCustomerDO.deleteFlag.eq(0));
        examInformationVOS.forEach(examInformationVO -> {
            final String fieldKey = examInformationVO.getFieldKey();
            final String searchScope = examInformationVO.getSearchScope();
            // 值
            final String searchCondition = examInformationVO.getSearchCondition();
            if (!ObjectUtils.isEmpty(fieldKey)
                    && !ObjectUtils.isEmpty(searchCondition)) {
                List<String> searchConditionList = Arrays.asList(searchCondition.split(","));
                //目标负责人
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.DUTY.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        if (!CollectionUtils.isEmpty(query.getUserIds())) {
                            list.add(qVisitTaskDO.visitMemberId.in(query.getUserIds()));
                        }
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        //list.add(qVisitTaskDO.visitMemberId.eq(searchCondition));
                    }
                }
                //任务状态
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.STATUS.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qVisitTaskDO.status.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qVisitTaskDO.status.eq(searchCondition));
                    }
                }
                //客户区域
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.AREA.getCode())) {

                }
                //客户级别
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.LEVEL.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qCrmCustomerDO.customerGrade.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qCrmCustomerDO.customerGrade.eq(searchCondition));
                    }
                }
                //客户行业
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.INDUSTRY.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(qdoCompany.companyIndustry.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(qdoCompany.companyIndustry.eq(searchCondition));
                    }
                }
            }
        });
        Predicate predicate = ExpressionUtils.allOf(list);
        JPAQuery<SaleTargetCountVO> jpaQuery=jpaQueryFactory
                .select(Projections.bean(SaleTargetCountVO.class,
                        qVisitTaskDO.count().as("sumCountLong")
                ))
                .from(qVisitTaskDO)
                .leftJoin(qCrmCustomerDO).on(qVisitTaskDO.customerId.eq(qCrmCustomerDO.id))
                .leftJoin(qdoAb).on(qdoAb.id.eq(qCrmCustomerDO.bookId))
                .leftJoin(qdoCompany).on(qdoAb.id.eq(qdoCompany.bookId))
                .where(predicate);
        List<SaleTargetCountVO> resultList = jpaQuery.fetch();
        return resultList;
    }




    /**
     * 额定值
     * @param goalId
     * @param ext1
     * @param userId
     * @param orgId
     * @return
     */
    public List<SaleTargetVO> countUserSaleTarget(Long goalId, String ext1,Long userId,Long orgId) {
        List<Predicate> list = new ArrayList<>();
        // 动态条件
        if (null != goalId) {
            list.add(qSaleTargetDO.goalId.eq(goalId));
        }
        if (!ObjectUtils.isEmpty(ext1)) {
            list.add(qSaleTargetDO.ext1.eq(ext1));
        }
        if (null!=userId){
            list.add(qSaleTargetDO.dutyId.eq(userId));
        }
        if (null!=orgId){
            list.add(qPrdOrgOrganizationDO.id.eq(orgId));
        }
        // 固定条件
        list.add(qPrdOrgEmployeeRefDO.deleteFlag.eq(0));
        list.add(qPrdOrgEmployeeRefDO.isCopy.eq(0));
        list.add(qPrdOrgEmployeeRefDO.isDefault.eq(0));
        list.add(qPrdOrgOrganizationDO.deleteFlag.eq(0));

        Predicate predicate = ExpressionUtils.allOf(list);
        JPAQuery<SaleTargetVO> jpaQuery = jpaQueryFactory
                .select(Projections.bean(SaleTargetVO.class,
                        // 目标总值
                        qSaleTargetDO.targetCount.sum().as("targetCount"),
                        // 目标负责人主键 prd_org_employee.user_id
                        qSaleTargetDO.dutyId
                ))
                .from(qSaleTargetDO)
                .leftJoin(qPrdOrgEmployeeRefDO).on(qPrdOrgEmployeeRefDO.userId.eq(qSaleTargetDO.dutyId))
                .leftJoin(qPrdOrgOrganizationDO).on(qPrdOrgOrganizationDO.id.eq(qPrdOrgEmployeeRefDO.orgId))
                .groupBy(qSaleTargetDO.dutyId)
                .where(predicate);
        final List<SaleTargetVO> fetch = jpaQuery.fetch();
        return fetch;
    }



    public List<SaleTargetVO> countCustomerSaleTarget(SaleTargetCustomerQuery query) {
        List<Predicate> list = new ArrayList<>();
        // 动态条件
        if (null != query.getGoalId()) {
            list.add(qSaleTargetDO.goalId.eq(query.getGoalId()));
        }
        if (null!=query.getCustomerId()){
            list.add(qSaleTargetDO.customerId.eq(query.getCustomerId()));
        }
        if (!ObjectUtils.isEmpty(query.getExt1())) {
            list.add(qSaleTargetDO.ext1.eq(query.getExt1()));
        }
        if (!ObjectUtils.isEmpty(query.getCustomerGrade())){
            list.add(qCrmCustomerDO.customerGrade.eq(query.getCustomerGrade()));
        }
        if (!ObjectUtils.isEmpty(query.getCustomerIndustry())){
            list.add(qdoCompany.companyIndustry.eq(query.getCustomerIndustry()));
        }

        Predicate predicate = ExpressionUtils.allOf(list);
        JPAQuery<SaleTargetVO> jpaQuery = jpaQueryFactory
                .select(Projections.bean(SaleTargetVO.class,
                        // 目标总值
                        qSaleTargetDO.targetCount.sum().as("targetCount")
                ))
                .from(qSaleTargetDO)
                .leftJoin(qCrmCustomerDO).on(qSaleTargetDO.customerId.eq(qCrmCustomerDO.id))
                .leftJoin(qdoAb).on(qdoAb.id.eq(qCrmCustomerDO.bookId))
                .leftJoin(qdoCompany).on(qdoAb.id.eq(qdoCompany.bookId))
                .where(predicate);
        final List<SaleTargetVO> fetch = jpaQuery.fetch();
        return fetch;
    }

    /**
     * 查询客户和用户id
     * @param query
     * @return
     */
    public List<SaleTargetVO> countCustomerIdAndUserId(SaleTargetCustomerQuery query) {
        List<Predicate> list = new ArrayList<>();
        // 动态条件
        if (null != query.getGoalId()) {
            list.add(qSaleTargetDO.goalId.eq(query.getGoalId()));
        }
        if (null!=query.getCustomerId()){
            list.add(qSaleTargetDO.customerId.eq(query.getCustomerId()));
        }
        if (!ObjectUtils.isEmpty(query.getExt1())) {
            list.add(qSaleTargetDO.ext1.eq(query.getExt1()));
        }
        if (!ObjectUtils.isEmpty(query.getCustomerGrade())){
            list.add(qCrmCustomerDO.customerGrade.eq(query.getCustomerGrade()));
        }
        if (!ObjectUtils.isEmpty(query.getCustomerIndustry())){
            list.add(qdoCompany.companyIndustry.eq(query.getCustomerIndustry()));
        }

        Predicate predicate = ExpressionUtils.allOf(list);
        JPAQuery<SaleTargetVO> jpaQuery = jpaQueryFactory
                .select(Projections.bean(SaleTargetVO.class,
                        qSaleTargetDO.dutyId,
                        qSaleTargetDO.customerId
                ))
                .from(qSaleTargetDO)
                .leftJoin(qCrmCustomerDO).on(qSaleTargetDO.customerId.eq(qCrmCustomerDO.id))
                .leftJoin(qdoAb).on(qdoAb.id.eq(qCrmCustomerDO.bookId))
                .leftJoin(qdoCompany).on(qdoAb.id.eq(qdoCompany.bookId))
                .where(predicate)
                .groupBy(qSaleTargetDO.dutyId);
        final List<SaleTargetVO> fetch = jpaQuery.fetch();
        return fetch;
    }


    /**
     *
     * 客户排行榜额定值查询
     * @param goalId
     * @param ext1
     * @return
     */
    public List<SaleTargetVO> countCustomerSaleTarget(Long goalId, String ext1) {
        List<Predicate> list = new ArrayList<>();
        // 动态条件
        if (null != goalId) {
            list.add(qSaleTargetDO.goalId.eq(goalId));
        }
        if (!ObjectUtils.isEmpty(ext1)) {
            list.add(qSaleTargetDO.ext1.eq(ext1));
        }

        Predicate predicate = ExpressionUtils.allOf(list);
        JPAQuery<SaleTargetVO> jpaQuery = jpaQueryFactory
                .select(Projections.bean(SaleTargetVO.class,
                        // 目标总值
                        qSaleTargetDO.targetCount.sum().as("targetCount"),
                        //人员id
                        qSaleTargetDO.dutyId,
                        //客户id
                        qSaleTargetDO.customerId,
                        // 客户名称
                        qSaleTargetDO.customerName
                ))
                .from(qSaleTargetDO)
                .groupBy(qSaleTargetDO.customerId)
                .where(predicate);
        final List<SaleTargetVO> fetch = jpaQuery.fetch();
        return fetch;
    }
    /**
     *
     * 产品排行榜额定值查询
     * @param goalId
     * @param ext1
     * @return
     */
    public List<SaleTargetVO> countProductSaleTarget(Long goalId, String ext1) {
        List<Predicate> list = new ArrayList<>();
        // 动态条件
        if (null != goalId) {
            list.add(qSaleTargetDO.goalId.eq(goalId));
        }
        if (!ObjectUtils.isEmpty(ext1)) {
            list.add(qSaleTargetDO.ext1.eq(ext1));
        }

        Predicate predicate = ExpressionUtils.allOf(list);
        JPAQuery<SaleTargetVO> jpaQuery = jpaQueryFactory
                .select(Projections.bean(SaleTargetVO.class,
                        // 目标总值
                        qSaleTargetDO.targetCount.sum().as("targetCount"),
                        //人员id
                        qSaleTargetDO.dutyId,
                        //产品id
                        qSaleTargetDO.skuId,
                        //产品名称
                        qSaleTargetDO.skuName
                ))
                .from(qSaleTargetDO)
                .groupBy(qSaleTargetDO.skuId)
                .where(predicate);
        final List<SaleTargetVO> fetch = jpaQuery.fetch();
        return fetch;
    }


    public List<SaleTargetVO> countUserOrgSaleTarget(Long goalId, String ext1,Long orgId,Long userId ) {
        List<Predicate> list = new ArrayList<>();
        // 动态条件
        if (null != goalId) {
            list.add(qSaleTargetDO.goalId.eq(goalId));
        }
        if (!ObjectUtils.isEmpty(ext1)) {
            list.add(qSaleTargetDO.ext1.eq(ext1));
        }
        if (!ObjectUtils.isEmpty(userId)) {
            list.add(qSaleTargetDO.dutyId.eq(userId));
        }
        if (!ObjectUtils.isEmpty(orgId)) {
            list.add(qPrdOrgEmployeeRefDO.orgId.eq(orgId));
        }

        //固定条件
        list.add(qPrdOrgEmployeeRefDO.deleteFlag.eq(0));
        list.add(qPrdOrgOrganizationDO.deleteFlag.eq(0));
        list.add(qPrdOrgEmployeeRefDO.isCopy.eq(0));
        list.add(qPrdOrgEmployeeRefDO.isDefault.eq(0));

        Predicate predicate = ExpressionUtils.allOf(list);
        JPAQuery<SaleTargetVO> jpaQuery = jpaQueryFactory
                .select(Projections.bean(SaleTargetVO.class,
                        // 目标总值
                        qSaleTargetDO.targetCount.sum().as("targetCount")
                ))
                .from(qSaleTargetDO)
                .leftJoin(qPrdOrgEmployeeRefDO).on(qPrdOrgEmployeeRefDO.userId.eq(qSaleTargetDO.dutyId))
                .leftJoin(qPrdOrgOrganizationDO).on(qPrdOrgOrganizationDO.id.eq(qPrdOrgEmployeeRefDO.orgId))
                .where(predicate);
        final List<SaleTargetVO> fetch = jpaQuery.fetch();
        return fetch;
}

    public List<SaleTargetVO> countUserIds(Long goalId, String ext1,Long orgId,Long userId ) {
        List<Predicate> list = new ArrayList<>();
        // 动态条件
        if (null != goalId) {
            list.add(qSaleTargetDO.goalId.eq(goalId));
        }
        if (!ObjectUtils.isEmpty(ext1)) {
            list.add(qSaleTargetDO.ext1.eq(ext1));
        }
        if (!ObjectUtils.isEmpty(userId)) {
            list.add(qSaleTargetDO.dutyId.eq(userId));
        }
        if (!ObjectUtils.isEmpty(orgId)) {
            list.add(qPrdOrgEmployeeRefDO.orgId.eq(orgId));
        }

        //固定条件
        list.add(qPrdOrgEmployeeRefDO.deleteFlag.eq(0));
        list.add(qPrdOrgOrganizationDO.deleteFlag.eq(0));
        list.add(qPrdOrgEmployeeRefDO.isCopy.eq(0));
        list.add(qPrdOrgEmployeeRefDO.isDefault.eq(0));

        Predicate predicate = ExpressionUtils.allOf(list);
        JPAQuery<SaleTargetVO> jpaQuery = jpaQueryFactory
                .select(Projections.bean(SaleTargetVO.class,
                        qSaleTargetDO.dutyId
                ))
                .from(qSaleTargetDO)
                .leftJoin(qPrdOrgEmployeeRefDO).on(qPrdOrgEmployeeRefDO.userId.eq(qSaleTargetDO.dutyId))
                .leftJoin(qPrdOrgOrganizationDO).on(qPrdOrgOrganizationDO.id.eq(qPrdOrgEmployeeRefDO.orgId))
                .groupBy(qSaleTargetDO.dutyId)
                .where(predicate);
        final List<SaleTargetVO> fetch = jpaQuery.fetch();
        return fetch;
    }
}

